/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.IOException;
import java.util.List;
import loci.common.Location;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.DimensionSwapper;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Memoizer;
import loci.formats.MinMaxCalculator;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class WrapperTest {
    private static final String TEST_FILE = "test&pixelType=uint8&sizeX=128&sizeY=64&sizeC=2&sizeZ=4&sizeT=5&series=3.fake";

    @DataProvider(name="wrappers")
    public Object[][] createWrappers() {
        Location.mapId((String)TEST_FILE, (String)TEST_FILE);
        Object[][] wrappers = new Object[][]{{new ChannelFiller()}, {new ChannelMerger()}, {new ChannelSeparator()}, {new DimensionSwapper()}, {new FileStitcher()}, {new ImageReader()}, {new MinMaxCalculator()}, {new Memoizer()}};
        for (int i = 0; i < wrappers.length; ++i) {
            IFormatReader reader = (IFormatReader)wrappers[i][0];
            try {
                reader.setId(TEST_FILE);
                continue;
            }
            catch (FormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrappers;
    }

    @Test(dataProvider="wrappers")
    public void testCoreMetadata(IFormatReader reader) {
        AssertJUnit.assertNotNull((Object)reader.getCurrentFile());
        List coreList = reader.getCoreMetadataList();
        AssertJUnit.assertEquals((int)coreList.size(), (int)reader.getSeriesCount());
        for (int i = 0; i < reader.getSeriesCount(); ++i) {
            CoreMetadata core = (CoreMetadata)coreList.get(i);
            reader.setSeries(i);
            AssertJUnit.assertEquals((int)core.sizeX, (int)reader.getSizeX());
            AssertJUnit.assertEquals((int)core.sizeY, (int)reader.getSizeY());
            AssertJUnit.assertEquals((int)core.sizeZ, (int)reader.getSizeZ());
            AssertJUnit.assertEquals((int)core.sizeC, (int)reader.getSizeC());
            AssertJUnit.assertEquals((int)core.sizeT, (int)reader.getSizeT());
            AssertJUnit.assertEquals((int)core.pixelType, (int)reader.getPixelType());
            AssertJUnit.assertEquals((int)core.imageCount, (int)reader.getImageCount());
            AssertJUnit.assertEquals((String)core.dimensionOrder, (String)reader.getDimensionOrder());
            AssertJUnit.assertEquals((boolean)core.littleEndian, (boolean)reader.isLittleEndian());
            AssertJUnit.assertEquals((boolean)core.rgb, (boolean)reader.isRGB());
            AssertJUnit.assertEquals((boolean)core.interleaved, (boolean)reader.isInterleaved());
            AssertJUnit.assertEquals((boolean)core.indexed, (boolean)reader.isIndexed());
        }
    }
}

