/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.IOException;
import java.nio.ByteOrder;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffRational;
import loci.formats.tiff.TiffSaver;

public class BaseTiffMock {
    private ByteArrayHandle handle = new ByteArrayHandle();
    private RandomAccessInputStream in;
    private RandomAccessOutputStream out;
    private TiffParser tiffParser;
    private TiffSaver tiffSaver;
    private static byte[] TIFF_HEADER = new byte[]{73, 73, 42, 0, 8, 0, 0, 0};
    private static final int ENTRY_VALUE_BEGIN_OFFSET = 65535;

    public BaseTiffMock() throws FormatException, IOException {
        this.handle.setOrder(ByteOrder.LITTLE_ENDIAN);
        this.out = new RandomAccessOutputStream((IRandomAccess)this.handle);
        this.tiffSaver = new TiffSaver(this.out, this.handle);
        this.tiffSaver.writeHeader();
        IFD ifd = new IFD();
        ifd.put((Object)256, (Object)this.getImageWidth());
        ifd.put((Object)257, (Object)this.getImageLength());
        ifd.put((Object)258, (Object)this.getBitsPerSample());
        ifd.put((Object)259, (Object)this.getCompression());
        ifd.put((Object)262, (Object)PhotoInterp.RGB.getCode());
        ifd.put((Object)273, (Object)this.getStripOffsets());
        ifd.put((Object)277, (Object)this.getSamplesPerPixel());
        ifd.put((Object)278, (Object)this.getRowsPerStrip());
        ifd.put((Object)282, (Object)this.getXResolution());
        ifd.put((Object)283, (Object)this.getYResolution());
        ifd.put((Object)296, (Object)this.getResolutionUnit());
        this.tiffSaver.writeIFD(ifd, 0L);
        this.in = new RandomAccessInputStream((IRandomAccess)this.handle);
        this.tiffParser = new TiffParser(this.in);
    }

    protected void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        if (this.tiffSaver != null) {
            this.tiffSaver.close();
        }
    }

    protected int getEntryCount() {
        return 11;
    }

    public TiffParser getTiffParser() {
        return this.tiffParser;
    }

    public int getImageWidth() {
        return 6;
    }

    public int getImageLength() {
        return 4;
    }

    public int[] getBitsPerSample() {
        return new int[]{8};
    }

    public int getCompression() {
        return 1;
    }

    public int[] getStripOffsets() {
        return new int[]{0, 1, 2};
    }

    public int[] getRowsPerStrip() {
        return new int[]{2, 2, 2};
    }

    public TiffRational getXResolution() {
        return new TiffRational(1L, 4L);
    }

    public TiffRational getYResolution() {
        return new TiffRational(1L, 2L);
    }

    public short getResolutionUnit() {
        return 1;
    }

    public int getSamplesPerPixel() {
        return 1;
    }
}

