/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.formats.utests.InOutCurrentTest;
import loci.formats.utests.OMEModelMock;
import ome.units.UNITS;
import ome.units.quantity.Power;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Annotation;
import ome.xml.model.Arc;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.Channel;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Filament;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightSource;
import ome.xml.model.ListAnnotation;
import ome.xml.model.LongAnnotation;
import ome.xml.model.Objective;
import ome.xml.model.Pixels;
import ome.xml.model.Plate;
import ome.xml.model.ROI;
import ome.xml.model.Rectangle;
import ome.xml.model.Shape;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TiffData;
import ome.xml.model.TimestampAnnotation;
import ome.xml.model.UUID;
import ome.xml.model.Union;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class ObjectBasedOMEModelMock
implements OMEModelMock {
    private OMEXMLMetadataRoot ome = new OMEXMLMetadataRoot();
    private StructuredAnnotations annotations = new StructuredAnnotations();

    public ObjectBasedOMEModelMock() {
        this.ome.addImage(this.makeImage());
        this.ome.addPlate(this.makePlate());
        this.ome.addInstrument(this.makeInstrument());
        this.ome.addROI(this.makeROI());
        this.ome.setStructuredAnnotations(this.annotations);
    }

    public OMEXMLMetadataRoot getRoot() {
        return this.ome;
    }

    private Image makeImage() {
        Image image = new Image();
        image.setID("Image:0");
        ListAnnotation listAnnotation = new ListAnnotation();
        listAnnotation.setID("Annotation:ImageList0");
        listAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        this.annotations.addListAnnotation(listAnnotation);
        BooleanAnnotation annotation = new BooleanAnnotation();
        annotation.setID("Annotation:ImageBoolean0");
        annotation.setValue(InOutCurrentTest.IMAGE_ANNOTATION_VALUE);
        annotation.setNamespace("test-ome-InOutCurrent-namespace");
        listAnnotation.linkAnnotation((Annotation)annotation);
        image.linkAnnotation((Annotation)listAnnotation);
        this.annotations.addBooleanAnnotation(annotation);
        Pixels pixels = new Pixels();
        pixels.setID("Pixels:0");
        pixels.setSizeX(new PositiveInteger(InOutCurrentTest.SIZE_X));
        pixels.setSizeY(new PositiveInteger(InOutCurrentTest.SIZE_Y));
        pixels.setSizeZ(new PositiveInteger(InOutCurrentTest.SIZE_Z));
        pixels.setSizeC(new PositiveInteger(InOutCurrentTest.SIZE_C));
        pixels.setSizeT(new PositiveInteger(InOutCurrentTest.SIZE_T));
        pixels.setDimensionOrder(InOutCurrentTest.DIMENSION_ORDER);
        pixels.setType(InOutCurrentTest.PIXEL_TYPE);
        TiffData tiffData = new TiffData();
        UUID uuid = new UUID();
        uuid.setValue("6DFA2954-FA9B-4447-A26C-82F9580D9425");
        tiffData.setUUID(uuid);
        pixels.addTiffData(tiffData);
        for (int i = 0; i < InOutCurrentTest.SIZE_C; ++i) {
            Channel channel = new Channel();
            channel.setID("Channel:" + i);
            if (i == 0) {
                XMLAnnotation channelAnnotation = new XMLAnnotation();
                channelAnnotation.setID("Annotation:ChannelXML0");
                channelAnnotation.setValue("<TestData><key>foo</key><value>bar</value></TestData>");
                channelAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
                channel.linkAnnotation((Annotation)channelAnnotation);
                this.annotations.addXMLAnnotation(channelAnnotation);
            }
            pixels.addChannel(channel);
        }
        image.setPixels(pixels);
        return image;
    }

    private Instrument makeInstrument() {
        Instrument instrument = new Instrument();
        instrument.setID("Instrument:0");
        Detector detector = new Detector();
        detector.setID("Detector:0");
        detector.setModel("ReallySensitive!");
        CommentAnnotation detectorAnnotation = new CommentAnnotation();
        detectorAnnotation.setID("Annotation:DetectorString2");
        detectorAnnotation.setValue("Value:String2");
        detectorAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        detector.linkAnnotation((Annotation)detectorAnnotation);
        this.annotations.addCommentAnnotation(detectorAnnotation);
        instrument.addDetector(detector);
        Laser laser = new Laser();
        laser.setID("LightSource:0");
        laser.setModel("ReallyBrightLaser!");
        laser.setType(InOutCurrentTest.LASER_TYPE);
        laser.setPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_LASER_POWER, UNITS.MILLIWATT));
        CommentAnnotation laserAnnotation = new CommentAnnotation();
        laserAnnotation.setID("Annotation:LightSourceLaserString3");
        laserAnnotation.setValue("Value:String3");
        laserAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        laser.linkAnnotation((Annotation)laserAnnotation);
        this.annotations.addCommentAnnotation(laserAnnotation);
        Laser laserPump = new Laser();
        laserPump.setID("LightSource:1");
        laserPump.setModel("ReallyBrightPump!");
        laserPump.setType(InOutCurrentTest.LASER_TYPE);
        laserPump.setPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_PUMP_POWER, UNITS.MILLIWATT));
        laser.linkPump((LightSource)laserPump);
        instrument.addLightSource((LightSource)laser);
        instrument.addLightSource((LightSource)laserPump);
        Arc arc = new Arc();
        arc.setID("LightSource:2");
        arc.setModel("ReallyBrightArc!");
        arc.setType(InOutCurrentTest.ARC_TYPE);
        arc.setPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_ARC_POWER, UNITS.MILLIWATT));
        CommentAnnotation arcAnnotation = new CommentAnnotation();
        arcAnnotation.setID("Annotation:LightSourceArcString4");
        arcAnnotation.setValue("Value:String4");
        arcAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        arc.linkAnnotation((Annotation)arcAnnotation);
        this.annotations.addCommentAnnotation(arcAnnotation);
        instrument.addLightSource((LightSource)arc);
        Filament filament = new Filament();
        filament.setID("LightSource:3");
        filament.setModel("ReallyBrightFilament!");
        filament.setType(InOutCurrentTest.FILAMENT_TYPE);
        filament.setPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_FILAMENT_POWER, UNITS.MILLIWATT));
        CommentAnnotation filamentAnnotation = new CommentAnnotation();
        filamentAnnotation.setID("Annotation:LightSourceFilamentString5");
        filamentAnnotation.setValue("Value:String5");
        filamentAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        filament.linkAnnotation((Annotation)filamentAnnotation);
        this.annotations.addCommentAnnotation(filamentAnnotation);
        instrument.addLightSource((LightSource)filament);
        LightEmittingDiode led = new LightEmittingDiode();
        led.setID("LightSource:4");
        led.setModel("ReallyBrightLED!");
        led.setPower(new Power((Number)InOutCurrentTest.LIGHTSOURCE_LED_POWER, UNITS.MILLIWATT));
        CommentAnnotation ledAnnotation = new CommentAnnotation();
        ledAnnotation.setID("Annotation:LightSourceLEDString6");
        ledAnnotation.setValue("Value:String6");
        ledAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        led.linkAnnotation((Annotation)ledAnnotation);
        this.annotations.addCommentAnnotation(ledAnnotation);
        instrument.addLightSource((LightSource)led);
        Dichroic dichroic = new Dichroic();
        dichroic.setID("Dichroic:0");
        dichroic.setSerialNumber("0123456789");
        CommentAnnotation dichroicAnnotation = new CommentAnnotation();
        dichroicAnnotation.setID("Annotation:DichroicString7");
        dichroicAnnotation.setValue("Value:String7");
        dichroicAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        dichroic.linkAnnotation((Annotation)dichroicAnnotation);
        this.annotations.addCommentAnnotation(dichroicAnnotation);
        FilterSet filterSet = new FilterSet();
        filterSet.setID("FilterSet:0");
        filterSet.setLotNumber("RandomLot");
        filterSet.linkDichroic(dichroic);
        Filter emFilter = new Filter();
        Filter exFilter = new Filter();
        Objective objective = new Objective();
        objective.setID("Objective:0");
        objective.setModel("ReallyClear!");
        CommentAnnotation objectiveAnnotation = new CommentAnnotation();
        objectiveAnnotation.setID("Annotation:ObjectiveString9");
        objectiveAnnotation.setValue("Value:String9");
        objectiveAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        objective.linkAnnotation((Annotation)objectiveAnnotation);
        this.annotations.addCommentAnnotation(objectiveAnnotation);
        emFilter.setID("Filter:0");
        emFilter.setType(InOutCurrentTest.EM_FILTER_TYPE);
        exFilter.setID("Filter:1");
        exFilter.setType(InOutCurrentTest.EX_FILTER_TYPE);
        CommentAnnotation emFilterAnnotation = new CommentAnnotation();
        emFilterAnnotation.setID("Annotation:EmFilterString8");
        emFilterAnnotation.setValue("Value:String8");
        emFilterAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        emFilter.linkAnnotation((Annotation)emFilterAnnotation);
        this.annotations.addCommentAnnotation(emFilterAnnotation);
        instrument.addFilter(emFilter);
        instrument.addFilter(exFilter);
        instrument.addObjective(objective);
        filterSet.linkEmissionFilter(emFilter);
        filterSet.linkExcitationFilter(exFilter);
        filterSet.linkDichroic(dichroic);
        instrument.addFilterSet(filterSet);
        instrument.addDichroic(dichroic);
        CommentAnnotation instrumentAnnotation = new CommentAnnotation();
        instrumentAnnotation.setID("Annotation:InstrumentString1");
        instrumentAnnotation.setValue("Value:String1");
        instrumentAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        instrument.linkAnnotation((Annotation)instrumentAnnotation);
        this.annotations.addCommentAnnotation(instrumentAnnotation);
        Image image = this.ome.getImage(0);
        image.linkInstrument(instrument);
        return instrument;
    }

    private Plate makePlate() {
        Plate plate = new Plate();
        plate.setID("Plate:0");
        plate.setRows(InOutCurrentTest.WELL_ROWS);
        plate.setColumns(InOutCurrentTest.WELL_COLS);
        plate.setRowNamingConvention(InOutCurrentTest.WELL_ROW);
        plate.setColumnNamingConvention(InOutCurrentTest.WELL_COL);
        TimestampAnnotation plateAnnotation = new TimestampAnnotation();
        plateAnnotation.setID("Annotation:PlateTimestamp0");
        plateAnnotation.setValue(new Timestamp("1970-01-01T00:00:00"));
        plateAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        plate.linkAnnotation((Annotation)plateAnnotation);
        this.annotations.addTimestampAnnotation(plateAnnotation);
        int wellSampleIndex = 0;
        for (int row = 0; row < (Integer)InOutCurrentTest.WELL_ROWS.getValue(); ++row) {
            for (int col = 0; col < (Integer)InOutCurrentTest.WELL_COLS.getValue(); ++col) {
                Well well = new Well();
                well.setID(String.format("Well:%d_%d", row, col));
                well.setRow(new NonNegativeInteger(Integer.valueOf(row)));
                well.setColumn(new NonNegativeInteger(Integer.valueOf(col)));
                if (row == 0 && col == 0) {
                    LongAnnotation annotation = new LongAnnotation();
                    annotation.setID("Annotation:WellLong0");
                    annotation.setValue(InOutCurrentTest.WELL_ANNOTATION_VALUE);
                    annotation.setNamespace("test-ome-InOutCurrent-namespace");
                    well.linkAnnotation((Annotation)annotation);
                    this.annotations.addLongAnnotation(annotation);
                }
                WellSample sample = new WellSample();
                sample.setID(String.format("WellSample:%d_%d", row, col));
                sample.setIndex(new NonNegativeInteger(Integer.valueOf(wellSampleIndex)));
                sample.linkImage(this.ome.getImage(0));
                well.addWellSample(sample);
                plate.addWell(well);
                ++wellSampleIndex;
            }
        }
        return plate;
    }

    private ROI makeROI() {
        ROI roi = new ROI();
        roi.setID("ROI:5");
        CommentAnnotation roiAnnotation = new CommentAnnotation();
        roiAnnotation.setID("Annotation:ROIString0");
        roiAnnotation.setValue("Some extra ROI data");
        roiAnnotation.setNamespace("test-ome-InOutCurrent-namespace");
        roi.linkAnnotation((Annotation)roiAnnotation);
        this.annotations.addCommentAnnotation(roiAnnotation);
        Union shapeUnion = new Union();
        Rectangle rect = new Rectangle();
        rect.setID("Shape:0");
        rect.setX(InOutCurrentTest.RECTANGLE_X);
        rect.setY(InOutCurrentTest.RECTANGLE_Y);
        rect.setWidth(InOutCurrentTest.RECTANGLE_WIDTH);
        rect.setHeight(InOutCurrentTest.RECTANGLE_HEIGHT);
        shapeUnion.addShape((Shape)rect);
        roi.setUnion(shapeUnion);
        return roi;
    }
}

