/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.util.Map;
import java.util.ServiceLoader;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;
import ucar.nc2.filter.UnknownFilterException;

public class Filters {
    private static NullFilter nullFilter = new NullFilter();

    public static Filter getFilter(Map<String, Object> properties) throws UnknownFilterException {
        if (properties == null) {
            return nullFilter;
        }
        String name = (String)properties.get("id");
        Object oid = properties.get("nid");
        if ((name == null || name.isEmpty()) && !(oid instanceof Number)) {
            return nullFilter;
        }
        if (name != null && !name.isEmpty()) {
            for (FilterProvider fp : ServiceLoader.load(FilterProvider.class)) {
                if (!fp.canProvide(name)) continue;
                return fp.create(properties);
            }
        }
        int id = ((Short)oid).intValue();
        for (FilterProvider fp : ServiceLoader.load(FilterProvider.class)) {
            if (!fp.canProvide(id)) continue;
            return fp.create(properties);
        }
        throw new UnknownFilterException(id);
    }

    private static class NullFilter
    extends Filter {
        private static final String name = "null";
        private static final int id = 0;

        private NullFilter() {
        }

        @Override
        public String getName() {
            return name;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public byte[] encode(byte[] dataIn) {
            return dataIn;
        }

        @Override
        public byte[] decode(byte[] dataIn) {
            return dataIn;
        }
    }

    public class Keys {
        public static final String NAME = "id";
        public static final String ID = "nid";
        public static final String OPTIONAL = "optional";
        public static final String DATA = "data";
        public static final String ELEM_SIZE = "elementsize";
    }
}

