/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public final class MDIntArray
extends MDAbstractArray<Integer> {
    private static final long serialVersionUID = 1L;
    private int[] flattenedArray;

    public MDIntArray(long[] dimensions) {
        this(new int[MDIntArray.getLength(dimensions, 0L)], MDIntArray.toInt(dimensions), false);
    }

    public MDIntArray(long[] dimensions, long capacityHyperRows) {
        this(new int[MDIntArray.getLength(dimensions, capacityHyperRows)], MDIntArray.toInt(dimensions), false);
    }

    public MDIntArray(int[] flattenedArray, long[] dimensions) {
        this(flattenedArray, MDIntArray.toInt(dimensions), true);
    }

    public MDIntArray(int[] flattenedArray, long[] dimensions, boolean checkdimensions) {
        this(flattenedArray, MDIntArray.toInt(dimensions), checkdimensions);
    }

    public MDIntArray(int[] dimensions) {
        this(new int[MDIntArray.getLength(dimensions, 0)], dimensions, false);
    }

    public MDIntArray(int[] dimensions, int capacityHyperRows) {
        this(new int[MDIntArray.getLength(dimensions, capacityHyperRows)], dimensions, false);
    }

    public MDIntArray(int[] flattenedArray, int[] dimensions) {
        this(flattenedArray, dimensions, true);
    }

    public MDIntArray(int[] flattenedArray, int[] dimensions, boolean checkdimensions) {
        super(dimensions, flattenedArray.length, 0);
        int expectedLength;
        assert (flattenedArray != null);
        if (checkdimensions && flattenedArray.length != (expectedLength = MDIntArray.getLength(dimensions, 0))) {
            throw new IllegalArgumentException("Actual array length " + flattenedArray.length + " does not match expected length " + expectedLength + ".");
        }
        this.flattenedArray = flattenedArray;
    }

    public MDIntArray(int[][] matrix) {
        this(matrix, MDIntArray.getDimensions(matrix));
    }

    public MDIntArray(int[][] matrix, int[] dimensions) {
        super(dimensions, 0, matrix.length);
        int sizeX = dimensions[0];
        int sizeY = dimensions[1];
        int length = MDIntArray.getLength(dimensions, 0);
        this.flattenedArray = new int[length];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(matrix[i], 0, this.flattenedArray, i * sizeY, sizeY);
            ++i;
        }
    }

    public MDIntArray(MDIntArray template) {
        super(template);
        this.flattenedArray = (int[])template.flattenedArray.clone();
    }

    private static int[] getDimensions(int[][] matrix) {
        assert (matrix != null);
        return new int[]{matrix.length, matrix.length == 0 ? 0 : matrix[0].length};
    }

    @Override
    public int capacity() {
        return this.flattenedArray.length;
    }

    @Override
    public Integer getAsObject(int ... indices) {
        return this.get(indices);
    }

    @Override
    public void setToObject(Integer value, int ... indices) {
        this.set((int)value, indices);
    }

    @Override
    public Integer getAsObject(int linearIndex) {
        return this.get(linearIndex);
    }

    @Override
    public void setToObject(Integer value, int linearIndex) {
        this.set((int)value, linearIndex);
    }

    public int[] getAsFlatArray() {
        return this.flattenedArray;
    }

    public int[] getCopyAsFlatArray() {
        return ArrayUtils.subarray(this.flattenedArray, 0, this.dimensions[0] * this.hyperRowLength);
    }

    @Override
    protected void adaptCapacityHyperRows() {
        int[] oldArray = this.flattenedArray;
        this.flattenedArray = new int[this.capacityHyperRows * this.hyperRowLength];
        System.arraycopy(oldArray, 0, this.flattenedArray, 0, Math.min(oldArray.length, this.flattenedArray.length));
    }

    public int get(int ... indices) {
        return this.flattenedArray[this.computeIndex(indices)];
    }

    public int get(int index) {
        return this.flattenedArray[index];
    }

    public int get(int indexX, int indexY) {
        return this.flattenedArray[this.computeIndex(indexX, indexY)];
    }

    public int get(int indexX, int indexY, int indexZ) {
        return this.flattenedArray[this.computeIndex(indexX, indexY, indexZ)];
    }

    public void set(int value, int ... indices) {
        this.flattenedArray[this.computeIndex((int[])indices)] = value;
    }

    public void set(int value, int index) {
        this.flattenedArray[index] = value;
    }

    public void set(int value, int indexX, int indexY) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY)] = value;
    }

    public void set(int value, int indexX, int indexY, int indexZ) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY, (int)indexZ)] = value;
    }

    public int[][] toMatrix() {
        int sizeX = this.dimensions[0];
        int sizeY = this.dimensions[1];
        int[][] result = new int[sizeX][sizeY];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(this.flattenedArray, i * sizeY, result[i], 0, sizeY);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValuesAsFlatArray());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MDIntArray other = (MDIntArray)obj;
        if (!Arrays.equals(this.getValuesAsFlatArray(), other.getValuesAsFlatArray())) {
            return false;
        }
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    private int[] getValuesAsFlatArray() {
        return this.dimensions[0] < this.capacityHyperRows ? this.getCopyAsFlatArray() : this.getAsFlatArray();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.hyperRowLength == 0) {
            this.hyperRowLength = this.computeHyperRowLength(this.dimensions);
        }
        if (this.capacityHyperRows == 0) {
            this.capacityHyperRows = this.dimensions[0];
        }
        if (this.size == 0) {
            this.size = this.hyperRowLength * this.dimensions[0];
        }
    }

    public MDIntArray clone() {
        return new MDIntArray(this);
    }
}

