/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class DefaultColWidthRecord
extends Record {
    public static final short sid = 85;
    private short field_1_col_width;

    public DefaultColWidthRecord() {
    }

    public DefaultColWidthRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 85) {
            throw new RecordFormatException("NOT A DefaultColWidth RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_col_width = in.readShort();
    }

    public void setColWidth(short height) {
        this.field_1_col_width = height;
    }

    public short getColWidth() {
        return this.field_1_col_width;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DEFAULTCOLWIDTH]\n");
        buffer.append("    .colwidth      = ").append(Integer.toHexString(this.getColWidth())).append("\n");
        buffer.append("[/DEFAULTCOLWIDTH]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)85);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.getColWidth());
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 6;
    }

    @Override
    public short getSid() {
        return 85;
    }

    @Override
    public Object clone() {
        DefaultColWidthRecord rec = new DefaultColWidthRecord();
        rec.field_1_col_width = this.field_1_col_width;
        return rec;
    }
}

