/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.dev;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import loci.common.RandomAccessInputStream;
import loci.poi.hssf.record.AreaFormatRecord;
import loci.poi.hssf.record.AreaRecord;
import loci.poi.hssf.record.AxisLineFormatRecord;
import loci.poi.hssf.record.AxisOptionsRecord;
import loci.poi.hssf.record.AxisParentRecord;
import loci.poi.hssf.record.AxisRecord;
import loci.poi.hssf.record.AxisUsedRecord;
import loci.poi.hssf.record.BOFRecord;
import loci.poi.hssf.record.BackupRecord;
import loci.poi.hssf.record.BarRecord;
import loci.poi.hssf.record.BeginRecord;
import loci.poi.hssf.record.BlankRecord;
import loci.poi.hssf.record.BookBoolRecord;
import loci.poi.hssf.record.BoolErrRecord;
import loci.poi.hssf.record.BottomMarginRecord;
import loci.poi.hssf.record.BoundSheetRecord;
import loci.poi.hssf.record.CalcCountRecord;
import loci.poi.hssf.record.CalcModeRecord;
import loci.poi.hssf.record.CategorySeriesAxisRecord;
import loci.poi.hssf.record.ChartFormatRecord;
import loci.poi.hssf.record.ChartRecord;
import loci.poi.hssf.record.CodepageRecord;
import loci.poi.hssf.record.ColumnInfoRecord;
import loci.poi.hssf.record.ContinueRecord;
import loci.poi.hssf.record.CountryRecord;
import loci.poi.hssf.record.DBCellRecord;
import loci.poi.hssf.record.DSFRecord;
import loci.poi.hssf.record.DatRecord;
import loci.poi.hssf.record.DataFormatRecord;
import loci.poi.hssf.record.DateWindow1904Record;
import loci.poi.hssf.record.DefaultColWidthRecord;
import loci.poi.hssf.record.DefaultDataLabelTextPropertiesRecord;
import loci.poi.hssf.record.DefaultRowHeightRecord;
import loci.poi.hssf.record.DeltaRecord;
import loci.poi.hssf.record.DimensionsRecord;
import loci.poi.hssf.record.DrawingGroupRecord;
import loci.poi.hssf.record.DrawingRecordForBiffViewer;
import loci.poi.hssf.record.DrawingSelectionRecord;
import loci.poi.hssf.record.EOFRecord;
import loci.poi.hssf.record.EndRecord;
import loci.poi.hssf.record.ExtSSTRecord;
import loci.poi.hssf.record.ExtendedFormatRecord;
import loci.poi.hssf.record.ExternSheetRecord;
import loci.poi.hssf.record.FilePassRecord;
import loci.poi.hssf.record.FileSharingRecord;
import loci.poi.hssf.record.FnGroupCountRecord;
import loci.poi.hssf.record.FontBasisRecord;
import loci.poi.hssf.record.FontIndexRecord;
import loci.poi.hssf.record.FontRecord;
import loci.poi.hssf.record.FooterRecord;
import loci.poi.hssf.record.FormatRecord;
import loci.poi.hssf.record.FormulaRecord;
import loci.poi.hssf.record.FrameRecord;
import loci.poi.hssf.record.GridsetRecord;
import loci.poi.hssf.record.GutsRecord;
import loci.poi.hssf.record.HCenterRecord;
import loci.poi.hssf.record.HeaderRecord;
import loci.poi.hssf.record.HideObjRecord;
import loci.poi.hssf.record.HorizontalPageBreakRecord;
import loci.poi.hssf.record.IndexRecord;
import loci.poi.hssf.record.InterfaceEndRecord;
import loci.poi.hssf.record.InterfaceHdrRecord;
import loci.poi.hssf.record.IterationRecord;
import loci.poi.hssf.record.LabelRecord;
import loci.poi.hssf.record.LabelSSTRecord;
import loci.poi.hssf.record.LeftMarginRecord;
import loci.poi.hssf.record.LegendRecord;
import loci.poi.hssf.record.LineFormatRecord;
import loci.poi.hssf.record.LinkedDataRecord;
import loci.poi.hssf.record.MMSRecord;
import loci.poi.hssf.record.MergeCellsRecord;
import loci.poi.hssf.record.MulBlankRecord;
import loci.poi.hssf.record.MulRKRecord;
import loci.poi.hssf.record.NameRecord;
import loci.poi.hssf.record.NoteRecord;
import loci.poi.hssf.record.NumberRecord;
import loci.poi.hssf.record.ObjRecord;
import loci.poi.hssf.record.ObjectLinkRecord;
import loci.poi.hssf.record.PaletteRecord;
import loci.poi.hssf.record.PaneRecord;
import loci.poi.hssf.record.PasswordRecord;
import loci.poi.hssf.record.PasswordRev4Record;
import loci.poi.hssf.record.PlotAreaRecord;
import loci.poi.hssf.record.PlotGrowthRecord;
import loci.poi.hssf.record.PrecisionRecord;
import loci.poi.hssf.record.PrintGridlinesRecord;
import loci.poi.hssf.record.PrintHeadersRecord;
import loci.poi.hssf.record.PrintSetupRecord;
import loci.poi.hssf.record.ProtectRecord;
import loci.poi.hssf.record.ProtectionRev4Record;
import loci.poi.hssf.record.RKRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.RefModeRecord;
import loci.poi.hssf.record.RefreshAllRecord;
import loci.poi.hssf.record.RightMarginRecord;
import loci.poi.hssf.record.RowRecord;
import loci.poi.hssf.record.SCLRecord;
import loci.poi.hssf.record.SSTRecord;
import loci.poi.hssf.record.SaveRecalcRecord;
import loci.poi.hssf.record.SelectionRecord;
import loci.poi.hssf.record.SeriesIndexRecord;
import loci.poi.hssf.record.SeriesListRecord;
import loci.poi.hssf.record.SeriesRecord;
import loci.poi.hssf.record.SeriesTextRecord;
import loci.poi.hssf.record.SeriesToChartGroupRecord;
import loci.poi.hssf.record.SharedFormulaRecord;
import loci.poi.hssf.record.SheetPropertiesRecord;
import loci.poi.hssf.record.StringRecord;
import loci.poi.hssf.record.StyleRecord;
import loci.poi.hssf.record.SupBookRecord;
import loci.poi.hssf.record.TabIdRecord;
import loci.poi.hssf.record.TextObjectRecord;
import loci.poi.hssf.record.TextRecord;
import loci.poi.hssf.record.TickRecord;
import loci.poi.hssf.record.TopMarginRecord;
import loci.poi.hssf.record.UnitsRecord;
import loci.poi.hssf.record.UnknownRecord;
import loci.poi.hssf.record.UseSelFSRecord;
import loci.poi.hssf.record.VCenterRecord;
import loci.poi.hssf.record.ValueRangeRecord;
import loci.poi.hssf.record.VerticalPageBreakRecord;
import loci.poi.hssf.record.WSBoolRecord;
import loci.poi.hssf.record.WindowOneRecord;
import loci.poi.hssf.record.WindowProtectRecord;
import loci.poi.hssf.record.WindowTwoRecord;
import loci.poi.hssf.record.WriteAccessRecord;
import loci.poi.hssf.record.WriteProtectRecord;
import loci.poi.poifs.filesystem.DocumentInputStream;
import loci.poi.poifs.filesystem.POIFSFileSystem;
import loci.poi.util.HexDump;

public class BiffViewer {
    String filename;
    private boolean dump;

    public BiffViewer(String[] args) {
        if (args.length > 0) {
            this.filename = args[0];
        } else {
            System.out.println("BIFFVIEWER REQUIRES A FILENAME***");
        }
    }

    public void run() {
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new RandomAccessInputStream(this.filename), 512);
            DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
            BiffViewer.createRecords(stream, this.dump);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Record[] createRecords(InputStream in, boolean dump) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>();
        RecordDetails activeRecord = null;
        try {
            BiffviewRecordInputStream recStream = new BiffviewRecordInputStream(in);
            while (recStream.hasNextRecord()) {
                recStream.nextRecord();
                if (recStream.getSid() == 0) continue;
                Record record = BiffViewer.createRecord(recStream);
                if (record.getSid() != 60) {
                    records.add(record);
                    if (activeRecord != null) {
                        activeRecord.dump();
                    }
                    activeRecord = new RecordDetails(recStream.getSid(), recStream.getLength(), (int)recStream.getPos(), record);
                }
                if (!dump) continue;
                recStream.dumpBytes();
            }
            activeRecord.dump();
        }
        catch (IOException e) {
            throw new RecordFormatException("Error reading bytes", e);
        }
        Record[] retval = new Record[records.size()];
        retval = records.toArray(retval);
        return retval;
    }

    private static void dumpNormal(Record record, int startloc, short rectype, short recsize) {
        System.out.println("Offset 0x" + Integer.toHexString(startloc) + " (" + startloc + ")");
        System.out.println("recordid = 0x" + Integer.toHexString(rectype) + ", size = " + recsize);
        System.out.println(record.toString());
    }

    private static Record createRecord(RecordInputStream in) {
        Record retval = null;
        switch (in.getSid()) {
            case 4098: {
                retval = new ChartRecord(in);
                break;
            }
            case 4116: {
                retval = new ChartFormatRecord(in);
                break;
            }
            case 4099: {
                retval = new SeriesRecord(in);
                break;
            }
            case 4147: {
                retval = new BeginRecord(in);
                break;
            }
            case 4148: {
                retval = new EndRecord(in);
                break;
            }
            case 2057: {
                retval = new BOFRecord(in);
                break;
            }
            case 225: {
                retval = new InterfaceHdrRecord(in);
                break;
            }
            case 193: {
                retval = new MMSRecord(in);
                break;
            }
            case 226: {
                retval = new InterfaceEndRecord(in);
                break;
            }
            case 92: {
                retval = new WriteAccessRecord(in);
                break;
            }
            case 66: {
                retval = new CodepageRecord(in);
                break;
            }
            case 353: {
                retval = new DSFRecord(in);
                break;
            }
            case 317: {
                retval = new TabIdRecord(in);
                break;
            }
            case 156: {
                retval = new FnGroupCountRecord(in);
                break;
            }
            case 25: {
                retval = new WindowProtectRecord(in);
                break;
            }
            case 18: {
                retval = new ProtectRecord(in);
                break;
            }
            case 19: {
                retval = new PasswordRecord(in);
                break;
            }
            case 431: {
                retval = new ProtectionRev4Record(in);
                break;
            }
            case 444: {
                retval = new PasswordRev4Record(in);
                break;
            }
            case 61: {
                retval = new WindowOneRecord(in);
                break;
            }
            case 64: {
                retval = new BackupRecord(in);
                break;
            }
            case 141: {
                retval = new HideObjRecord(in);
                break;
            }
            case 34: {
                retval = new DateWindow1904Record(in);
                break;
            }
            case 14: {
                retval = new PrecisionRecord(in);
                break;
            }
            case 439: {
                retval = new RefreshAllRecord(in);
                break;
            }
            case 218: {
                retval = new BookBoolRecord(in);
                break;
            }
            case 49: {
                retval = new FontRecord(in);
                break;
            }
            case 1054: {
                retval = new FormatRecord(in);
                break;
            }
            case 224: {
                retval = new ExtendedFormatRecord(in);
                break;
            }
            case 659: {
                retval = new StyleRecord(in);
                break;
            }
            case 352: {
                retval = new UseSelFSRecord(in);
                break;
            }
            case 133: {
                retval = new BoundSheetRecord(in);
                break;
            }
            case 140: {
                retval = new CountryRecord(in);
                break;
            }
            case 252: {
                retval = new SSTRecord(in);
                break;
            }
            case 255: {
                retval = new ExtSSTRecord(in);
                break;
            }
            case 10: {
                retval = new EOFRecord(in);
                break;
            }
            case 523: {
                retval = new IndexRecord(in);
                break;
            }
            case 13: {
                retval = new CalcModeRecord(in);
                break;
            }
            case 12: {
                retval = new CalcCountRecord(in);
                break;
            }
            case 15: {
                retval = new RefModeRecord(in);
                break;
            }
            case 17: {
                retval = new IterationRecord(in);
                break;
            }
            case 16: {
                retval = new DeltaRecord(in);
                break;
            }
            case 95: {
                retval = new SaveRecalcRecord(in);
                break;
            }
            case 42: {
                retval = new PrintHeadersRecord(in);
                break;
            }
            case 43: {
                retval = new PrintGridlinesRecord(in);
                break;
            }
            case 130: {
                retval = new GridsetRecord(in);
                break;
            }
            case 235: {
                retval = new DrawingGroupRecord(in);
                break;
            }
            case 236: {
                retval = new DrawingRecordForBiffViewer(in);
                break;
            }
            case 237: {
                retval = new DrawingSelectionRecord(in);
                break;
            }
            case 128: {
                retval = new GutsRecord(in);
                break;
            }
            case 549: {
                retval = new DefaultRowHeightRecord(in);
                break;
            }
            case 129: {
                retval = new WSBoolRecord(in);
                break;
            }
            case 20: {
                retval = new HeaderRecord(in);
                break;
            }
            case 21: {
                retval = new FooterRecord(in);
                break;
            }
            case 131: {
                retval = new HCenterRecord(in);
                break;
            }
            case 132: {
                retval = new VCenterRecord(in);
                break;
            }
            case 161: {
                retval = new PrintSetupRecord(in);
                break;
            }
            case 85: {
                retval = new DefaultColWidthRecord(in);
                break;
            }
            case 512: {
                retval = new DimensionsRecord(in);
                break;
            }
            case 520: {
                retval = new RowRecord(in);
                break;
            }
            case 253: {
                retval = new LabelSSTRecord(in);
                break;
            }
            case 638: {
                retval = new RKRecord(in);
                break;
            }
            case 515: {
                retval = new NumberRecord(in);
                break;
            }
            case 215: {
                retval = new DBCellRecord(in);
                break;
            }
            case 574: {
                retval = new WindowTwoRecord(in);
                break;
            }
            case 29: {
                retval = new SelectionRecord(in);
                break;
            }
            case 60: {
                retval = new ContinueRecord(in);
                break;
            }
            case 516: {
                retval = new LabelRecord(in);
                break;
            }
            case 189: {
                retval = new MulRKRecord(in);
                break;
            }
            case 190: {
                retval = new MulBlankRecord(in);
                break;
            }
            case 513: {
                retval = new BlankRecord(in);
                break;
            }
            case 517: {
                retval = new BoolErrRecord(in);
                break;
            }
            case 125: {
                retval = new ColumnInfoRecord(in);
                break;
            }
            case 229: {
                retval = new MergeCellsRecord(in);
                break;
            }
            case 4122: {
                retval = new AreaRecord(in);
                break;
            }
            case 4102: {
                retval = new DataFormatRecord(in);
                break;
            }
            case 4119: {
                retval = new BarRecord(in);
                break;
            }
            case 4195: {
                retval = new DatRecord(in);
                break;
            }
            case 4196: {
                retval = new PlotGrowthRecord(in);
                break;
            }
            case 4097: {
                retval = new UnitsRecord(in);
                break;
            }
            case 4146: {
                retval = new FrameRecord(in);
                break;
            }
            case 4127: {
                retval = new ValueRangeRecord(in);
                break;
            }
            case 4118: {
                retval = new SeriesListRecord(in);
                break;
            }
            case 4192: {
                retval = new FontBasisRecord(in);
                break;
            }
            case 4134: {
                retval = new FontIndexRecord(in);
                break;
            }
            case 4103: {
                retval = new LineFormatRecord(in);
                break;
            }
            case 4106: {
                retval = new AreaFormatRecord(in);
                break;
            }
            case 4177: {
                retval = new LinkedDataRecord(in);
                break;
            }
            case 6: {
                retval = new FormulaRecord(in);
                break;
            }
            case 4164: {
                retval = new SheetPropertiesRecord(in);
                break;
            }
            case 4132: {
                retval = new DefaultDataLabelTextPropertiesRecord(in);
                break;
            }
            case 4133: {
                retval = new TextRecord(in);
                break;
            }
            case 4161: {
                retval = new AxisParentRecord(in);
                break;
            }
            case 4129: {
                retval = new AxisLineFormatRecord(in);
                break;
            }
            case 430: {
                retval = new SupBookRecord(in);
                break;
            }
            case 23: {
                retval = new ExternSheetRecord(in);
                break;
            }
            case 160: {
                retval = new SCLRecord(in);
                break;
            }
            case 4165: {
                retval = new SeriesToChartGroupRecord(in);
                break;
            }
            case 4166: {
                retval = new AxisUsedRecord(in);
                break;
            }
            case 4125: {
                retval = new AxisRecord(in);
                break;
            }
            case 4128: {
                retval = new CategorySeriesAxisRecord(in);
                break;
            }
            case 4194: {
                retval = new AxisOptionsRecord(in);
                break;
            }
            case 4126: {
                retval = new TickRecord(in);
                break;
            }
            case 4109: {
                retval = new SeriesTextRecord(in);
                break;
            }
            case 4135: {
                retval = new ObjectLinkRecord(in);
                break;
            }
            case 4149: {
                retval = new PlotAreaRecord(in);
                break;
            }
            case 4197: {
                retval = new SeriesIndexRecord(in);
                break;
            }
            case 4117: {
                retval = new LegendRecord(in);
                break;
            }
            case 38: {
                retval = new LeftMarginRecord(in);
                break;
            }
            case 39: {
                retval = new RightMarginRecord(in);
                break;
            }
            case 40: {
                retval = new TopMarginRecord(in);
                break;
            }
            case 41: {
                retval = new BottomMarginRecord(in);
                break;
            }
            case 146: {
                retval = new PaletteRecord(in);
                break;
            }
            case 519: {
                retval = new StringRecord(in);
                break;
            }
            case 24: {
                retval = new NameRecord(in);
                break;
            }
            case 65: {
                retval = new PaneRecord(in);
                break;
            }
            case 1212: {
                retval = new SharedFormulaRecord(in);
                break;
            }
            case 93: {
                retval = new ObjRecord(in);
                break;
            }
            case 438: {
                retval = new TextObjectRecord(in);
                break;
            }
            case 27: {
                retval = new HorizontalPageBreakRecord(in);
                break;
            }
            case 26: {
                retval = new VerticalPageBreakRecord(in);
                break;
            }
            case 134: {
                retval = new WriteProtectRecord(in);
                break;
            }
            case 47: {
                retval = new FilePassRecord(in);
                break;
            }
            case 28: {
                retval = new NoteRecord(in);
                break;
            }
            case 91: {
                retval = new FileSharingRecord(in);
                break;
            }
            default: {
                retval = new UnknownRecord(in);
            }
        }
        return retval;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public static void main(String[] args) {
        try {
            System.setProperty("poi.deserialize.escher", "true");
            if (args.length == 0) {
                System.out.println("Biff viewer needs a filename");
            } else {
                BiffViewer viewer = new BiffViewer(args);
                if (args.length > 1 && args[1].equals("on")) {
                    viewer.setDump(true);
                }
                if (args.length > 1 && args[1].equals("bfd")) {
                    POIFSFileSystem fs = new POIFSFileSystem(new RandomAccessInputStream(args[0]), 512);
                    DocumentInputStream stream = fs.createDocumentInputStream("Workbook");
                    int size = ((InputStream)stream).available();
                    byte[] data = new byte[size];
                    ((InputStream)stream).read(data);
                    HexDump.dump(data, 0L, System.out, 0);
                } else {
                    viewer.run();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class BiffviewRecordInputStream
    extends RecordInputStream {
        public BiffviewRecordInputStream(InputStream in) {
            super(in);
        }

        public void dumpBytes() {
            HexDump.dump(this.data, 0L, this.currentLength);
        }
    }

    static class RecordDetails {
        short rectype;
        short recsize;
        int startloc;
        Record record;

        public RecordDetails(short rectype, short recsize, int startloc, Record record) {
            this.rectype = rectype;
            this.recsize = recsize;
            this.startloc = startloc;
            this.record = record;
        }

        public short getRectype() {
            return this.rectype;
        }

        public short getRecsize() {
            return this.recsize;
        }

        public Record getRecord() {
            return this.record;
        }

        public void dump() throws IOException {
            BiffViewer.dumpNormal(this.record, this.startloc, this.rectype, this.recsize);
        }
    }
}

