/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.TJScalingFactor;

public class TJDecompressor {
    private static final String NO_ASSOC_ERROR = "No JPEG image is associated with this instance";
    protected long handle = 0L;
    protected byte[] jpegBuf = null;
    protected int jpegBufSize = 0;
    protected int jpegWidth = 0;
    protected int jpegHeight = 0;
    protected int jpegSubsamp = -1;
    private ByteOrder byteOrder = null;

    public TJDecompressor() throws Exception {
        this.init();
    }

    public TJDecompressor(byte[] jpegImage) throws Exception {
        this.init();
        this.setJPEGImage(jpegImage, jpegImage.length);
    }

    public TJDecompressor(byte[] jpegImage, int imageSize) throws Exception {
        this.init();
        this.setJPEGImage(jpegImage, imageSize);
    }

    public void setJPEGImage(byte[] jpegImage, int imageSize) throws Exception {
        if (jpegImage == null || imageSize < 1) {
            throw new Exception("Invalid argument in setJPEGImage()");
        }
        this.jpegBuf = jpegImage;
        this.jpegBufSize = imageSize;
        this.decompressHeader(this.jpegBuf, this.jpegBufSize);
    }

    public int getWidth() throws Exception {
        if (this.jpegWidth < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.jpegWidth;
    }

    public int getHeight() throws Exception {
        if (this.jpegHeight < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.jpegHeight;
    }

    public int getSubsamp() throws Exception {
        if (this.jpegSubsamp < 0) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 5) {
            throw new Exception("JPEG header information is invalid");
        }
        return this.jpegSubsamp;
    }

    public byte[] getJPEGBuf() throws Exception {
        if (this.jpegBuf == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.jpegBuf;
    }

    public int getJPEGSize() throws Exception {
        if (this.jpegBufSize < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.jpegBufSize;
    }

    public int getScaledWidth(int desiredWidth, int desiredHeight) throws Exception {
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (desiredWidth < 0 || desiredHeight < 0) {
            throw new Exception("Invalid argument in getScaledWidth()");
        }
        TJScalingFactor[] sf = TJ.getScalingFactors();
        if (desiredWidth == 0) {
            desiredWidth = this.jpegWidth;
        }
        if (desiredHeight == 0) {
            desiredHeight = this.jpegHeight;
        }
        int scaledWidth = this.jpegWidth;
        int scaledHeight = this.jpegHeight;
        for (int i = 0; i < sf.length; ++i) {
            scaledWidth = sf[i].getScaled(this.jpegWidth);
            scaledHeight = sf[i].getScaled(this.jpegHeight);
            if (scaledWidth <= desiredWidth && scaledHeight <= desiredHeight) break;
        }
        if (scaledWidth > desiredWidth || scaledHeight > desiredHeight) {
            throw new Exception("Could not scale down to desired image dimensions");
        }
        return scaledWidth;
    }

    public int getScaledHeight(int desiredWidth, int desiredHeight) throws Exception {
        if (this.jpegWidth < 1 || this.jpegHeight < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (desiredWidth < 0 || desiredHeight < 0) {
            throw new Exception("Invalid argument in getScaledHeight()");
        }
        TJScalingFactor[] sf = TJ.getScalingFactors();
        if (desiredWidth == 0) {
            desiredWidth = this.jpegWidth;
        }
        if (desiredHeight == 0) {
            desiredHeight = this.jpegHeight;
        }
        int scaledWidth = this.jpegWidth;
        int scaledHeight = this.jpegHeight;
        for (int i = 0; i < sf.length; ++i) {
            scaledWidth = sf[i].getScaled(this.jpegWidth);
            scaledHeight = sf[i].getScaled(this.jpegHeight);
            if (scaledWidth <= desiredWidth && scaledHeight <= desiredHeight) break;
        }
        if (scaledWidth > desiredWidth || scaledHeight > desiredHeight) {
            throw new Exception("Could not scale down to desired image dimensions");
        }
        return scaledHeight;
    }

    public void decompress(byte[] dstBuf, int desiredWidth, int pitch, int desiredHeight, int pixelFormat, int flags) throws Exception {
        if (this.jpegBuf == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (dstBuf == null || desiredWidth < 0 || pitch < 0 || desiredHeight < 0 || pixelFormat < 0 || pixelFormat >= 11 || flags < 0) {
            throw new Exception("Invalid argument in decompress()");
        }
        this.decompress(this.jpegBuf, this.jpegBufSize, dstBuf, desiredWidth, pitch, desiredHeight, pixelFormat, flags);
    }

    public byte[] decompress(int desiredWidth, int pitch, int desiredHeight, int pixelFormat, int flags) throws Exception {
        if (desiredWidth < 0 || pitch < 0 || desiredHeight < 0 || pixelFormat < 0 || pixelFormat >= 11 || flags < 0) {
            throw new Exception("Invalid argument in decompress()");
        }
        int pixelSize = TJ.getPixelSize(pixelFormat);
        int scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
        int scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
        if (pitch == 0) {
            pitch = scaledWidth * pixelSize;
        }
        byte[] buf = new byte[pitch * scaledHeight];
        this.decompress(buf, desiredWidth, pitch, desiredHeight, pixelFormat, flags);
        return buf;
    }

    public void decompressToYUV(byte[] dstBuf, int flags) throws Exception {
        if (this.jpegBuf == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (dstBuf == null || flags < 0) {
            throw new Exception("Invalid argument in decompressToYUV()");
        }
        this.decompressToYUV(this.jpegBuf, this.jpegBufSize, dstBuf, flags);
    }

    public byte[] decompressToYUV(int flags) throws Exception {
        if (flags < 0) {
            throw new Exception("Invalid argument in decompressToYUV()");
        }
        if (this.jpegWidth < 1 || this.jpegHeight < 1 || this.jpegSubsamp < 0) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (this.jpegSubsamp >= 5) {
            throw new Exception("JPEG header information is invalid");
        }
        byte[] buf = new byte[TJ.bufSizeYUV(this.jpegWidth, this.jpegHeight, this.jpegSubsamp)];
        this.decompressToYUV(buf, flags);
        return buf;
    }

    public void decompress(BufferedImage dstImage, int flags) throws Exception {
        int pixelFormat;
        if (dstImage == null || flags < 0) {
            throw new Exception("Invalid argument in decompress()");
        }
        int desiredWidth = dstImage.getWidth();
        int desiredHeight = dstImage.getHeight();
        int scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
        int scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
        if (scaledWidth != desiredWidth || scaledHeight != desiredHeight) {
            throw new Exception("BufferedImage dimensions do not match a scaled image size that TurboJPEG is capable of generating.");
        }
        boolean intPixels = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (dstImage.getType()) {
            case 5: {
                pixelFormat = 1;
                break;
            }
            case 6: 
            case 7: {
                pixelFormat = 4;
                break;
            }
            case 10: {
                pixelFormat = 6;
                break;
            }
            case 4: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                intPixels = true;
                break;
            }
            case 1: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                intPixels = true;
                break;
            }
            case 2: 
            case 3: {
                pixelFormat = this.byteOrder == ByteOrder.BIG_ENDIAN ? 10 : 8;
                intPixels = true;
                break;
            }
            default: {
                throw new Exception("Unsupported BufferedImage format");
            }
        }
        WritableRaster wr = dstImage.getRaster();
        if (intPixels) {
            SinglePixelPackedSampleModel sm = (SinglePixelPackedSampleModel)dstImage.getSampleModel();
            int pitch = sm.getScanlineStride();
            DataBufferInt db = (DataBufferInt)wr.getDataBuffer();
            int[] buf = db.getData();
            if (this.jpegBuf == null) {
                throw new Exception(NO_ASSOC_ERROR);
            }
            this.decompress(this.jpegBuf, this.jpegBufSize, buf, scaledWidth, pitch, scaledHeight, pixelFormat, flags);
        } else {
            ComponentSampleModel sm = (ComponentSampleModel)dstImage.getSampleModel();
            int pixelSize = sm.getPixelStride();
            if (pixelSize != TJ.getPixelSize(pixelFormat)) {
                throw new Exception("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            int pitch = sm.getScanlineStride();
            DataBufferByte db = (DataBufferByte)wr.getDataBuffer();
            byte[] buf = db.getData();
            this.decompress(buf, scaledWidth, pitch, scaledHeight, pixelFormat, flags);
        }
    }

    public BufferedImage decompress(int desiredWidth, int desiredHeight, int bufferedImageType, int flags) throws Exception {
        if (desiredWidth < 0 || desiredHeight < 0 || flags < 0) {
            throw new Exception("Invalid argument in decompress()");
        }
        int scaledWidth = this.getScaledWidth(desiredWidth, desiredHeight);
        int scaledHeight = this.getScaledHeight(desiredWidth, desiredHeight);
        BufferedImage img = new BufferedImage(scaledWidth, scaledHeight, bufferedImageType);
        this.decompress(img, flags);
        return img;
    }

    public void close() throws Exception {
        this.destroy();
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private native void init() throws Exception;

    private native void destroy() throws Exception;

    private native void decompressHeader(byte[] var1, int var2) throws Exception;

    private native void decompress(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8) throws Exception;

    private native void decompress(byte[] var1, int var2, int[] var3, int var4, int var5, int var6, int var7, int var8) throws Exception;

    private native void decompressToYUV(byte[] var1, int var2, byte[] var3, int var4) throws Exception;

    static {
        TJLoader.load();
    }
}

