/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class IterationRecord
extends Record {
    public static final short sid = 17;
    private short field_1_iteration;

    public IterationRecord() {
    }

    public IterationRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 17) {
            throw new RecordFormatException("NOT An ITERATION RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_iteration = in.readShort();
    }

    public void setIteration(boolean iterate) {
        this.field_1_iteration = iterate ? (short)1 : 0;
    }

    public boolean getIteration() {
        return this.field_1_iteration == 1;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ITERATION]\n");
        buffer.append("    .iteration      = ").append(this.getIteration()).append("\n");
        buffer.append("[/ITERATION]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)17);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_iteration);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 6;
    }

    @Override
    public short getSid() {
        return 17;
    }

    @Override
    public Object clone() {
        IterationRecord rec = new IterationRecord();
        rec.field_1_iteration = this.field_1_iteration;
        return rec;
    }
}

