/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.formats.ImageReader;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IsThisTypeTests {
    private static final String TEST_FILE = "test.h5";
    private static final long TIMEOUT = 2000L;
    private ImageReader openReader;
    private ImageReader noOpenReader;

    @BeforeMethod
    public void setUp() {
        this.openReader = new ImageReader();
        this.noOpenReader = new ImageReader();
        this.noOpenReader.setAllowOpenFiles(false);
    }

    @Test
    public void testAccuracy() {
        boolean openReaderIsValid = this.openReader.isThisType(TEST_FILE);
        boolean noOpenReaderIsValid = this.noOpenReader.isThisType(TEST_FILE);
        AssertJUnit.assertEquals((boolean)openReaderIsValid, (boolean)noOpenReaderIsValid);
        AssertJUnit.assertEquals((boolean)openReaderIsValid, (boolean)false);
    }

    @Test
    public void testTypeCheckingSpeed() {
        long t0 = System.currentTimeMillis();
        this.openReader.isThisType(TEST_FILE);
        long t1 = System.currentTimeMillis();
        this.noOpenReader.isThisType(TEST_FILE);
        long t2 = System.currentTimeMillis();
        AssertJUnit.assertTrue((t1 - t0 < 2000L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((t2 - t1 < 2000L ? 1 : 0) != 0);
    }
}

