/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.IRandomAccess;

public class FileHandle
implements IRandomAccess {
    protected RandomAccessFile raf;

    public FileHandle(File file2, String mode) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file2, mode);
    }

    public FileHandle(String name, String mode) throws FileNotFoundException {
        this.raf = new RandomAccessFile(name, mode);
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    @Override
    public boolean exists() throws IOException {
        return this.length() >= 0L;
    }

    @Override
    public long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raf.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        return this.read(buffer, 0, buffer.capacity());
    }

    @Override
    public int read(ByteBuffer buffer, int off, int len) throws IOException {
        byte[] b = new byte[len];
        int n = this.read(b);
        buffer.put(b, off, len);
        return n;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    @Override
    public void write(ByteBuffer buf, int off, int len) throws IOException {
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.raf.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.raf.readFully(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.raf.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        if (n < 1L) {
            return 0L;
        }
        long currentPosition = this.getFilePointer();
        if ((n = Math.min(n, this.length() - currentPosition)) <= Integer.MAX_VALUE) {
            return this.skipBytes((int)n);
        }
        this.seek(currentPosition + n);
        return n;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.raf.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.raf.write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.raf.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.raf.writeByte(v);
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        this.raf.writeBytes(s2);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.raf.writeChar(v);
    }

    @Override
    public void writeChars(String s2) throws IOException {
        this.raf.writeChars(s2);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.raf.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.raf.writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.raf.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.raf.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.raf.writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.raf.writeUTF(str);
    }

    @Override
    public ByteOrder getOrder() {
        return null;
    }

    @Override
    public void setOrder(ByteOrder order) {
    }
}

