/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.filter.Enhancement;
import ucar.nc2.filter.ScaleOffset;

public class Standardizer
implements Enhancement {
    private final ScaleOffset scaleOffset;
    private final double mean;
    private final double stdDev;

    public static Standardizer createFromVariable(VariableDS var) {
        try {
            Array arr = var.read();
            DataType type = var.getDataType();
            return Standardizer.createFromArray(arr, type);
        }
        catch (IOException e) {
            return new Standardizer(0.0, 1.0, var.getDataType());
        }
    }

    public static Standardizer createFromArray(Array arr, DataType type) {
        SummaryStatistics statistics = Standardizer.calculationHelper(arr);
        if (statistics.getStandardDeviation() == 0.0) {
            return new Standardizer(0.0, 1.0, type);
        }
        return new Standardizer(statistics.getMean(), statistics.getStandardDeviation(), type);
    }

    private Standardizer(double mean, double stdDev, DataType type) {
        this.mean = mean;
        this.stdDev = stdDev;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("offset", mean);
        props.put("scale", 1.0 / stdDev);
        props.put("dtype", (Object)type);
        this.scaleOffset = new ScaleOffset(props);
    }

    private static SummaryStatistics calculationHelper(Array arr) {
        SummaryStatistics sumStat = new SummaryStatistics();
        IndexIterator iterArr = arr.getIndexIterator();
        while (iterArr.hasNext()) {
            Number value = (Number)iterArr.getObjectNext();
            if (Double.isNaN(value.doubleValue())) continue;
            sumStat.addValue(value.doubleValue());
        }
        return sumStat;
    }

    public Array convert(Array arr) {
        return this.scaleOffset.applyScaleOffset(arr);
    }

    @Override
    public double convert(double val) {
        return this.scaleOffset.applyScaleOffset(val);
    }

    public double getMean() {
        return this.mean;
    }

    public double getStdDev() {
        return this.stdDev;
    }
}

