/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CancelTask;

public class HdfEosOmiConvention
extends CoordSysBuilder {
    public static boolean isMine(NetcdfFile ncfile) {
        if (!ncfile.getFileTypeId().equals("HDF5-EOS")) {
            return false;
        }
        String typeName = ncfile.findAttValueIgnoreCase(null, "featureType", null);
        if (typeName == null) {
            return false;
        }
        if (!typeName.equals(FeatureType.GRID.toString()) && !typeName.equals(FeatureType.SWATH.toString())) {
            return false;
        }
        Attribute instName = ncfile.findAttribute("/HDFEOS/ADDITIONAL/FILE_ATTRIBUTES/@InstrumentName");
        if (instName == null || !instName.getStringValue().equals("OMI")) {
            return false;
        }
        Attribute level = ncfile.findAttribute("/HDFEOS/ADDITIONAL/FILE_ATTRIBUTES/@ProcessLevel");
        if (level == null) {
            return false;
        }
        return level.getStringValue().startsWith("2") || level.getStringValue().startsWith("3");
    }

    public HdfEosOmiConvention() {
        this.conventionName = "HDF5-EOS-OMI";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        int level;
        Attribute levelAtt = ds.findAttribute("/HDFEOS/ADDITIONAL/FILE_ATTRIBUTES/@ProcessLevel");
        if (levelAtt == null) {
            return;
        }
        int n = level = levelAtt.getStringValue().startsWith("2") ? 2 : 3;
        if (level == 3) {
            this.augmentDataset3(ds);
        }
    }

    private void augmentDataset3(NetcdfDataset ds) {
        Group grids = ds.findGroup("/HDFEOS/GRIDS");
        if (grids == null) {
            return;
        }
        for (Group g2 : grids.getGroups()) {
            Attribute gctp = g2.findAttribute("GCTPProjectionCode");
            if (gctp == null || !gctp.getNumericValue().equals(0)) continue;
            Attribute nlon = g2.findAttribute("NumberOfLongitudesInGrid");
            Attribute nlat = g2.findAttribute("NumberOfLatitudesInGrid");
            if (nlon == null || nlon.isString() || nlat == null || nlat.isString()) continue;
            ds.addCoordinateAxis(this.makeLonCoordAxis(ds, g2, nlon.getNumericValue().intValue(), "XDim"));
            ds.addCoordinateAxis(this.makeLatCoordAxis(ds, g2, nlat.getNumericValue().intValue(), "YDim"));
            for (Group g3 : g2.getGroups()) {
                for (Variable v : g3.getVariables()) {
                    v.addAttribute(new Attribute("_CoordinateAxes", "lat lon"));
                }
            }
        }
        ds.finish();
    }

    private CoordinateAxis makeLatCoordAxis(NetcdfDataset ds, Group g2, int n, String dimName) {
        double incr = 180.0 / (double)n;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, g2, "lat", DataType.FLOAT, dimName, "degrees_north", "latitude");
        v.setValues(n, -90.0 + 0.5 * incr, incr);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        return v;
    }

    private CoordinateAxis makeLonCoordAxis(NetcdfDataset ds, Group g2, int n, String dimName) {
        double incr = 360.0 / (double)n;
        CoordinateAxis1D v = new CoordinateAxis1D(ds, g2, "lon", DataType.FLOAT, dimName, "degrees_east", "longitude");
        v.setValues(n, -180.0 + 0.5 * incr, incr);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        return v;
    }
}

