/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageWriter;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;

public class FileExport {
    private ImageWriter writer;
    private String outputFile;

    public FileExport(String outputFile) {
        this.outputFile = outputFile;
    }

    public void export() {
        int width = 512;
        int height = 512;
        int pixelType = 3;
        IMetadata omexml = this.initializeMetadata(width, height, pixelType);
        boolean initializationSuccess = this.initializeWriter(omexml);
        if (initializationSuccess) {
            this.savePlane(width, height, pixelType);
        }
        this.cleanup();
    }

    private boolean initializeWriter(IMetadata omexml) {
        this.writer = new ImageWriter();
        this.writer.setMetadataRetrieve((MetadataRetrieve)omexml);
        Throwable exception = null;
        try {
            this.writer.setId(this.outputFile);
        }
        catch (FormatException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if (exception != null) {
            System.err.println("Failed to initialize file writer.");
            exception.printStackTrace();
        }
        return exception == null;
    }

    private IMetadata initializeMetadata(int width, int height, int pixelType) {
        Throwable exception = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            OMEXMLMetadata meta = service.createOMEXMLMetadata();
            meta.createRoot();
            meta.setImageID("Image:0", 0);
            meta.setPixelsID("Pixels:0", 0);
            meta.setPixelsBinDataBigEndian(Boolean.TRUE, 0, 0);
            meta.setPixelsDimensionOrder(DimensionOrder.XYZCT, 0);
            meta.setPixelsType(PixelType.fromString((String)FormatTools.getPixelTypeString((int)pixelType)), 0);
            meta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(width)), 0);
            meta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(height)), 0);
            meta.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(1)), 0);
            meta.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), 0);
            meta.setPixelsSizeT(new PositiveInteger(Integer.valueOf(1)), 0);
            meta.setChannelID("Channel:0:0", 0, 0);
            meta.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), 0, 0);
            return meta;
        }
        catch (DependencyException e) {
            exception = e;
        }
        catch (ServiceException e) {
            exception = e;
        }
        catch (EnumerationException e) {
            exception = e;
        }
        System.err.println("Failed to populate OME-XML metadata object.");
        exception.printStackTrace();
        return null;
    }

    private void savePlane(int width, int height, int pixelType) {
        byte[] plane = this.createImage(width, height, pixelType);
        Throwable exception = null;
        try {
            this.writer.saveBytes(0, plane);
        }
        catch (FormatException e) {
            exception = e;
        }
        catch (IOException e) {
            exception = e;
        }
        if (exception != null) {
            System.err.println("Failed to save plane.");
            exception.printStackTrace();
        }
    }

    private byte[] createImage(int width, int height, int pixelType) {
        byte[] img = new byte[width * height * FormatTools.getBytesPerPixel((int)pixelType)];
        for (int i = 0; i < img.length; ++i) {
            img[i] = (byte)(256.0 * Math.random());
        }
        return img;
    }

    private void cleanup() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close file writer.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        FileExport exporter = new FileExport(args[0]);
        exporter.export();
    }
}

