/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import loci.formats.ChannelFiller;
import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.utests.ModelMock;
import loci.formats.utests.SPWModelMock;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPWModelReaderTest {
    private SPWModelMock mock;
    private SPWModelMock mockWithNoLightSources;
    private File temporaryFile;
    private File temporaryFileWithNoLightSources;
    private IFormatReader reader;
    private IFormatReader readerWithNoLightSources;
    private IMetadata metadata;
    private IMetadata metadataWithNoLightSources;

    @BeforeClass
    public void setUp() throws Exception {
        this.mock = new SPWModelMock(true);
        this.mockWithNoLightSources = new SPWModelMock(false);
        this.temporaryFile = File.createTempFile(this.getClass().getName(), ".ome");
        this.temporaryFileWithNoLightSources = File.createTempFile(this.getClass().getName(), ".ome");
        SPWModelReaderTest.writeMockToFile(this.mock, this.temporaryFile, true);
        SPWModelReaderTest.writeMockToFile(this.mockWithNoLightSources, this.temporaryFileWithNoLightSources, true);
    }

    public static void writeMockToFile(ModelMock mock, File file, boolean withBinData) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = mock.getRoot().asXMLElement(document);
        SPWModelMock.postProcess(root, document, withBinData);
        FileOutputStream stream = new FileOutputStream(file);
        ((OutputStream)stream).write(SPWModelMock.asString(document).getBytes());
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.temporaryFile.delete();
        this.temporaryFileWithNoLightSources.delete();
    }

    @Test
    public void testSetId() throws Exception {
        this.reader = new MinMaxCalculator((IFormatReader)new ChannelSeparator((IFormatReader)new ChannelFiller((IFormatReader)new ImageReader())));
        this.metadata = new OMEXMLMetadataImpl();
        this.reader.setMetadataStore((MetadataStore)this.metadata);
        this.reader.setId(this.temporaryFile.getAbsolutePath());
    }

    @Test
    public void testSetIdWithNoLightSources() throws Exception {
        this.readerWithNoLightSources = new MinMaxCalculator((IFormatReader)new ChannelSeparator((IFormatReader)new ChannelFiller((IFormatReader)new ImageReader())));
        this.metadataWithNoLightSources = new OMEXMLMetadataImpl();
        this.readerWithNoLightSources.setMetadataStore((MetadataStore)this.metadataWithNoLightSources);
        this.readerWithNoLightSources.setId(this.temporaryFileWithNoLightSources.getAbsolutePath());
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testSeriesCount() {
        AssertJUnit.assertEquals((int)384, (int)this.reader.getSeriesCount());
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testCanReadEveryPlane() throws Exception {
        AssertJUnit.assertTrue((boolean)SPWModelReaderTest.canReadEveryPlane(this.reader));
    }

    @Test(dependsOnMethods={"testSetIdWithNoLightSources"})
    public void testCanReadEveryPlaneWithNoLightSources() throws Exception {
        AssertJUnit.assertTrue((boolean)SPWModelReaderTest.canReadEveryPlane(this.readerWithNoLightSources));
    }

    public static boolean canReadEveryPlane(IFormatReader reader) throws Exception {
        int sizeX = reader.getSizeX();
        int sizeY = reader.getSizeY();
        int pixelType = reader.getPixelType();
        int bytesPerPixel = SPWModelReaderTest.getBytesPerPixel(pixelType);
        byte[] buf = new byte[sizeX * sizeY * bytesPerPixel];
        for (int i = 0; i < reader.getSeriesCount(); ++i) {
            reader.setSeries(i);
            for (int j = 0; j < reader.getImageCount(); ++j) {
                MessageDigest md;
                try {
                    md = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
                }
                buf = reader.openBytes(j, buf);
                try {
                    md.update(buf);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return true;
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testHasLightSources() {
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getInstrumentCount());
        AssertJUnit.assertEquals((int)5, (int)this.metadata.getLightSourceCount(0));
    }

    @Test(dependsOnMethods={"testSetIdWithNoLightSources"})
    public void testHasNoLightSources() {
        AssertJUnit.assertEquals((int)1, (int)this.metadataWithNoLightSources.getInstrumentCount());
        AssertJUnit.assertEquals((int)0, (int)this.metadataWithNoLightSources.getLightSourceCount(0));
    }

    public static int getBytesPerPixel(int type) {
        switch (type) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new RuntimeException("Unknown type with id: '" + type + "'");
    }
}

