/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolver;
import org.apache.commons.math.analysis.UnivariateRealSolverFactory;

public class UnivariateRealSolverUtils {
    private static UnivariateRealSolverFactory factory = null;

    private UnivariateRealSolverUtils() {
    }

    public static double solve(UnivariateRealFunction f, double x0, double x1) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f);
        return factory.newDefaultSolver(f).solve(x0, x1);
    }

    public static double solve(UnivariateRealFunction f, double x0, double x1, double absoluteAccuracy) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup(f);
        UnivariateRealSolver solver = factory.newDefaultSolver(f);
        solver.setAbsoluteAccuracy(absoluteAccuracy);
        return solver.solve(x0, x1);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound) throws ConvergenceException, FunctionEvaluationException {
        return UnivariateRealSolverUtils.bracket(function, initial, lowerBound, upperBound, Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) throws ConvergenceException, FunctionEvaluationException {
        double fb;
        double fa;
        if (function == null) {
            throw new IllegalArgumentException("function is null.");
        }
        if (maximumIterations <= 0) {
            throw new IllegalArgumentException("bad value for maximumIterations: " + maximumIterations);
        }
        if (initial < lowerBound || initial > upperBound || lowerBound >= upperBound) {
            throw new IllegalArgumentException("Invalid endpoint parameters:  lowerBound=" + lowerBound + " initial=" + initial + " upperBound=" + upperBound);
        }
        double a = initial;
        double b = initial;
        int numIterations = 0;
        do {
            a = Math.max(a - 1.0, lowerBound);
            b = Math.min(b + 1.0, upperBound);
        } while ((fa = function.value(a)) * (fb = function.value(b)) > 0.0 && ++numIterations < maximumIterations && (a > lowerBound || b < upperBound));
        if (fa * fb >= 0.0) {
            throw new ConvergenceException("Number of iterations={0}, maximum iterations={1}, initial={2}, lower bound={3}, upper bound={4}, final a value={5}, final b value={6}, f(a)={7}, f(b)={8}", new Object[]{new Integer(numIterations), new Integer(maximumIterations), new Double(initial), new Double(lowerBound), new Double(upperBound), new Double(a), new Double(b), new Double(fa), new Double(fb)});
        }
        return new double[]{a, b};
    }

    public static double midpoint(double a, double b) {
        return (a + b) * 0.5;
    }

    private static void setup(UnivariateRealFunction f) {
        if (f == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        if (factory == null) {
            factory = UnivariateRealSolverFactory.newInstance();
        }
    }
}

