/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;

public class SimpleTrajectory
extends TableConfigurerImpl {
    private static String timeDimName = "time";
    private static String timeVarName = "time";
    private static String latVarName = "latitude";
    private static String lonVarName = "longitude";
    private static String elevVarName = "altitude";

    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        List<Dimension> list = ds.getRootGroup().getDimensions();
        if (list.size() != 1) {
            return false;
        }
        Dimension d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return false;
        }
        Variable var = ds.getRootGroup().findVariable(timeVarName);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return false;
        }
        String units = var.findAttribute("units").getStringValue();
        Date date = DateUnit.getStandardDate("0 " + units);
        if (date == null) {
            return false;
        }
        var = ds.getRootGroup().findVariable(latVarName);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return false;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_north")) {
            return false;
        }
        var = ds.getRootGroup().findVariable(lonVarName);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return false;
        }
        units = var.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(units, "degrees_east")) {
            return false;
        }
        var = ds.getRootGroup().findVariable(elevVarName);
        if (var == null) {
            return false;
        }
        list = var.getDimensions();
        if (list.size() != 1) {
            return false;
        }
        d = list.get(0);
        if (!d.getShortName().equals(timeDimName)) {
            return false;
        }
        units = var.findAttribute("units").getStringValue();
        return SimpleUnit.isCompatible(units, "meters");
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        PointConfigXML reader = new PointConfigXML();
        return reader.readConfigXMLfromResource("resources/nj22/pointConfig/SimpleTrajectory.xml", wantFeatureType, ds, errlog);
    }
}

