/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.LUT;
import java.io.IOException;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AutoscaleTest {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AutoscaleTest.class);
    private static final int WIDTH = 51;
    private static final int HEIGHT = 16;
    private static final int CROP_X = 5;
    private static final int CROP_Y = 10;
    private static final Region CROP_REGION = new Region(5, 10, 41, 6);

    @Test
    public void testAutoscale() {
        boolean ui08 = true;
        int ui16 = 3;
        int ui32 = 5;
        boolean si08 = false;
        int si16 = 2;
        int si32 = 4;
        int f32 = 6;
        int f64 = 7;
        double sMin08 = -128.0;
        double sMax08 = 127.0;
        double sMin16 = -32768.0;
        double sMax16 = 32767.0;
        double sMin32 = -2.147483648E9;
        double sMax32 = 2.147483647E9;
        double uMin08 = 0.0;
        double uMax08 = 255.0;
        double uMin16 = 0.0;
        double uMax16 = 65535.0;
        double uMin32 = 0.0;
        double uMax32 = 4.294967295E9;
        double noCal = 0.0;
        double eMin = 0.0;
        double eMax = 50.0;
        double esMax08 = -78.0;
        double esMax16 = -32718.0;
        double esMax32 = -2.147483598E9;
        this.test(1, 0.0, 0.0, 255.0);
        this.test(3, 0.0, 0.0, 65535.0);
        this.test(5, 0.0, 0.0, 4.294967296E9);
        this.test(0, -128.0, -128.0, 127.0);
        this.test(2, -32768.0, -32768.0, 32767.0);
        this.test(4, 0.0, -2.147483648E9, 2.147483648E9);
        this.test(6, 0.0, 0.0, 50.0);
        this.test(7, 0.0, 0.0, 50.0);
        this.testA(1, 0.0, 0.0, 50.0);
        this.testA(3, 0.0, 0.0, 50.0);
        this.testA(5, 0.0, 0.0, 50.0);
        this.testA(0, -128.0, -128.0, 0.0);
        this.testA(2, -32768.0, -32768.0, 0.0);
        this.testA(4, 0.0, -2.147483648E9, 0.0);
        this.testA(6, 0.0, 0.0, 50.0);
        this.testA(7, 0.0, 0.0, 50.0);
        this.testC(1, 0.0, 0.0, 50.0);
        this.testC(3, 0.0, 0.0, 50.0);
        this.testC(5, 0.0, 0.0, 50.0);
        this.testC(0, -128.0, -128.0, -78.0);
        this.testC(2, -32768.0, -32768.0, -32718.0);
        this.testC(6, 0.0, 0.0, 50.0);
        this.testC(7, 0.0, 0.0, 50.0);
        this.test(1, 0.0, 0.0, 255.0, 0.0, 255.0, 0.0, 255.0);
        this.test(3, 0.0, 0.0, 65535.0, 0.0, 65535.0, 0.0, 65535.0);
        this.test(5, 0.0, 0.0, 4.294967295E9, 0.0, 4.294967295E9, 0.0, 4.294967295E9);
        this.test(0, -128.0, -128.0, 127.0, -128.0, 127.0, -128.0, 127.0);
        this.test(2, -32768.0, -32768.0, 32767.0, -32768.0, 32767.0, -32768.0, 32767.0);
        this.test(4, 0.0, -2.147483648E9, 2.147483647E9, -2.147483648E9, 2.147483647E9, -2.147483648E9, 2.147483647E9);
        this.test(6, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.test(7, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testA(1, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testA(3, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testA(5, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testA(0, -128.0, -128.0, 0.0, -128.0, 1.0, -128.0, 2.0);
        this.testA(2, -32768.0, -32768.0, 0.0, -32768.0, 1.0, -32768.0, 2.0);
        this.testA(4, 0.0, -2.147483648E9, 0.0, -2.147483648E9, 1.0, -2.147483648E9, 2.0);
        this.testA(6, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testA(7, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testC(1, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testC(3, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testC(5, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testC(0, -128.0, -128.0, -78.0, -128.0, -78.0, -128.0, -78.0);
        this.testC(2, -32768.0, -32768.0, -32718.0, -32768.0, -32718.0, -32768.0, -32718.0);
        this.testC(4, 0.0, -2.147483648E9, -2.147483598E9, -2.147483648E9, -2.147483598E9, -2.147483648E9, -2.147483598E9);
        this.testC(6, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
        this.testC(7, 0.0, 0.0, 50.0, 0.0, 50.0, 0.0, 50.0);
    }

    private void test(int pixelType, double calib, double min, double max) {
        this.test(pixelType, false, false, calib, min, max);
    }

    private void testA(int pixelType, double calib, double min, double max) {
        this.test(pixelType, true, false, calib, min, max);
    }

    private void testC(int pixelType, double calib, double min, double max) {
        this.test(pixelType, true, true, calib, min + 5.0, max - 5.0);
    }

    private void test(int pixelType, double calib, double min1, double max1, double min2, double max2, double min3, double max3) {
        this.test(pixelType, false, false, calib, min1, max1, min2, max2, min3, max3);
    }

    private void testA(int pixelType, double calib, double min1, double max1, double min2, double max2, double min3, double max3) {
        this.test(pixelType, true, false, calib, min1, max1, min2, max2, min3, max3);
    }

    private void testC(int pixelType, double calib, double min1, double max1, double min2, double max2, double min3, double max3) {
        this.test(pixelType, true, true, calib, min1 + 5.0, max1 - 5.0, min2 + 5.0, max2 - 5.0, min3 + 5.0, max3 - 5.0);
    }

    private void test(int pixelType, boolean autoscale, boolean crop, double calib, double min, double max) {
        ImagePlus imp = this.setup(pixelType, autoscale, crop, calib, 1);
        double actualMin = imp.getDisplayRangeMin();
        double actualMax = imp.getDisplayRangeMax();
        Assert.assertEquals((double)(min - calib), (double)actualMin, (double)0.0);
        Assert.assertEquals((double)(max - calib), (double)actualMax, (double)0.0);
    }

    private void test(int pixelType, boolean autoscale, boolean crop, double calib, double min1, double max1, double min2, double max2, double min3, double max3) {
        ImagePlus imp = this.setup(pixelType, autoscale, crop, calib, 3);
        CompositeImage ci = (CompositeImage)imp;
        LUT lut1 = ci.getChannelLut(1);
        LUT lut2 = ci.getChannelLut(2);
        LUT lut3 = ci.getChannelLut(3);
        Assert.assertEquals((double)(min1 - calib), (double)lut1.min, (double)0.0);
        Assert.assertEquals((double)(max1 - calib), (double)lut1.max, (double)0.0);
        Assert.assertEquals((double)(min2 - calib), (double)lut2.min, (double)0.0);
        Assert.assertEquals((double)(max2 - calib), (double)lut2.max, (double)0.0);
        Assert.assertEquals((double)(min3 - calib), (double)lut3.min, (double)0.0);
        Assert.assertEquals((double)(max3 - calib), (double)lut3.max, (double)0.0);
    }

    private ImagePlus setup(int pixelType, boolean autoscale, boolean crop, double calib, int sizeC) {
        String pix = FormatTools.getPixelTypeString((int)pixelType);
        String id = "autoscale&pixelType=" + pix + "&sizeX=" + 51 + "&sizeY=" + 16 + "&sizeC=" + sizeC + ".fake";
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setId(id);
            options.setAutoscale(autoscale);
            options.setCrop(crop);
            if (crop) {
                options.setCropRegion(0, CROP_REGION);
            }
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (FormatException exc) {
            Assert.fail((String)exc.getMessage());
            LOGGER.debug("", (Throwable)exc);
        }
        catch (IOException exc) {
            Assert.fail((String)exc.getMessage());
            LOGGER.debug("", (Throwable)exc);
        }
        Assert.assertTrue((imps != null && imps.length == 1 ? 1 : 0) != 0);
        void imp = imps[0];
        Assert.assertEquals((sizeC > 1 ? 1 : 0) != 0, (boolean)(imp instanceof CompositeImage));
        Calibration cal = imp.getCalibration();
        int calFunction = cal.getFunction();
        if (calib == 0.0) {
            Assert.assertFalse((calFunction == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((calFunction == 0 ? 1 : 0) != 0);
            double[] coeffs = cal.getCoefficients();
            Assert.assertTrue((coeffs.length >= 1 ? 1 : 0) != 0);
            Assert.assertEquals((double)calib, (double)coeffs[0], (double)0.0);
        }
        this.dump(pix, sizeC, autoscale, crop, (ImagePlus)imp);
        return imp;
    }

    private void dump(String pix, int sizeC, boolean autoscale, boolean crop, ImagePlus imp) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("pixelType=");
        for (int s = pix.length(); s < 6; ++s) {
            sb.append(" ");
        }
        sb.append(pix);
        sb.append(", sizeC=");
        sb.append(sizeC);
        sb.append(", autoscale=");
        sb.append(autoscale ? " true" : "false");
        sb.append(", crop=");
        sb.append(crop ? " true" : "false");
        sb.append(": image=");
        if (imp instanceof CompositeImage) {
            CompositeImage ci = (CompositeImage)imp;
            sb.append("composite");
            for (int c = 0; c < sizeC; ++c) {
                LUT lut = ci.getChannelLut(c + 1);
                sb.append("; min");
                sb.append(c);
                sb.append("=");
                sb.append(lut.min);
                sb.append("; max");
                sb.append(c);
                sb.append("=");
                sb.append(lut.max);
            }
        } else {
            sb.append("  vanilla");
            double min = imp.getDisplayRangeMin();
            double max = imp.getDisplayRangeMax();
            sb.append("; min=");
            sb.append(min);
            sb.append("; max=");
            sb.append(max);
        }
        Calibration cal = imp.getCalibration();
        if (cal.getFunction() == 0) {
            sb.append("; calibration=");
            double[] coeffs = cal.getCoefficients();
            sb.append(coeffs[0]);
        }
        LOGGER.debug(sb.toString());
    }
}

