/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import loci.formats.utests.ModelMock;
import loci.formats.utests.SPWModelMock;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.Image;
import ome.xml.model.OME;
import ome.xml.model.Pixels;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PositiveInteger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseModelMock
implements ModelMock {
    private OME ome = new OME();
    public static final String GENERAL_ANNOTATION_NAMESPACE = "test-ome-InOut201004-namespace";
    public static final Integer SIZE_X = 24;
    public static final Integer SIZE_Y = 24;
    public static final Integer SIZE_Z = 1;
    public static final Integer SIZE_C = 3;
    public static final Integer SIZE_T = 1;
    public static final DimensionOrder DIMENSION_ORDER = DimensionOrder.XYZCT;
    public static final PixelType PIXEL_TYPE = PixelType.UINT16;
    public static final Integer BYTES_PER_PIXEL = 2;
    public static final String PLANE = "ZrXEfwslJ9N1nDrbtxxWh4fRHo4w8nZ2N0I74Lgj9oIKN9qrPbBK24z+w+9zYzRQWJXfEwwAKXgV4Z1jCPhE9woGjJaarHTsFwy21nF2IoJDkd3L/zSWMSVk508+jpxV4t5p93HE1uE4K34WCVEeeZ1dSRli/b7/6RhF56DjdB6KboGly3zuN2/eZt9uJ2MhHZtktzpjFtn2mhf4i7iggpQyWx74xvFs9VxXQf1QoxN1KcTGXbdfPNoj3qmzz7Wm8/iXXw7wpOrC2MRcbt98VH4UaQxFgu6VPer73JAS+r2Kd2C67ZFbweyR/LCoUiich866SrwJk3IrTD9AlnGO6SjHIz27yWVh1omr36H1qOuD4ULSknM2txm4FrB02gxHWHbgaJWGT02eT1nwGNXygHe7gdYVP8o6Ms9sT/nBwhoMK8NuQINx7KJP/jTP0p5gNjEHZeAN1To9Qp3AF3jaWK2671Dyy/l9BBRMhD3gEqXJ12ZXZ0par2pvqVtMcbpAZk96GKsSWDQP48yDkNYTG7RDBMzRJxiem7eifg1gpUP1rmmaNEu12+0wclsGBUeH1d9HiN+rDnppycrVQIgvKbXKlUkQH230IYHDESKnlLCZALLJuRuAT5qsNri5950OlphUxeYAnNfUkXYRUHGGnGXw58nmnBCp7iuHDC8AJdCRyK+0wk/xtt6EeADkPs9Qq90H2kXvvGVbcL03IV1mb0PkdqWg2ovrkSLXKhLXb65ruPPz43TAT9xv4QJdmFqJbaMHta8Wd1Fs9cffChHWJT3RS9U8VrhGlBB5+1D9PMlqLruYtp7ulUpMSJFOKkboyXoECSzJuzknqP2Cj1KWrNk+gSsnAlq5zko6KUyPXWMBVgPGNrXR+ivtIXmyQGu5jSTuA+S+ogaPraRPQELmmuQ2wcoWI7O9Vpht1tFmgXkrdqCTD7+JwdXlbHSoRz3ti9dpJY+LyKBisuKcDgdxWulwtydNliNSKKyt7qGC2B90VLo+XsYLLEYU+w95l2ZOumqBquStdKntlReWtCDu8HfbK6AryfZXL5hqMTdqFubcXl4n5ZfBNtHaru8/LswNVGua9VJUsvZV9rMniNwoU7Ev+oLc/0SZkJrwL/r+9Jl5k02DRymhE4XISJ3UXcnt2K57w/OmIJK3HzznrIXgPJA9Nq7M6XjXDDXuBF08709iSEfOWWZ0Yz5ySoszOlSO0OGoRYv8X9xUeOfWi4oizQeSOj2ZTXegqZLxj/g8Y7ykyDkG4NsMS0Kx2fZvxqKE9EdUAXMvDN09X0fKdurqYqPBsRq79Id8YIJhamEP969OjHs9VXIETMmCkoUz2//7BfeaCUzv5c61/asdOR6CJ4ANUX7hQA7hlTk8qllaaLIEWQyGeaDoaw9b5xq0AdhwOZSeCKNIyQVpApdCOnXYuZVoTBNDdW7/7OPZD2uyS9gZ+7JGmuoV9/gRZT72oAQs4++/GpC5h6uOx9Rt5265siOZjfYYX++/qUX8M5Fs9whPwL8NqrJ4qZrUbTYUzQaI";
    public static final String XML_NS = "http://www.openmicroscopy.org/Schemas/OME/2010-06";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA_LOCATION = "http://www.openmicroscopy.org/Schemas/OME/2010-06/ome.xsd";

    public BaseModelMock() {
        this.ome.addImage(this.makeImage(1));
    }

    @Override
    public OME getRoot() {
        return this.ome;
    }

    private Image makeImage(int index) {
        int i;
        Image image = new Image();
        image.setID("Image:" + index);
        Pixels pixels = new Pixels();
        pixels.setID("Pixels:" + index);
        pixels.setSizeX(new PositiveInteger(SIZE_X));
        pixels.setSizeY(new PositiveInteger(SIZE_Y));
        pixels.setSizeZ(new PositiveInteger(SIZE_Z));
        pixels.setSizeC(new PositiveInteger(SIZE_C));
        pixels.setSizeT(new PositiveInteger(SIZE_T));
        pixels.setDimensionOrder(DIMENSION_ORDER);
        pixels.setType(PIXEL_TYPE);
        for (i = 0; i < SIZE_Z * SIZE_C * SIZE_T; ++i) {
            BinData binData = new BinData();
            binData.setBigEndian(Boolean.valueOf(false));
            binData.setCompression(Compression.NONE);
            binData.setLength(new NonNegativeLong(Long.valueOf(SIZE_X * SIZE_Y * BYTES_PER_PIXEL)));
            pixels.addBinData(binData);
        }
        for (i = 0; i < SIZE_C; ++i) {
            Channel channel = new Channel();
            channel.setID("Channel:" + i);
            pixels.addChannel(channel);
        }
        image.setPixels(pixels);
        return image;
    }

    public static void main(String[] args) throws Exception {
        BaseModelMock mock = new BaseModelMock();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.newDocument();
        Element root = mock.ome.asXMLElement(document);
        SPWModelMock.postProcess(root, document, true);
        FileOutputStream outputStream = new FileOutputStream(args[0]);
        ((OutputStream)outputStream).write(SPWModelMock.asString(document).getBytes());
    }
}

