/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMappingHints;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Field;

class HDF5CompoundMemberByteifyerEnumFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerEnumFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            return (clazz == HDF5EnumerationValue.class || clazz.isEnum() || clazz == String.class || Number.class.isAssignableFrom(clazz) || clazz.isPrimitive() && clazz != Boolean.TYPE) && memberInfoOrNull.getType().getDataClass() == HDF5DataClass.ENUM;
        }
        return clazz == HDF5EnumerationValue.class || clazz.isEnum();
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType compoundMemberInfoEnumTypeOrNull, Class<?> memberClazz, int index, int offset, int memOffset, HDF5ValueObjectByteifyer.IFileAccessProvider fileInfoProvider) {
        HDF5EnumerationType enumTypeOrNull;
        String memberName = member.getMemberName();
        HDF5EnumerationType hDF5EnumerationType = enumTypeOrNull = member.tryGetEnumerationType() != null ? member.tryGetEnumerationType() : compoundMemberInfoEnumTypeOrNull;
        if (enumTypeOrNull == null) {
            throw new HDF5JavaException("Enumeration type for member '" + memberName + "' not known for member byteifyer.");
        }
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, offset, memOffset, enumTypeOrNull, member.tryGetTypeVariant(), HDF5CompoundMemberByteifyerEnumFactory.getEnumReturnTypeFromField(fieldOrNull.getType()));
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, memOffset, enumTypeOrNull, member.tryGetTypeVariant(), HDF5CompoundMappingHints.getEnumReturnType(member));
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, memOffset, enumTypeOrNull, member.tryGetTypeVariant(), HDF5CompoundMappingHints.getEnumReturnType(member));
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, memOffset, enumTypeOrNull, member.tryGetTypeVariant(), HDF5CompoundMappingHints.getEnumReturnType(member));
            }
        }
        throw new Error("Unknown access type");
    }

    static HDF5CompoundMappingHints.EnumReturnType getEnumReturnTypeFromField(Class<?> type) {
        Class<?> clazz;
        Class<?> clazz2 = clazz = type.isArray() ? type.getComponentType() : type;
        if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive() && clazz != Boolean.TYPE) {
            return HDF5CompoundMappingHints.EnumReturnType.ORDINAL;
        }
        if (String.class == clazz) {
            return HDF5CompoundMappingHints.EnumReturnType.STRING;
        }
        if (clazz.isEnum()) {
            return HDF5CompoundMappingHints.EnumReturnType.JAVAENUMERATION;
        }
        return HDF5CompoundMappingHints.EnumReturnType.HDF5ENUMERATIONVALUE;
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, int offset, int memOffset, final HDF5EnumerationType enumType, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5MemberByteifyer(field, memberName, enumType.getStorageForm().getStorageSize(), offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return enumType.getStorageTypeId();
            }

            @Override
            protected long getMemberNativeTypeId() {
                return enumType.getNativeTypeId();
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnum(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValue = HDF5CompoundMemberByteifyerEnumFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, enumReturnType, field);
                field.set(obj, enumValue);
            }

            private HDF5EnumerationValue getEnum(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumObj = field.get(obj);
                if (enumObj instanceof HDF5EnumerationValue) {
                    return (HDF5EnumerationValue)enumObj;
                }
                if (enumObj instanceof Number) {
                    return new HDF5EnumerationValue(enumType, ((Number)enumObj).intValue());
                }
                return new HDF5EnumerationValue(enumType, enumObj.toString());
            }

            @Override
            HDF5EnumerationType tryGetEnumType() {
                return enumType;
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, int memOffset, final HDF5EnumerationType enumType, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        return new HDF5MemberByteifyer(null, memberName, enumType.getStorageForm().getStorageSize(), offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return enumType.getStorageTypeId();
            }

            @Override
            protected long getMemberNativeTypeId() {
                return enumType.getNativeTypeId();
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnum(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValue = HDF5CompoundMemberByteifyerEnumFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, enumReturnType, null);
                HDF5CompoundByteifyerFactory.putMap(obj, memberName, enumValue);
            }

            private HDF5EnumerationValue getEnum(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumObj = HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                if (enumObj instanceof HDF5EnumerationValue) {
                    return (HDF5EnumerationValue)enumObj;
                }
                if (enumObj instanceof Number) {
                    return new HDF5EnumerationValue(enumType, ((Number)enumObj).intValue());
                }
                return new HDF5EnumerationValue(enumType, enumObj.toString());
            }

            @Override
            HDF5EnumerationType tryGetEnumType() {
                return enumType;
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final int index, int offset, int memOffset, final HDF5EnumerationType enumType, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        return new HDF5MemberByteifyer(null, memberName, enumType.getStorageForm().getStorageSize(), offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return enumType.getStorageTypeId();
            }

            @Override
            protected long getMemberNativeTypeId() {
                return enumType.getNativeTypeId();
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnum(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValue = HDF5CompoundMemberByteifyerEnumFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, enumReturnType, null);
                HDF5CompoundByteifyerFactory.setList(obj, index, enumValue);
            }

            private HDF5EnumerationValue getEnum(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumObj = HDF5CompoundByteifyerFactory.getList(obj, index);
                if (enumObj instanceof HDF5EnumerationValue) {
                    return (HDF5EnumerationValue)enumObj;
                }
                if (enumObj instanceof Number) {
                    return new HDF5EnumerationValue(enumType, ((Number)enumObj).intValue());
                }
                return new HDF5EnumerationValue(enumType, enumObj.toString());
            }

            @Override
            HDF5EnumerationType tryGetEnumType() {
                return enumType;
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final int index, int offset, int memOffset, final HDF5EnumerationType enumType, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        return new HDF5MemberByteifyer(null, memberName, enumType.getStorageForm().getStorageSize(), offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return enumType.getStorageTypeId();
            }

            @Override
            protected long getMemberNativeTypeId() {
                return enumType.getNativeTypeId();
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnum(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValue = HDF5CompoundMemberByteifyerEnumFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, enumReturnType, null);
                HDF5CompoundByteifyerFactory.setArray(obj, index, enumValue);
            }

            private HDF5EnumerationValue getEnum(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumObj = HDF5CompoundByteifyerFactory.getArray(obj, index);
                if (enumObj instanceof HDF5EnumerationValue) {
                    return (HDF5EnumerationValue)enumObj;
                }
                if (enumObj instanceof Number) {
                    return new HDF5EnumerationValue(enumType, ((Number)enumObj).intValue());
                }
                return new HDF5EnumerationValue(enumType, enumObj.toString());
            }

            @Override
            HDF5EnumerationType tryGetEnumType() {
                return enumType;
            }
        };
    }

    static Object getEnumValue(HDF5EnumerationType enumType, byte[] byteArr, int arrayOffset, HDF5CompoundMappingHints.EnumReturnType enumReturnType, Field fieldOrNull) {
        switch (enumReturnType) {
            case HDF5ENUMERATIONVALUE: {
                return enumType.createFromStorageForm(byteArr, arrayOffset);
            }
            case STRING: {
                return enumType.createStringFromStorageForm(byteArr, arrayOffset);
            }
            case ORDINAL: {
                return enumType.getOrdinalFromStorageForm(byteArr, arrayOffset);
            }
            case JAVAENUMERATION: {
                if (fieldOrNull == null) {
                    throw new HDF5JavaException("JAVAENUMERATIONTYPE only available with access type FIELD");
                }
                String value = enumType.createStringFromStorageForm(byteArr, arrayOffset);
                Class<?> enumClass = fieldOrNull.getType();
                return Enum.valueOf(enumClass, value);
            }
        }
        throw new Error("Unknown EnumReturnType " + (Object)((Object)enumReturnType));
    }
}

