/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.BaseZeissReader;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;

public class ZeissZVIReader
extends BaseZeissReader {
    public static final int ZVI_MAGIC_BYTES = -791735840;
    private static final long ROI_SIGNATURE = 2449947852680921101L;
    protected transient POIService poi;
    protected String[] files;
    protected transient RandomAccessInputStream currentPlane;
    protected transient int currentPlaneIndex = -1;

    public ZeissZVIReader() {
        super("Zeiss Vision Image (ZVI)", "zvi");
        this.domains = new String[]{"Light Microscopy"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 65536;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)65536, (boolean)false)) {
            return false;
        }
        int magic = stream.readInt();
        return magic == -791735840;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int yy;
        byte[] t;
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.lastPlane = no;
        if (this.poi == null) {
            this.initPOIService();
        }
        int bytes = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int pixel = bytes * this.getRGBChannelCount();
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        int index = -1;
        int[] coords = this.getZCTCoords(no);
        for (int q = 0; q < this.coordinates.length; ++q) {
            if (this.coordinates[q][0] != coords[0] || this.coordinates[q][1] != coords[1] || this.coordinates[q][2] != coords[2] || this.coordinates[q][3] != this.getSeries()) continue;
            index = q;
            break;
        }
        LOGGER.trace("no = " + no + ", index = " + index);
        if (index < 0 || index >= this.imageFiles.length) {
            return buf;
        }
        if (this.currentPlane == null || this.currentPlaneIndex != index) {
            if (this.currentPlane != null) {
                this.currentPlane.close();
            }
            this.currentPlane = this.poi.getDocumentStream(this.imageFiles[index]);
            this.currentPlaneIndex = index;
        }
        this.currentPlane.seek((long)this.offsets[index]);
        int len = w * pixel;
        int row = this.getSizeX() * pixel;
        if (this.isJPEG) {
            t = new JPEGCodec().decompress(this.currentPlane, options);
            for (yy = 0; yy < h; ++yy) {
                System.arraycopy(t, (yy + y) * row + x * pixel, buf, yy * len, len);
            }
        } else if (this.isZlib) {
            t = new ZlibCodec().decompress(this.currentPlane, options);
            for (yy = 0; yy < h; ++yy) {
                int src = (yy + y) * row + x * pixel;
                int dest = yy * len;
                if (src + len <= t.length && dest + len <= buf.length) {
                    System.arraycopy(t, src, buf, dest, len);
                    continue;
                }
                break;
            }
        } else {
            this.readPlane(this.currentPlane, x, y, w, h, buf);
        }
        if (this.isRGB() && !this.isJPEG) {
            byte[] bb = new byte[bytes];
            for (int i = 0; i < buf.length; i += this.bpp) {
                System.arraycopy(buf, i + 2 * bytes, bb, 0, bytes);
                System.arraycopy(buf, i, buf, i + 2 * bytes, bytes);
                System.arraycopy(bb, 0, buf, i, bytes);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.poi != null) {
            this.poi.close();
        }
        if (this.currentPlane != null) {
            this.currentPlane.close();
        }
        this.poi = null;
        this.files = null;
        this.currentPlane = null;
        this.currentPlaneIndex = -1;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        super.initFileMain(id);
        Object[] zs = this.zIndices.toArray(new Integer[this.zIndices.size()]);
        Object[] cs = this.channelIndices.toArray(new Integer[this.channelIndices.size()]);
        Object[] ts = this.timepointIndices.toArray(new Integer[this.timepointIndices.size()]);
        Object[] tiles = this.tileIndices.toArray(new Integer[this.tileIndices.size()]);
        Arrays.sort(zs);
        Arrays.sort(cs);
        Arrays.sort(ts);
        Arrays.sort(tiles);
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i][0] = Arrays.binarySearch(zs, (Object)this.coordinates[i][0]);
            this.coordinates[i][1] = Arrays.binarySearch(cs, (Object)this.coordinates[i][1]);
            this.coordinates[i][2] = Arrays.binarySearch(ts, (Object)this.coordinates[i][2]);
            this.coordinates[i][3] = Arrays.binarySearch(tiles, (Object)this.coordinates[i][3]);
            LOGGER.trace("corrected coordinate #{} = {}", (Object)i, (Object)this.coordinates[i]);
        }
    }

    @Override
    protected void initVars(String id) throws FormatException, IOException {
        super.initVars(id);
        this.initPOIService();
        this.countImages();
    }

    private void initPOIService() throws FormatException, IOException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = (POIService)factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new FormatException("POI library not found", (Throwable)de);
        }
        this.poi.initialize(Location.getMappedId((String)this.getCurrentFile()));
    }

    @Override
    protected void fillMetadataPass1(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass1(store);
        for (String name : this.files) {
            RandomAccessInputStream s;
            int imageNum;
            String relPath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (!relPath.toUpperCase().equals("CONTENTS")) continue;
            String dirName = name.substring(0, name.lastIndexOf(File.separator));
            if (dirName.indexOf(File.separator) != -1) {
                dirName = dirName.substring(dirName.lastIndexOf(File.separator) + 1);
            }
            if (name.indexOf("Scaling") == -1 && dirName.equals("Tags")) {
                imageNum = this.getImageNumber(name, -1);
                if (imageNum == -1) {
                    this.parseTags(imageNum, name, (MetadataStore)new DummyMetadata());
                    continue;
                }
                this.tagsToParse.add(name);
                continue;
            }
            if (dirName.equals("Shapes") && name.indexOf("Item") != -1) {
                imageNum = this.getImageNumber(name, -1);
                if (imageNum == -1) continue;
                try {
                    s = this.poi.getDocumentStream(name);
                    try {
                        this.parseROIs(s, imageNum, name, store);
                    }
                    finally {
                        if (s != null) {
                            s.close();
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Could not parse all ROIs.", (Throwable)e);
                }
                continue;
            }
            if (!dirName.equals("Image") && dirName.toUpperCase().indexOf("ITEM") == -1 || (imageNum = this.getImageNumber(dirName, this.getImageCount() == 1 ? 0 : -1)) == -1) continue;
            s = this.poi.getDocumentStream(name);
            try {
                s.order(true);
                if (s.length() <= 1024L) continue;
                for (int q = 0; q < 11; ++q) {
                    this.getNextTag(s);
                }
                s.skipBytes(2);
                int len = s.readInt() - 20;
                s.skipBytes(8);
                int zidx = s.readInt();
                int cidx = s.readInt();
                int tidx = s.readInt();
                s.skipBytes(4);
                int tileIndex = s.readInt();
                this.zIndices.add(zidx);
                this.timepointIndices.add(tidx);
                this.channelIndices.add(cidx);
                this.tileIndices.add(tileIndex);
                s.skipBytes(len - 8);
                for (int q = 0; q < 5; ++q) {
                    this.getNextTag(s);
                }
                s.skipBytes(4);
                ((CoreMetadata)this.core.get((int)0)).sizeX = s.readInt();
                ((CoreMetadata)this.core.get((int)0)).sizeY = s.readInt();
                s.skipBytes(4);
                if (this.bpp == 0) {
                    this.bpp = s.readInt();
                } else {
                    s.skipBytes(4);
                }
                s.skipBytes(4);
                int valid = s.readInt();
                String check = s.readString(4).trim();
                this.isZlib = (valid == 0 || valid == 1) && check.equals("WZL");
                this.isJPEG = (valid == 0 || valid == 1) && !this.isZlib;
                this.offsets[imageNum] = (int)s.getFilePointer() - 4;
                if (this.isZlib) {
                    int n = imageNum;
                    this.offsets[n] = this.offsets[n] + 8;
                }
                this.coordinates[imageNum][0] = zidx;
                this.coordinates[imageNum][1] = cidx;
                this.coordinates[imageNum][2] = tidx;
                this.coordinates[imageNum][3] = tileIndex;
                LOGGER.trace("imageNum = {}, coordinate = {}", (Object)imageNum, (Object)this.coordinates[imageNum]);
                this.imageFiles[imageNum] = name;
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    @Override
    protected void fillMetadataPass3(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass3(store);
        if (this.core.size() > 1) {
            Object[] t = this.tiles.keySet().toArray(new Integer[this.tiles.size()]);
            Arrays.sort(t);
            ArrayList<Integer> tmpOffsets = new ArrayList<Integer>();
            ArrayList<String> tmpFiles = new ArrayList<String>();
            int index = 0;
            for (Object key : t) {
                int nTiles = (Integer)this.tiles.get(key);
                if (nTiles < this.getImageCount()) {
                    this.tiles.remove(key);
                } else {
                    for (int p = 0; p < nTiles; ++p) {
                        tmpOffsets.add(this.offsets[index + p]);
                        tmpFiles.add(this.imageFiles[index + p]);
                    }
                }
                index += nTiles;
            }
            this.offsets = new int[tmpOffsets.size()];
            for (int i = 0; i < this.offsets.length; ++i) {
                this.offsets[i] = (Integer)tmpOffsets.get(i);
            }
            this.imageFiles = tmpFiles.toArray(new String[tmpFiles.size()]);
        }
    }

    @Override
    protected void fillMetadataPass5(MetadataStore store) throws FormatException, IOException {
        super.fillMetadataPass5(store);
        for (String name : this.tagsToParse) {
            int imageNum = this.getImageNumber(name, -1);
            this.parseTags(imageNum, name, store);
        }
    }

    @Override
    protected void countImages() {
        this.files = this.poi.getDocumentList().toArray(new String[0]);
        Arrays.sort(this.files, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer n1 = ZeissZVIReader.this.getImageNumber(o1, -1);
                Integer n2 = ZeissZVIReader.this.getImageNumber(o2, -1);
                return n1.compareTo(n2);
            }
        });
        ((CoreMetadata)this.core.get((int)0)).imageCount = 0;
        for (String file : this.files) {
            int imageNumber;
            String uname = file.toUpperCase();
            if (!(uname = uname.substring(uname.indexOf(File.separator) + 1)).endsWith("CONTENTS") || !uname.startsWith("IMAGE") && uname.indexOf("ITEM") == -1 || this.poi.getFileSize(file) <= 1024 || (imageNumber = this.getImageNumber(file, 0)) < this.getImageCount()) continue;
            ++((CoreMetadata)this.core.get((int)0)).imageCount;
        }
        super.countImages();
        this.coordinates = new int[this.getSeriesCount() * this.getImageCount()][4];
    }

    private int getImageNumber(String dirName, int defaultNumber) {
        if (dirName.toUpperCase().indexOf("ITEM") != -1) {
            int open = dirName.indexOf(40);
            int close = dirName.indexOf(41);
            if (open < 0 || close < 0 || close < open) {
                return defaultNumber;
            }
            return Integer.parseInt(dirName.substring(open + 1, close));
        }
        return defaultNumber;
    }

    private String getNextTag(RandomAccessInputStream s) throws IOException {
        short type = s.readShort();
        switch (type) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: {
                return String.valueOf(s.readShort());
            }
            case 3: 
            case 22: {
                return String.valueOf(s.readInt());
            }
            case 19: 
            case 23: {
                return String.valueOf(s.readUnsignedInt());
            }
            case 4: {
                return String.valueOf(s.readFloat());
            }
            case 5: {
                return String.valueOf(s.readDouble());
            }
            case 7: {
                return String.valueOf(s.readDouble());
            }
            case 20: {
                String str2 = String.valueOf(s.readLong());
                return str2;
            }
            case 21: {
                byte[] raw = new byte[8];
                s.read(raw);
                BigInteger b1 = new BigInteger(1, raw);
                return b1.toString();
            }
            case 8: 
            case 69: {
                int len = s.readInt();
                return s.readString(len);
            }
            case 9: 
            case 13: {
                s.skipBytes(16);
                return "";
            }
            case 11: {
                return String.valueOf(s.readShort() != 0);
            }
            case 63: 
            case 65: {
                int len = s.readInt();
                s.skipBytes(len);
                return "";
            }
            case 66: {
                short len = s.readShort();
                return s.readString((int)len);
            }
        }
        long old = s.getFilePointer();
        while (s.readShort() != 3 && s.getFilePointer() + 2L < s.length()) {
        }
        long fp = s.getFilePointer() - 2L;
        s.seek(old - 2L);
        return s.readString((int)(fp - old + 2L));
    }

    private void parseTags(int image, String file, MetadataStore store) throws FormatException, IOException {
        ArrayList<BaseZeissReader.Tag> tags = new ArrayList<BaseZeissReader.Tag>();
        try (RandomAccessInputStream s = this.poi.getDocumentStream(file);){
            s.order(true);
            s.seek(8L);
            int count = s.readInt();
            for (int i = 0; i < count && s.getFilePointer() + 2L < s.length(); ++i) {
                String value = DataTools.stripString((String)this.getNextTag(s));
                s.skipBytes(2);
                int tagID = s.readInt();
                s.skipBytes(6);
                if (tagID == 1047) continue;
                tags.add(new BaseZeissReader.Tag(this, tagID, value, BaseZeissReader.Context.MAIN));
            }
            this.parseMainTags(image, store, tags);
        }
    }

    private void parseROIs(RandomAccessInputStream s, int imageNum, String name, MetadataStore store) throws IOException {
        int roiFound;
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level == MetadataLevel.MINIMUM || level == MetadataLevel.NO_OVERLAYS) {
            return;
        }
        s.setEncoding("UTF-16LE");
        s.order(true);
        ArrayList<Long> roiOffsets = new ArrayList<Long>();
        s.seek(2L);
        int layerversion = s.readInt();
        LOGGER.debug("LAYER@{} version={}", (Object)(s.getFilePointer() - 4L), (Object)layerversion);
        String layername = null;
        long tmp = s.getFilePointer();
        if (s.readShort() == 8) {
            s.seek(tmp);
            layername = this.parseROIString(s);
        }
        if (layername != null) {
            LOGGER.debug("  Name={}", layername);
        } else {
            LOGGER.debug("  Name=NULL");
        }
        s.skipBytes(8);
        int roiCount = s.readShort();
        LOGGER.debug("  ShapeCount@{} count={}", (Object)(s.getFilePointer() - 2L), (Object)roiCount);
        BaseZeissReader.Layer nlayer = new BaseZeissReader.Layer(this);
        nlayer.name = layername;
        this.layers.add(nlayer);
        for (roiFound = 0; roiFound < roiCount && s.getFilePointer() < s.length() - 8L; ++roiFound) {
            long signature = s.readLong() & 0xFFFFFFFFFFFFFFFFL;
            while (signature != 2449947852680921101L && s.getFilePointer() < s.length()) {
                s.seek(s.getFilePointer() - 6L);
                signature = s.readLong() & 0xFFFFFFFFFFFFFFFFL;
            }
            if (s.getFilePointer() >= s.length()) break;
            long roiOffset = s.getFilePointer() - 8L;
            roiOffsets.add(roiOffset);
            LOGGER.debug("ROI@{}", (Object)roiOffset);
            s.seek(roiOffset + 26L);
            int length = s.readInt();
            BaseZeissReader.Shape nshape = new BaseZeissReader.Shape(this);
            s.skipBytes((long)length + 6L);
            long shapeAttrOffset = s.getFilePointer();
            int shapeAttrLength = s.readInt();
            nshape.type = BaseZeissReader.FeatureType.get(s.readInt());
            LOGGER.debug("  ShapeAttrs@{} len={}", (Object)shapeAttrOffset, (Object)shapeAttrLength);
            if (shapeAttrLength < 32) break;
            s.skipBytes(8);
            nshape.x1 = s.readInt();
            nshape.y1 = s.readInt();
            nshape.x2 = s.readInt();
            nshape.y2 = s.readInt();
            nshape.width = nshape.x2 - nshape.x1;
            nshape.height = nshape.y2 - nshape.y1;
            LOGGER.debug("    Bounding Box");
            if (shapeAttrLength >= 72) {
                s.skipBytes(16);
                nshape.fillColour = s.readInt();
                nshape.textColour = s.readInt();
                nshape.drawColour = s.readInt();
                nshape.lineWidth = s.readInt();
                nshape.drawStyle = BaseZeissReader.DrawStyle.get(s.readInt());
                nshape.fillStyle = BaseZeissReader.FillStyle.get(s.readInt());
                nshape.strikeout = s.readInt() != 0;
                LOGGER.debug("    Shape styles");
            }
            if (shapeAttrLength >= 100) {
                nshape.fontWeight = s.readInt();
                nshape.bold = nshape.fontWeight >= 600;
                nshape.fontSize = s.readInt();
                nshape.italic = s.readInt() != 0;
                nshape.underline = s.readInt() != 0;
                nshape.textAlignment = BaseZeissReader.TextAlignment.get(s.readInt());
                LOGGER.debug("    Font styles");
            }
            if (shapeAttrLength >= 148) {
                s.skipBytes(36);
                nshape.lineEndStyle = BaseZeissReader.LineEndStyle.get(s.readInt());
                nshape.pointStyle = BaseZeissReader.PointStyle.get(s.readInt());
                nshape.lineEndSize = s.readInt();
                nshape.lineEndPositions = BaseZeissReader.LineEndPositions.get(s.readInt());
                LOGGER.debug("    Line styles");
            }
            if (shapeAttrLength >= 152) {
                nshape.displayTag = s.readInt() != 0;
                LOGGER.debug("    Tag display");
            }
            if (shapeAttrLength >= 152) {
                nshape.charset = BaseZeissReader.Charset.get(s.readInt());
                LOGGER.debug("    Charset");
            }
            long tmp2 = s.getFilePointer();
            for (int i = 0; i < 2; ++i) {
                if (s.readShort() != 8) continue;
                s.seek(tmp2);
                nshape.text = this.parseROIString(s);
                break;
            }
            if (nshape.text != null) {
                LOGGER.debug("  Text={}", (Object)nshape.text);
            } else {
                LOGGER.debug("  Text=NULL");
            }
            if (s.getFilePointer() + 8L > s.length()) break;
            s.skipBytes(4);
            LOGGER.debug("  Tag@{}", (Object)s.getFilePointer());
            nshape.tagID = new BaseZeissReader.Tag(this, s.readInt(), BaseZeissReader.Context.MAIN);
            LOGGER.debug("    TagID={}", (Object)nshape.tagID);
            nshape.fontName = this.parseROIString(s);
            if (nshape.fontName == null) break;
            LOGGER.debug("  Font name={}", (Object)nshape.fontName);
            nshape.name = this.parseROIString(s);
            if (nshape.name == null) break;
            LOGGER.debug("  Name={}", (Object)nshape.name);
            if (s.getFilePointer() + 20L > s.length()) break;
            s.skipBytes(4);
            nshape.handleSize = s.readInt();
            s.skipBytes(2);
            nshape.pointCount = s.readInt();
            s.skipBytes(6);
            LOGGER.debug("  Handle size={}", (Object)nshape.handleSize);
            LOGGER.debug("  Point count={}", (Object)nshape.pointCount);
            if (s.getFilePointer() + (long)(16 * nshape.pointCount) > s.length()) break;
            nshape.points = new double[nshape.pointCount * 2];
            for (int p = 0; p < nshape.pointCount; ++p) {
                nshape.points[p * 2] = s.readDouble();
                nshape.points[p * 2 + 1] = s.readDouble();
            }
            nlayer.shapes.add(nshape);
        }
        if (roiCount != roiFound) {
            LOGGER.warn("Found {} ROIs, but {} ROIs expected", (Object)roiFound, (Object)roiCount);
        }
    }

    protected String parseROIString(RandomAccessInputStream s) throws IOException {
        while (s.getFilePointer() < s.length() - 4L && s.readShort() != 8) {
        }
        if (s.getFilePointer() >= s.length() - 8L) {
            return null;
        }
        int strlen = s.readInt();
        if ((long)strlen + s.getFilePointer() > s.length()) {
            return null;
        }
        String text = null;
        if (strlen >= 2) {
            LOGGER.debug("  String@{} length={}", (Object)s.getFilePointer(), (Object)strlen);
            text = s.readString(strlen - 2);
            s.skipBytes(2);
        } else {
            s.skipBytes(strlen);
        }
        return text;
    }
}

