/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TiffPixelsTest {
    private static final int IMAGE_WIDTH = 64;
    private static final int IMAGE_LENGTH = 64;
    private static final int BITS_PER_PIXEL = 16;
    private IFD ifd = new IFD();
    private byte[] data;

    @BeforeMethod
    public void setUp() {
        this.ifd.put((Object)256, (Object)64);
        this.ifd.put((Object)257, (Object)64);
        this.ifd.put((Object)258, (Object)new int[]{16});
        this.ifd.put((Object)277, (Object)1);
        this.ifd.put((Object)0, (Object)Boolean.TRUE);
        this.ifd.put((Object)278, (Object)new long[]{64L});
        this.ifd.put((Object)273, (Object)new long[]{0L});
        this.data = new byte[8192];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)i;
        }
        this.ifd.put((Object)279, (Object)new long[]{this.data.length});
    }

    @Test
    public void testUNCOMPRESSED() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.UNCOMPRESSED.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    @Test(expectedExceptions={FormatException.class})
    public void testCCITT_1D() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.CCITT_1D.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    @Test(expectedExceptions={FormatException.class})
    public void testGROUP_3_FAX() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.GROUP_3_FAX.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    @Test(expectedExceptions={FormatException.class})
    public void testGROUP_4_FAX() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.GROUP_4_FAX.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    @Test
    public void testLZW() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.LZW.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    @Test(expectedExceptions={FormatException.class})
    public void testPACK_BITS() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.PACK_BITS.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    @Test
    public void testPROPRIETARY_DEFLATE() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.PROPRIETARY_DEFLATE.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    @Test
    public void testDEFLATE() throws FormatException, IOException {
        this.ifd.put((Object)259, (Object)TiffCompression.DEFLATE.getCode());
        byte[] plane = this.readSavedPlane();
        for (int i = 0; i < plane.length; ++i) {
            AssertJUnit.assertEquals((byte)plane[i], (byte)this.data[i]);
        }
    }

    private byte[] readSavedPlane() throws FormatException, IOException {
        ByteArrayHandle savedData = new ByteArrayHandle();
        byte[] plane = null;
        try (RandomAccessOutputStream out = new RandomAccessOutputStream((IRandomAccess)savedData);
             RandomAccessInputStream in = new RandomAccessInputStream((IRandomAccess)savedData);){
            TiffSaver saver = new TiffSaver(out, savedData);
            TiffParser parser = new TiffParser(in);
            saver.writeImage(this.data, this.ifd, 0, 3, false);
            plane = new byte[this.data.length];
            parser.getSamples(this.ifd, plane);
        }
        return plane;
    }
}

