/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Pulse;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulseEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PulseEnumHandler.class);
    private static final Hashtable<String, String> patterns = PulseEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*CW\\s*", "CW");
        p.put("^\\s*Single\\s*", "Single");
        p.put("^\\s*QSwitched\\s*", "QSwitched");
        p.put("^\\s*Repetitive\\s*", "Repetitive");
        p.put("^\\s*ModeLocked\\s*", "ModeLocked");
        p.put("^\\s*Other\\s*", "Other");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return Pulse.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"Pulse", (Object)value);
        return Pulse.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return Pulse.class;
    }
}

