/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;

public class RotatedLatLon
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "rotated_latlon_grib";
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        double lon = this.readAttributeDouble(ctv, "grid_south_pole_longitude", Double.NaN);
        double lat = this.readAttributeDouble(ctv, "grid_south_pole_latitude", Double.NaN);
        double angle = this.readAttributeDouble(ctv, "grid_south_pole_angle", Double.NaN);
        ucar.unidata.geoloc.projection.RotatedLatLon proj = new ucar.unidata.geoloc.projection.RotatedLatLon(lat, lon, angle);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

