/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktHeaderBitReader;
import jj2000.j2k.codestream.reader.TagTreeDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class PktDecoder
implements StdEntropyCoderOptions {
    private BitstreamReaderAgent src;
    private boolean pph = false;
    private ByteArrayInputStream pphbais;
    private DecoderSpecs decSpec;
    private HeaderDecoder hd;
    private final int INIT_LBLOCK = 3;
    private PktHeaderBitReader bin;
    private RandomAccessIO ehs;
    private Point[][] numPrec;
    private int tIdx;
    private PrecInfo[][][] ppinfo;
    private int[][][][][] lblock;
    private TagTreeDecoder[][][][] ttIncl;
    private TagTreeDecoder[][][][] ttMaxBP;
    private int nl = 0;
    private int nc;
    private boolean sopUsed = false;
    private boolean ephUsed = false;
    private int pktIdx;
    private Vector[] cblks;
    private int ncb;
    private int maxCB;
    private boolean ncbQuit;
    private int tQuit;
    private int cQuit;
    private int sQuit;
    private int rQuit;
    private int xQuit;
    private int yQuit;
    private boolean isTruncMode;

    public PktDecoder(DecoderSpecs decSpec, HeaderDecoder hd, RandomAccessIO ehs, BitstreamReaderAgent src, boolean isTruncMode, int maxCB) {
        this.decSpec = decSpec;
        this.hd = hd;
        this.ehs = ehs;
        this.isTruncMode = isTruncMode;
        this.bin = new PktHeaderBitReader(ehs);
        this.src = src;
        this.ncb = 0;
        this.ncbQuit = false;
        this.maxCB = maxCB;
    }

    public CBlkInfo[][][][][] restart(int nc, int[] mdl, int nl, CBlkInfo[][][][][] cbI, boolean pph, ByteArrayInputStream pphbais) {
        this.nc = nc;
        this.nl = nl;
        this.tIdx = this.src.getTileIdx();
        this.pph = pph;
        this.pphbais = pphbais;
        this.sopUsed = (Boolean)this.decSpec.sops.getTileDef(this.tIdx);
        this.pktIdx = 0;
        this.ephUsed = (Boolean)this.decSpec.ephs.getTileDef(this.tIdx);
        cbI = new CBlkInfo[nc][][][][];
        this.lblock = new int[nc][][][][];
        this.ttIncl = new TagTreeDecoder[nc][][][];
        this.ttMaxBP = new TagTreeDecoder[nc][][][];
        this.numPrec = new Point[nc][];
        this.ppinfo = new PrecInfo[nc][][];
        Point nBlk = null;
        int cb0x = this.src.getCbULX();
        int cb0y = this.src.getCbULY();
        for (int c = 0; c < nc; ++c) {
            cbI[c] = new CBlkInfo[mdl[c] + 1][][][];
            this.lblock[c] = new int[mdl[c] + 1][][][];
            this.ttIncl[c] = new TagTreeDecoder[mdl[c] + 1][][];
            this.ttMaxBP[c] = new TagTreeDecoder[mdl[c] + 1][][];
            this.numPrec[c] = new Point[mdl[c] + 1];
            this.ppinfo[c] = new PrecInfo[mdl[c] + 1][];
            int tcx0 = this.src.getResULX(c, mdl[c]);
            int tcy0 = this.src.getResULY(c, mdl[c]);
            int tcx1 = tcx0 + this.src.getTileCompWidth(this.tIdx, c, mdl[c]);
            int tcy1 = tcy0 + this.src.getTileCompHeight(this.tIdx, c, mdl[c]);
            for (int r = 0; r <= mdl[c]; ++r) {
                int trx0 = (int)Math.ceil((double)tcx0 / (double)(1 << mdl[c] - r));
                int try0 = (int)Math.ceil((double)tcy0 / (double)(1 << mdl[c] - r));
                int trx1 = (int)Math.ceil((double)tcx1 / (double)(1 << mdl[c] - r));
                int try1 = (int)Math.ceil((double)tcy1 / (double)(1 << mdl[c] - r));
                double twoppx = this.getPPX(this.tIdx, c, r);
                double twoppy = this.getPPY(this.tIdx, c, r);
                this.numPrec[c][r] = new Point();
                this.numPrec[c][r].x = trx1 > trx0 ? (int)Math.ceil((double)(trx1 - cb0x) / twoppx) - (int)Math.floor((double)(trx0 - cb0x) / twoppx) : 0;
                this.numPrec[c][r].y = try1 > try0 ? (int)Math.ceil((double)(try1 - cb0y) / twoppy) - (int)Math.floor((double)(try0 - cb0y) / twoppy) : 0;
                int mins = r == 0 ? 0 : 1;
                int maxs = r == 0 ? 1 : 4;
                int maxPrec = this.numPrec[c][r].x * this.numPrec[c][r].y;
                this.ttIncl[c][r] = new TagTreeDecoder[maxPrec][maxs + 1];
                this.ttMaxBP[c][r] = new TagTreeDecoder[maxPrec][maxs + 1];
                cbI[c][r] = new CBlkInfo[maxs + 1][][];
                this.lblock[c][r] = new int[maxs + 1][][];
                this.ppinfo[c][r] = new PrecInfo[maxPrec];
                this.fillPrecInfo(c, r, mdl[c]);
                SubbandSyn root = this.src.getSynSubbandTree(this.tIdx, c);
                for (int s2 = mins; s2 < maxs; ++s2) {
                    SubbandSyn sb = (SubbandSyn)root.getSubbandByIdx(r, s2);
                    nBlk = sb.numCb;
                    cbI[c][r][s2] = new CBlkInfo[nBlk.y][nBlk.x];
                    this.lblock[c][r][s2] = new int[nBlk.y][nBlk.x];
                    for (int i = nBlk.y - 1; i >= 0; --i) {
                        ArrayUtil.intArraySet(this.lblock[c][r][s2][i], 3);
                    }
                }
            }
        }
        return cbI;
    }

    private void fillPrecInfo(int c, int r, int mdl) {
        if (this.ppinfo[c][r].length == 0) {
            return;
        }
        Point tileI = this.src.getTile(null);
        Point nTiles = this.src.getNumTiles(null);
        int xt0siz = this.src.getTilePartULX();
        int yt0siz = this.src.getTilePartULY();
        int xtsiz = this.src.getNomTileWidth();
        int ytsiz = this.src.getNomTileHeight();
        int x0siz = this.hd.getImgULX();
        int y0siz = this.hd.getImgULY();
        int xsiz = this.hd.getImgWidth();
        int ysiz = this.hd.getImgHeight();
        int tx0 = tileI.x == 0 ? x0siz : xt0siz + tileI.x * xtsiz;
        int ty0 = tileI.y == 0 ? y0siz : yt0siz + tileI.y * ytsiz;
        int tx1 = tileI.x != nTiles.x - 1 ? xt0siz + (tileI.x + 1) * xtsiz : xsiz;
        int ty1 = tileI.y != nTiles.y - 1 ? yt0siz + (tileI.y + 1) * ytsiz : ysiz;
        int xrsiz = this.hd.getCompSubsX(c);
        int yrsiz = this.hd.getCompSubsY(c);
        int tcx0 = this.src.getResULX(c, mdl);
        int tcy0 = this.src.getResULY(c, mdl);
        int tcx1 = tcx0 + this.src.getTileCompWidth(this.tIdx, c, mdl);
        int tcy1 = tcy0 + this.src.getTileCompHeight(this.tIdx, c, mdl);
        int ndl = mdl - r;
        int trx0 = (int)Math.ceil((double)tcx0 / (double)(1 << ndl));
        int try0 = (int)Math.ceil((double)tcy0 / (double)(1 << ndl));
        int trx1 = (int)Math.ceil((double)tcx1 / (double)(1 << ndl));
        int try1 = (int)Math.ceil((double)tcy1 / (double)(1 << ndl));
        int cb0x = this.src.getCbULX();
        int cb0y = this.src.getCbULY();
        double twoppx = this.getPPX(this.tIdx, c, r);
        double twoppy = this.getPPY(this.tIdx, c, r);
        int twoppx2 = (int)(twoppx / 2.0);
        int twoppy2 = (int)(twoppy / 2.0);
        int maxPrec = this.ppinfo[c][r].length;
        int nPrec = 0;
        int istart = (int)Math.floor((double)(try0 - cb0y) / twoppy);
        int iend = (int)Math.floor((double)(try1 - 1 - cb0y) / twoppy);
        int jstart = (int)Math.floor((double)(trx0 - cb0x) / twoppx);
        int jend = (int)Math.floor((double)(trx1 - 1 - cb0x) / twoppx);
        SubbandSyn root = this.src.getSynSubbandTree(this.tIdx, c);
        SubbandSyn sb = null;
        int prg_w = (int)twoppx << ndl;
        int prg_h = (int)twoppy << ndl;
        for (int i = istart; i <= iend; ++i) {
            int j = jstart;
            while (j <= jend) {
                int tmp2;
                int tmp1;
                CBlkCoordInfo cb;
                int l;
                int k;
                int lend;
                int lstart;
                int l0;
                int kend;
                int kstart;
                int k0;
                int ch;
                int cw;
                int s1y;
                int s0y;
                int s1x;
                int s0x;
                int p1y;
                int p0y;
                int p1x;
                int p0x;
                int acb0y;
                int acb0x;
                int prg_ulx = j == jstart && (trx0 - cb0x) % (xrsiz * (int)twoppx) != 0 ? tx0 : cb0x + j * xrsiz * ((int)twoppx << ndl);
                int prg_uly = i == istart && (try0 - cb0y) % (yrsiz * (int)twoppy) != 0 ? ty0 : cb0y + i * yrsiz * ((int)twoppy << ndl);
                this.ppinfo[c][r][nPrec] = new PrecInfo(r, (int)((double)cb0x + (double)j * twoppx), (int)((double)cb0y + (double)i * twoppy), (int)twoppx, (int)twoppy, prg_ulx, prg_uly, prg_w, prg_h);
                if (r == 0) {
                    acb0x = cb0x;
                    acb0y = cb0y;
                    p0x = acb0x + j * (int)twoppx;
                    p1x = p0x + (int)twoppx;
                    p0y = acb0y + i * (int)twoppy;
                    p1y = p0y + (int)twoppy;
                    sb = (SubbandSyn)root.getSubbandByIdx(0, 0);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c][r][nPrec].nblk[0] = 0;
                        this.ttIncl[c][r][nPrec][0] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c][r][nPrec][0] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c][r][nPrec][0] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c][r][nPrec][0] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c][r][nPrec].cblk[0] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c][r][nPrec].nblk[0] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c][r][nPrec].cblk[0][k - kstart][l - lstart] = cb;
                            }
                        }
                    }
                } else {
                    acb0x = 0;
                    acb0y = cb0y;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandSyn)root.getSubbandByIdx(r, 1);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c][r][nPrec].nblk[1] = 0;
                        this.ttIncl[c][r][nPrec][1] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c][r][nPrec][1] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c][r][nPrec][1] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c][r][nPrec][1] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c][r][nPrec].cblk[1] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c][r][nPrec].nblk[1] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c][r][nPrec].cblk[1][k - kstart][l - lstart] = cb;
                            }
                        }
                    }
                    acb0x = cb0x;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandSyn)root.getSubbandByIdx(r, 2);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c][r][nPrec].nblk[2] = 0;
                        this.ttIncl[c][r][nPrec][2] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c][r][nPrec][2] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c][r][nPrec][2] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c][r][nPrec][2] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c][r][nPrec].cblk[2] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c][r][nPrec].nblk[2] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c][r][nPrec].cblk[2][k - kstart][l - lstart] = cb;
                            }
                        }
                    }
                    acb0x = 0;
                    acb0y = 0;
                    p0x = acb0x + j * twoppx2;
                    p1x = p0x + twoppx2;
                    p0y = acb0y + i * twoppy2;
                    p1y = p0y + twoppy2;
                    sb = (SubbandSyn)root.getSubbandByIdx(r, 3);
                    s0x = p0x < sb.ulcx ? sb.ulcx : p0x;
                    s1x = p1x > sb.ulcx + sb.w ? sb.ulcx + sb.w : p1x;
                    s0y = p0y < sb.ulcy ? sb.ulcy : p0y;
                    s1y = p1y > sb.ulcy + sb.h ? sb.ulcy + sb.h : p1y;
                    cw = sb.nomCBlkW;
                    ch = sb.nomCBlkH;
                    k0 = (int)Math.floor((double)(sb.ulcy - acb0y) / (double)ch);
                    kstart = (int)Math.floor((double)(s0y - acb0y) / (double)ch);
                    kend = (int)Math.floor((double)(s1y - 1 - acb0y) / (double)ch);
                    l0 = (int)Math.floor((double)(sb.ulcx - acb0x) / (double)cw);
                    lstart = (int)Math.floor((double)(s0x - acb0x) / (double)cw);
                    lend = (int)Math.floor((double)(s1x - 1 - acb0x) / (double)cw);
                    if (s1x - s0x <= 0 || s1y - s0y <= 0) {
                        this.ppinfo[c][r][nPrec].nblk[3] = 0;
                        this.ttIncl[c][r][nPrec][3] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[c][r][nPrec][3] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[c][r][nPrec][3] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ttMaxBP[c][r][nPrec][3] = new TagTreeDecoder(kend - kstart + 1, lend - lstart + 1);
                        this.ppinfo[c][r][nPrec].cblk[3] = new CBlkCoordInfo[kend - kstart + 1][lend - lstart + 1];
                        this.ppinfo[c][r][nPrec].nblk[3] = (kend - kstart + 1) * (lend - lstart + 1);
                        for (k = kstart; k <= kend; ++k) {
                            for (l = lstart; l <= lend; ++l) {
                                cb = new CBlkCoordInfo(k - k0, l - l0);
                                cb.ulx = l == l0 ? sb.ulx : sb.ulx + l * cw - (sb.ulcx - acb0x);
                                cb.uly = k == k0 ? sb.uly : sb.uly + k * ch - (sb.ulcy - acb0y);
                                tmp1 = acb0x + l * cw;
                                tmp1 = tmp1 > sb.ulcx ? tmp1 : sb.ulcx;
                                tmp2 = acb0x + (l + 1) * cw;
                                tmp2 = tmp2 > sb.ulcx + sb.w ? sb.ulcx + sb.w : tmp2;
                                cb.w = tmp2 - tmp1;
                                tmp1 = acb0y + k * ch;
                                tmp1 = tmp1 > sb.ulcy ? tmp1 : sb.ulcy;
                                tmp2 = acb0y + (k + 1) * ch;
                                tmp2 = tmp2 > sb.ulcy + sb.h ? sb.ulcy + sb.h : tmp2;
                                cb.h = tmp2 - tmp1;
                                this.ppinfo[c][r][nPrec].cblk[3][k - kstart][l - lstart] = cb;
                            }
                        }
                    }
                }
                ++j;
                ++nPrec;
            }
        }
    }

    public int getNumPrecinct(int c, int r) {
        return this.numPrec[c][r].x * this.numPrec[c][r].y;
    }

    public boolean readPktHead(int l, int r, int c, int p, CBlkInfo[][][] cbI, int[] nb) throws IOException {
        int tmp;
        int sumtotnewtp = 0;
        int startPktHead = this.ehs.getPos();
        if (startPktHead >= this.ehs.length()) {
            return true;
        }
        int tIdx = this.src.getTileIdx();
        SubbandSyn root = this.src.getSynSubbandTree(tIdx, c);
        PktHeaderBitReader bin = this.pph ? new PktHeaderBitReader(this.pphbais) : this.bin;
        int mins = r == 0 ? 0 : 1;
        int maxs = r == 0 ? 1 : 4;
        boolean precFound = false;
        for (int s2 = mins; s2 < maxs; ++s2) {
            if (p >= this.ppinfo[c][r].length) continue;
            precFound = true;
        }
        if (!precFound) {
            return false;
        }
        PrecInfo prec = this.ppinfo[c][r][p];
        bin.sync();
        if (bin.readBit() == 0) {
            this.cblks = new Vector[maxs + 1];
            for (int s3 = mins; s3 < maxs; ++s3) {
                this.cblks[s3] = new Vector();
            }
            ++this.pktIdx;
            if (this.isTruncMode && this.maxCB == -1) {
                int tmp2 = this.ehs.getPos() - startPktHead;
                if (tmp2 > nb[tIdx]) {
                    nb[tIdx] = 0;
                    return true;
                }
                int n = tIdx;
                nb[n] = nb[n] - tmp2;
            }
            if (this.ephUsed) {
                this.readEPHMarker(bin);
            }
            return false;
        }
        if (this.cblks == null || this.cblks.length < maxs + 1) {
            this.cblks = new Vector[maxs + 1];
        }
        for (int s4 = mins; s4 < maxs; ++s4) {
            if (this.cblks[s4] == null) {
                this.cblks[s4] = new Vector();
            } else {
                this.cblks[s4].removeAllElements();
            }
            SubbandSyn sb = (SubbandSyn)root.getSubbandByIdx(r, s4);
            if (prec.nblk[s4] == 0) continue;
            TagTreeDecoder tdIncl = this.ttIncl[c][r][p][s4];
            TagTreeDecoder tdBD = this.ttMaxBP[c][r][p][s4];
            int mend = prec.cblk[s4] == null ? 0 : prec.cblk[s4].length;
            for (int m4 = 0; m4 < mend; ++m4) {
                int nend = prec.cblk[s4][m4] == null ? 0 : prec.cblk[s4][m4].length;
                for (int n = 0; n < nend; ++n) {
                    Point cbc = prec.cblk[s4][m4][n].idx;
                    int b = cbc.x + cbc.y * sb.numCb.x;
                    CBlkInfo ccb = cbI[s4][cbc.y][cbc.x];
                    try {
                        int cbLen;
                        int passtype;
                        int tpidx;
                        int nSeg;
                        int totnewtp;
                        if (ccb == null || ccb.ctp == 0) {
                            int tmp2;
                            if (ccb == null) {
                                CBlkInfo cBlkInfo = new CBlkInfo(prec.cblk[s4][m4][n].ulx, prec.cblk[s4][m4][n].uly, prec.cblk[s4][m4][n].w, prec.cblk[s4][m4][n].h, this.nl);
                                cbI[s4][cbc.y][cbc.x] = cBlkInfo;
                                ccb = cBlkInfo;
                            }
                            ccb.pktIdx[l] = this.pktIdx;
                            tmp = tdIncl.update(m4, n, l + 1, bin);
                            if (tmp > l) continue;
                            tmp = 1;
                            for (tmp2 = 1; tmp >= tmp2; ++tmp2) {
                                tmp = tdBD.update(m4, n, tmp2, bin);
                            }
                            ccb.msbSkipped = tmp2 - 2;
                            totnewtp = 1;
                            ccb.addNTP(l, 0);
                            ++this.ncb;
                            if (this.maxCB != -1 && !this.ncbQuit && this.ncb == this.maxCB) {
                                this.ncbQuit = true;
                                this.tQuit = tIdx;
                                this.cQuit = c;
                                this.sQuit = s4;
                                this.rQuit = r;
                                this.xQuit = cbc.x;
                                this.yQuit = cbc.y;
                            }
                        } else {
                            ccb.pktIdx[l] = this.pktIdx;
                            if (bin.readBit() != 1) continue;
                            totnewtp = 1;
                        }
                        if (bin.readBit() == 1) {
                            ++totnewtp;
                            if (bin.readBit() == 1) {
                                ++totnewtp;
                                tmp = bin.readBits(2);
                                totnewtp += tmp;
                                if (tmp == 3) {
                                    tmp = bin.readBits(5);
                                    totnewtp += tmp;
                                    if (tmp == 31) {
                                        totnewtp += bin.readBits(7);
                                    }
                                }
                            }
                        }
                        ccb.addNTP(l, totnewtp);
                        sumtotnewtp += totnewtp;
                        this.cblks[s4].addElement(prec.cblk[s4][m4][n]);
                        int options = (Integer)this.decSpec.ecopts.getTileCompVal(tIdx, c);
                        if ((options & 4) != 0) {
                            nSeg = totnewtp;
                        } else if ((options & 1) != 0) {
                            if (ccb.ctp <= 10) {
                                nSeg = 1;
                            } else {
                                nSeg = 1;
                                for (tpidx = ccb.ctp - totnewtp; tpidx < ccb.ctp - 1; ++tpidx) {
                                    if (tpidx < 9 || (passtype = (tpidx + 2) % 3) != 1 && passtype != 2) continue;
                                    ++nSeg;
                                }
                            }
                        } else {
                            nSeg = 1;
                        }
                        while (bin.readBit() != 0) {
                            int[] nArray = this.lblock[c][r][s4][cbc.y];
                            int n2 = cbc.x;
                            nArray[n2] = nArray[n2] + 1;
                        }
                        if (nSeg == 1) {
                            cbLen = bin.readBits(this.lblock[c][r][s4][cbc.y][cbc.x] + MathUtil.log2(totnewtp));
                        } else {
                            int lblockCur;
                            int j;
                            ccb.segLen[l] = new int[nSeg];
                            cbLen = 0;
                            if ((options & 4) != 0) {
                                tpidx = ccb.ctp - totnewtp;
                                j = 0;
                                while (tpidx < ccb.ctp) {
                                    lblockCur = this.lblock[c][r][s4][cbc.y][cbc.x];
                                    ccb.segLen[l][j] = tmp = bin.readBits(lblockCur);
                                    cbLen += tmp;
                                    ++tpidx;
                                    ++j;
                                }
                            } else {
                                int ltp = ccb.ctp - totnewtp - 1;
                                j = 0;
                                for (tpidx = ccb.ctp - totnewtp; tpidx < ccb.ctp - 1; ++tpidx) {
                                    if (tpidx < 9 || (passtype = (tpidx + 2) % 3) == 0) continue;
                                    lblockCur = this.lblock[c][r][s4][cbc.y][cbc.x];
                                    ccb.segLen[l][j] = tmp = bin.readBits(lblockCur + MathUtil.log2(tpidx - ltp));
                                    cbLen += tmp;
                                    ltp = tpidx;
                                    ++j;
                                }
                                lblockCur = this.lblock[c][r][s4][cbc.y][cbc.x];
                                tmp = bin.readBits(lblockCur + MathUtil.log2(tpidx - ltp));
                                cbLen += tmp;
                                ccb.segLen[l][j] = tmp;
                            }
                        }
                        ccb.len[l] = cbLen;
                        if (!this.isTruncMode || this.maxCB != -1 || (tmp = this.ehs.getPos() - startPktHead) <= nb[tIdx]) continue;
                        nb[tIdx] = 0;
                        if (l == 0) {
                            cbI[s4][cbc.y][cbc.x] = null;
                        } else {
                            ccb.len[l] = 0;
                            ccb.off[l] = 0;
                            ccb.ctp -= ccb.ntp[l];
                            ccb.ntp[l] = 0;
                            ccb.pktIdx[l] = -1;
                        }
                        return true;
                    }
                    catch (EOFException e) {
                        if (l == 0) {
                            cbI[s4][cbc.y][cbc.x] = null;
                        } else {
                            ccb.len[l] = 0;
                            ccb.off[l] = 0;
                            ccb.ctp -= ccb.ntp[l];
                            ccb.ntp[l] = 0;
                            ccb.pktIdx[l] = -1;
                        }
                        return true;
                    }
                }
            }
        }
        if (this.ephUsed) {
            this.readEPHMarker(bin);
        }
        ++this.pktIdx;
        if (this.isTruncMode && this.maxCB == -1) {
            tmp = this.ehs.getPos() - startPktHead;
            if (tmp > nb[tIdx]) {
                nb[tIdx] = 0;
                return true;
            }
            int n = tIdx;
            nb[n] = nb[n] - tmp;
        }
        return false;
    }

    public boolean readPktBody(int l, int r, int c, int p, CBlkInfo[][][] cbI, int[] nb) throws IOException {
        int s2;
        int curOff = this.ehs.getPos();
        boolean stopRead = false;
        int tIdx = this.src.getTileIdx();
        boolean precFound = false;
        int mins = r == 0 ? 0 : 1;
        int maxs = r == 0 ? 1 : 4;
        for (s2 = mins; s2 < maxs; ++s2) {
            if (p >= this.ppinfo[c][r].length) continue;
            precFound = true;
        }
        if (!precFound) {
            return false;
        }
        for (s2 = mins; s2 < maxs; ++s2) {
            for (int numCB = 0; numCB < this.cblks[s2].size(); ++numCB) {
                Point cbc = ((CBlkCoordInfo)this.cblks[s2].elementAt((int)numCB)).idx;
                CBlkInfo ccb = cbI[s2][cbc.y][cbc.x];
                ccb.off[l] = curOff;
                curOff += ccb.len[l];
                try {
                    this.ehs.seek(curOff);
                }
                catch (EOFException e) {
                    if (l == 0) {
                        cbI[s2][cbc.y][cbc.x] = null;
                    } else {
                        ccb.len[l] = 0;
                        ccb.off[l] = 0;
                        ccb.ctp -= ccb.ntp[l];
                        ccb.ntp[l] = 0;
                        ccb.pktIdx[l] = -1;
                    }
                    throw new EOFException();
                }
                if (this.isTruncMode) {
                    if (stopRead || ccb.len[l] > nb[tIdx]) {
                        if (l == 0) {
                            cbI[s2][cbc.y][cbc.x] = null;
                        } else {
                            ccb.len[l] = 0;
                            ccb.off[l] = 0;
                            ccb.ctp -= ccb.ntp[l];
                            ccb.ntp[l] = 0;
                            ccb.pktIdx[l] = -1;
                        }
                        stopRead = true;
                    }
                    if (!stopRead) {
                        int n = tIdx;
                        nb[n] = nb[n] - ccb.len[l];
                    }
                }
                if (!this.ncbQuit || r != this.rQuit || s2 != this.sQuit || cbc.x != this.xQuit || cbc.y != this.yQuit || tIdx != this.tQuit || c != this.cQuit) continue;
                cbI[s2][cbc.y][cbc.x] = null;
                stopRead = true;
            }
        }
        this.ehs.seek(curOff);
        return stopRead;
    }

    public final int getPPX(int t2, int c, int r) {
        return this.decSpec.pss.getPPX(t2, c, r);
    }

    public final int getPPY(int t2, int c, int rl) {
        return this.decSpec.pss.getPPY(t2, c, rl);
    }

    public boolean readSOPMarker(int[] nBytes, int p, int c, int r) throws IOException {
        byte[] sopArray = new byte[6];
        int tIdx = this.src.getTileIdx();
        int mins = r == 0 ? 0 : 1;
        int maxs = r == 0 ? 1 : 4;
        boolean precFound = false;
        for (int s2 = mins; s2 < maxs; ++s2) {
            if (p >= this.ppinfo[c][r].length) continue;
            precFound = true;
        }
        if (!precFound) {
            return false;
        }
        if (!this.sopUsed) {
            return false;
        }
        int pos = this.ehs.getPos();
        if ((short)(this.ehs.read() << 8 | this.ehs.read()) != -111) {
            this.ehs.seek(pos);
            return false;
        }
        this.ehs.seek(pos);
        if (nBytes[tIdx] < 6) {
            return true;
        }
        int n = tIdx;
        nBytes[n] = nBytes[n] - 6;
        this.ehs.readFully(sopArray, 0, 6);
        int val = sopArray[0];
        val <<= 8;
        if ((val |= sopArray[1]) != -111) {
            throw new Error("Corrupted Bitstream: Could not parse SOP marker !");
        }
        val = sopArray[2] & 0xFF;
        val <<= 8;
        if ((val |= sopArray[3] & 0xFF) != 4) {
            throw new Error("Corrupted Bitstream: Corrupted SOP marker !");
        }
        val = sopArray[4] & 0xFF;
        val <<= 8;
        if (!this.pph && (val |= sopArray[5] & 0xFF) != this.pktIdx) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        if (this.pph && val != this.pktIdx - 1) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        return false;
    }

    public void readEPHMarker(PktHeaderBitReader bin) throws IOException {
        byte[] ephArray = new byte[2];
        if (bin.usebais) {
            bin.bais.read(ephArray, 0, 2);
        } else {
            bin.in.readFully(ephArray, 0, 2);
        }
        int val = ephArray[0];
        val <<= 8;
        if ((val |= ephArray[1]) != -110) {
            throw new Error("Corrupted Bitstream: Could not parse EPH marker ! ");
        }
    }

    public PrecInfo getPrecInfo(int c, int r, int p) {
        return this.ppinfo[c][r][p];
    }
}

