/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import hdf.hdf5lib.HDF5Constants;

public interface IHDF5WriterConfigurator
extends IHDF5ReaderConfigurator {
    public IHDF5WriterConfigurator overwrite();

    public IHDF5WriterConfigurator dontUseExtendableDataTypes();

    public IHDF5WriterConfigurator useSimpleDataSpaceForAttributes();

    public IHDF5WriterConfigurator keepDataSetsIfTheyExist();

    public IHDF5WriterConfigurator fileFormat(FileFormatVersionBounds var1);

    public IHDF5WriterConfigurator syncMode(SyncMode var1);

    @Override
    public IHDF5WriterConfigurator performNumericConversions();

    public IHDF5WriterConfigurator generateMDCImage();

    public IHDF5WriterConfigurator noGenerateMDCImage();

    public IHDF5WriterConfigurator keepMDCImage();

    public IHDF5WriterConfigurator useUTF8CharacterEncoding();

    @Override
    public IHDF5WriterConfigurator noAutoDereference();

    public IHDF5WriterConfigurator houseKeepingNameSuffix(String var1);

    public IHDF5Writer writer();

    public static enum FileFormatVersion {
        EARLIEST(HDF5Constants.H5F_LIBVER_EARLIEST, false),
        LATEST(HDF5Constants.H5F_LIBVER_LATEST, true),
        V1_8(HDF5Constants.H5F_LIBVER_V18, false),
        V1_10(HDF5Constants.H5F_LIBVER_V110, true);

        private final int hdf5Constant;
        private final boolean supportsMDCCache;

        private FileFormatVersion(int hdf5Constant, boolean supportsMDCCache) {
            this.hdf5Constant = hdf5Constant;
            this.supportsMDCCache = supportsMDCCache;
        }

        public boolean supportsMDCCache() {
            return this.supportsMDCCache;
        }

        int getHdf5Constant() {
            return this.hdf5Constant;
        }
    }

    public static enum FileFormatVersionBounds {
        EARLIEST_V1_8(FileFormatVersion.EARLIEST, FileFormatVersion.V1_8),
        EARLIEST_V1_10(FileFormatVersion.EARLIEST, FileFormatVersion.V1_10),
        EARLIEST_LATEST(FileFormatVersion.EARLIEST, FileFormatVersion.LATEST),
        V1_8_V1_8(FileFormatVersion.V1_8, FileFormatVersion.V1_8),
        V1_8_V1_10(FileFormatVersion.V1_8, FileFormatVersion.V1_10),
        V1_8_LATEST(FileFormatVersion.V1_8, FileFormatVersion.LATEST),
        V1_10_V1_10(FileFormatVersion.V1_10, FileFormatVersion.V1_10),
        V1_10_LATEST(FileFormatVersion.V1_10, FileFormatVersion.LATEST),
        LATEST_LATEST(FileFormatVersion.LATEST, FileFormatVersion.LATEST);

        private final FileFormatVersion low;
        private final FileFormatVersion high;

        private FileFormatVersionBounds(FileFormatVersion low, FileFormatVersion high) {
            this.low = low;
            this.high = high;
        }

        public FileFormatVersion getLowBound() {
            return this.low;
        }

        public FileFormatVersion getHighBound() {
            return this.high;
        }

        public static FileFormatVersionBounds getDefault() {
            return EARLIEST_LATEST;
        }
    }

    public static enum SyncMode {
        NO_SYNC,
        SYNC,
        SYNC_BLOCK,
        SYNC_ON_FLUSH,
        SYNC_ON_FLUSH_BLOCK;

    }
}

