/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.prefs;

import ij.Macro;
import ij.Prefs;
import java.util.HashMap;
import loci.plugins.prefs.Option;

public class DoubleOption
extends Option {
    protected double defaultValue;
    protected double value;

    public DoubleOption(HashMap<String, String> entry) {
        this(entry.get("header"), !"false".equals(entry.get("save")), entry.get("label"), entry.get("info"), 0.0);
    }

    public DoubleOption(String key, boolean save, String label, String info, double defaultValue) {
        super(key, save, label, info);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    public double getDefault() {
        return this.defaultValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void parseOption(String arg) {
        String s = Macro.getValue((String)arg, (String)this.key, null);
        if (s != null) {
            this.value = Double.parseDouble(s);
        } else if (this.label != null && (s = Macro.getValue((String)arg, (String)this.label, null)) != null) {
            this.value = Double.parseDouble(s);
        }
    }

    @Override
    public void loadOption() {
        this.value = Prefs.get((String)("bioformats." + this.key), (double)this.defaultValue);
    }

    @Override
    public void saveOption() {
        if (this.save) {
            Prefs.set((String)("bioformats." + this.key), (double)this.value);
        }
    }
}

