/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.file;

import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.file.FileSystemDirectory;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class FileSystemMetadataReader {
    public void read(@NotNull File file2, @NotNull Metadata metadata) throws IOException {
        if (!file2.isFile()) {
            throw new IOException("File object must reference a file");
        }
        if (!file2.exists()) {
            throw new IOException("File does not exist");
        }
        if (!file2.canRead()) {
            throw new IOException("File is not readable");
        }
        FileSystemDirectory directory = metadata.getFirstDirectoryOfType(FileSystemDirectory.class);
        if (directory == null) {
            directory = new FileSystemDirectory();
            metadata.addDirectory(directory);
        }
        directory.setString(1, file2.getName());
        directory.setLong(2, file2.length());
        directory.setDate(3, new Date(file2.lastModified()));
    }
}

