/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.gui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelMerger;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatHandler;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.gui.BufferedImageReader;
import loci.formats.gui.BufferedImageWriter;
import loci.formats.gui.GUITools;
import loci.formats.gui.XMLWindow;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.handlers.DimensionOrderEnumHandler;
import ome.xml.model.enums.handlers.PixelTypeEnumHandler;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ImageViewer
extends JFrame
implements ActionListener,
ChangeListener,
KeyListener,
MouseMotionListener,
Runnable,
WindowListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageViewer.class);
    protected static final String TITLE = "Bio-Formats Viewer";
    protected static final char ANIMATION_KEY = ' ';
    protected JPanel pane;
    protected ImageIcon icon;
    protected JLabel iconLabel;
    protected JPanel sliderPanel;
    protected JSlider nSlider;
    protected JSlider zSlider;
    protected JSlider tSlider;
    protected JSlider cSlider;
    protected JLabel probeLabel;
    protected JMenuItem fileView;
    protected JMenuItem fileSave;
    protected MetadataStore omeMeta;
    protected BufferedImageReader myReader;
    protected BufferedImageWriter myWriter;
    protected IFormatReader fileReader;
    protected IFormatWriter fileWriter;
    protected String filename;
    protected IFormatReader in;
    protected BufferedImage[] images;
    protected int sizeZ;
    protected int sizeT;
    protected int sizeC;
    protected boolean anim = false;
    protected int fps = 10;
    protected boolean canCloseReader = true;
    protected OMEXMLService omexmlService;
    protected final StringBuilder sb = new StringBuilder();

    public ImageViewer() {
        super(TITLE);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.fileReader = new ChannelMerger(new FileStitcher());
        this.myReader = new BufferedImageReader(this.fileReader);
        this.fileWriter = new ImageWriter();
        this.myWriter = new BufferedImageWriter(this.fileWriter);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.omexmlService = factory.getInstance(OMEXMLService.class);
        }
        catch (DependencyException exc) {
            LOGGER.debug("OME-XML service unavailable", exc);
        }
        this.pane = new JPanel();
        this.pane.setLayout(new BorderLayout());
        this.setContentPane(this.pane);
        this.setSize(350, 350);
        this.sliderPanel = new JPanel();
        this.sliderPanel.setVisible(false);
        this.sliderPanel.setBorder(new EmptyBorder(5, 3, 5, 3));
        this.sliderPanel.setLayout(new BoxLayout(this.sliderPanel, 1));
        this.pane.add("South", this.sliderPanel);
        JPanel nPanel = new JPanel();
        nPanel.setLayout(new BoxLayout(nPanel, 0));
        this.sliderPanel.add(nPanel);
        this.sliderPanel.add(Box.createVerticalStrut(2));
        this.nSlider = new JSlider(1, 1);
        this.nSlider.setEnabled(false);
        this.nSlider.addChangeListener(this);
        nPanel.add(new JLabel("N"));
        nPanel.add(Box.createHorizontalStrut(3));
        nPanel.add(this.nSlider);
        JPanel ztcPanel = new JPanel();
        ztcPanel.setLayout(new BoxLayout(ztcPanel, 0));
        this.sliderPanel.add(ztcPanel);
        this.zSlider = new JSlider(1, 1);
        Dimension dim = this.zSlider.getPreferredSize();
        dim.width = 50;
        this.zSlider.setPreferredSize(dim);
        this.zSlider.setEnabled(false);
        this.zSlider.addChangeListener(this);
        ztcPanel.add(new JLabel("Z"));
        ztcPanel.add(Box.createHorizontalStrut(3));
        ztcPanel.add(this.zSlider);
        ztcPanel.add(Box.createHorizontalStrut(7));
        this.tSlider = new JSlider(1, 1);
        this.tSlider.setPreferredSize(dim);
        this.tSlider.setEnabled(false);
        this.tSlider.addChangeListener(this);
        ztcPanel.add(new JLabel("T"));
        ztcPanel.add(Box.createHorizontalStrut(3));
        ztcPanel.add(this.tSlider);
        ztcPanel.add(Box.createHorizontalStrut(7));
        this.cSlider = new JSlider(1, 1);
        this.cSlider.setPreferredSize(dim);
        this.cSlider.setEnabled(false);
        this.cSlider.addChangeListener(this);
        ztcPanel.add(new JLabel("C"));
        ztcPanel.add(Box.createHorizontalStrut(3));
        ztcPanel.add(this.cSlider);
        ztcPanel.add(Box.createHorizontalStrut(7));
        BufferedImage dummy = AWTImageTools.makeImage(new byte[1][1], 1, 1, false);
        this.icon = new ImageIcon(dummy);
        this.iconLabel = new JLabel(this.icon, 2);
        this.iconLabel.setVerticalAlignment(1);
        this.pane.add(new JScrollPane(this.iconLabel));
        this.probeLabel = new JLabel(" ");
        this.probeLabel.setHorizontalAlignment(0);
        this.probeLabel.setBorder(new BevelBorder(0));
        this.pane.add("North", this.probeLabel);
        this.iconLabel.addMouseMotionListener(this);
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu file2 = new JMenu("File");
        file2.setMnemonic('f');
        menubar.add(file2);
        JMenuItem fileOpen = new JMenuItem("Open...");
        fileOpen.setMnemonic('o');
        fileOpen.setActionCommand("open");
        fileOpen.addActionListener(this);
        file2.add(fileOpen);
        this.fileSave = new JMenuItem("Save...");
        this.fileSave.setMnemonic('s');
        this.fileSave.setEnabled(false);
        this.fileSave.setActionCommand("save");
        this.fileSave.addActionListener(this);
        file2.add(this.fileSave);
        if (this.omexmlService != null) {
            this.fileView = new JMenuItem("View Metadata...");
            this.fileView.setMnemonic('m');
            this.fileView.setEnabled(true);
            this.fileView.setActionCommand("view");
            this.fileView.addActionListener(this);
            file2.add(this.fileView);
        }
        JMenuItem fileExit = new JMenuItem("Exit");
        fileExit.setMnemonic('x');
        fileExit.setActionCommand("exit");
        fileExit.addActionListener(this);
        file2.add(fileExit);
        JMenu options = new JMenu("Options");
        options.setMnemonic('p');
        menubar.add(options);
        JMenuItem optionsFPS = new JMenuItem("Frames per Second...");
        optionsFPS.setMnemonic('f');
        optionsFPS.setActionCommand("fps");
        optionsFPS.addActionListener(this);
        options.add(optionsFPS);
        JMenu help = new JMenu("Help");
        help.setMnemonic('h');
        menubar.add(help);
        JMenuItem helpAbout = new JMenuItem("About...");
        helpAbout.setMnemonic('a');
        helpAbout.setActionCommand("about");
        helpAbout.addActionListener(this);
        help.add(helpAbout);
        this.nSlider.addKeyListener(this);
        this.zSlider.addKeyListener(this);
        this.tSlider.addKeyListener(this);
        this.cSlider.addKeyListener(this);
    }

    public ImageViewer(boolean canCloseReader) {
        this();
        this.canCloseReader = canCloseReader;
    }

    public void open(String id) {
        this.wait(true);
        try {
            OMEXMLMetadata meta = null;
            if (this.omexmlService != null) {
                try {
                    meta = this.omexmlService.createOMEXMLMetadata();
                    this.myReader.setMetadataStore(meta);
                }
                catch (ServiceException exc) {
                    LOGGER.debug("Could not create OME-XML metadata", exc);
                }
            }
            if (meta == null) {
                LOGGER.info("OME metadata unavailable");
            }
            this.myReader.setId(id);
            int num = this.myReader.getImageCount();
            ProgressMonitor progress = new ProgressMonitor(this, "Reading " + id, null, 0, num + 1);
            this.sizeZ = this.myReader.getSizeZ();
            this.sizeT = this.myReader.getSizeT();
            this.sizeC = this.myReader.getEffectiveSizeC();
            progress.setProgress(1);
            BufferedImage[] img = new BufferedImage[num];
            for (int i = 0; i < num && !progress.isCanceled(); ++i) {
                img[i] = this.myReader.openImage(i);
                if (i == 0) {
                    this.setImages(this.myReader, img);
                }
                progress.setProgress(i + 2);
            }
            this.myReader.close(true);
        }
        catch (FormatException exc) {
            LOGGER.info("", exc);
            this.wait(false);
            return;
        }
        catch (IOException exc) {
            LOGGER.info("", exc);
            this.wait(false);
            return;
        }
        this.wait(false);
    }

    public void save(String id) {
        if (this.images == null) {
            return;
        }
        this.wait(true);
        try {
            if (this.omeMeta == null) {
                this.omeMeta = this.omexmlService.createOMEXMLMetadata();
                this.omeMeta.setImageID(MetadataTools.createLSID("Image", 0), 0);
                this.omeMeta.setPixelsID(MetadataTools.createLSID("Pixels", 0), 0);
                this.omeMeta.setPixelsBigEndian(false, 0);
                String order = "XYCZT";
                if (this.in != null) {
                    order = this.in.getDimensionOrder();
                }
                this.omeMeta.setPixelsDimensionOrder((DimensionOrder)new DimensionOrderEnumHandler().getEnumeration(order), 0);
                int type = AWTImageTools.getPixelType(this.images[0]);
                String pixelType = FormatTools.getPixelTypeString(type);
                this.omeMeta.setPixelsType((PixelType)new PixelTypeEnumHandler().getEnumeration(pixelType), 0);
                int rgbChannelCount = this.images[0].getRaster().getNumBands();
                int realChannelCount = this.sizeC / rgbChannelCount;
                for (int i = 0; i < realChannelCount; ++i) {
                    this.omeMeta.setChannelID(MetadataTools.createLSID("Channel", i, 0), 0, i);
                    this.omeMeta.setChannelSamplesPerPixel(new PositiveInteger(rgbChannelCount), 0, i);
                }
                this.omeMeta.setPixelsSizeX(new PositiveInteger(this.images[0].getWidth()), 0);
                this.omeMeta.setPixelsSizeY(new PositiveInteger(this.images[0].getHeight()), 0);
                this.omeMeta.setPixelsSizeC(new PositiveInteger(this.sizeC), 0);
                this.omeMeta.setPixelsSizeZ(new PositiveInteger(this.sizeZ), 0);
                this.omeMeta.setPixelsSizeT(new PositiveInteger(this.sizeT), 0);
            }
            this.myWriter.setMetadataRetrieve(this.omexmlService.asRetrieve(this.omeMeta));
            this.myWriter.setId(id);
            boolean stack = this.myWriter.canDoStacks();
            ProgressMonitor progress = new ProgressMonitor(this, "Saving " + id, null, 0, stack ? this.images.length : 1);
            if (stack) {
                for (int i = 0; i < this.images.length; ++i) {
                    progress.setProgress(i);
                    boolean canceled = progress.isCanceled();
                    this.myWriter.saveImage(i, this.images[i]);
                    if (canceled) break;
                }
                progress.setProgress(this.images.length);
            } else {
                this.myWriter.savePlane(0, this.getImage());
                progress.setProgress(1);
            }
            this.myWriter.close();
        }
        catch (FormatException exc) {
            LOGGER.info("", exc);
        }
        catch (IOException exc) {
            LOGGER.info("", exc);
        }
        catch (ServiceException exc) {
            LOGGER.info("", exc);
        }
        catch (EnumerationException exc) {
            LOGGER.info("", exc);
        }
        this.wait(false);
    }

    public void setImages(BufferedImage[] img) {
        this.setImages(null, img);
    }

    public void setImages(IFormatReader reader, BufferedImage[] img) {
        String format;
        this.filename = reader == null ? null : reader.getCurrentFile();
        this.in = reader;
        this.images = img;
        if (reader == null) {
            this.sizeT = 1;
            this.sizeC = 1;
            this.sizeZ = 1;
        } else {
            this.sizeZ = reader.getSizeZ();
            this.sizeT = reader.getSizeT();
            this.sizeC = reader.getEffectiveSizeC();
            this.omeMeta = reader.getMetadataStore();
            if (this.omexmlService == null || !this.omexmlService.isOMEXMLMetadata(this.omeMeta)) {
                this.omeMeta = null;
            }
        }
        this.fileView.setEnabled(this.omeMeta != null);
        this.fileSave.setEnabled(true);
        this.nSlider.removeChangeListener(this);
        this.zSlider.removeChangeListener(this);
        this.tSlider.removeChangeListener(this);
        this.cSlider.removeChangeListener(this);
        this.nSlider.setValue(1);
        this.nSlider.setMaximum(this.images.length);
        this.nSlider.setEnabled(this.images.length > 1);
        this.zSlider.setValue(1);
        this.zSlider.setMaximum(this.sizeZ);
        this.zSlider.setEnabled(this.sizeZ > 1);
        this.tSlider.setValue(1);
        this.tSlider.setMaximum(this.sizeT);
        this.tSlider.setEnabled(this.sizeT > 1);
        this.cSlider.setValue(1);
        this.cSlider.setMaximum(this.sizeC);
        this.cSlider.setEnabled(this.sizeC > 1);
        this.nSlider.addChangeListener(this);
        this.zSlider.addChangeListener(this);
        this.tSlider.addChangeListener(this);
        this.cSlider.addChangeListener(this);
        this.sliderPanel.setVisible(this.images.length > 1);
        this.updateLabel(-1, -1);
        this.sb.setLength(0);
        if (this.filename != null) {
            this.sb.append(reader.getCurrentFile());
            this.sb.append(" ");
        }
        String string = format = reader == null ? null : reader.getFormat();
        if (format != null) {
            this.sb.append("(");
            this.sb.append(format);
            this.sb.append(")");
            this.sb.append(" ");
        }
        if (this.filename != null || format != null) {
            this.sb.append("- ");
        }
        this.sb.append(TITLE);
        this.setTitle(this.sb.toString());
        if (this.images != null) {
            this.icon.setImage(this.images[0]);
        }
        this.pack();
    }

    public BufferedImage getImage() {
        int ndx = this.getImageIndex();
        return this.images == null || ndx >= this.images.length ? null : this.images[ndx];
    }

    public int getImageIndex() {
        return this.nSlider.getValue() - 1;
    }

    public int getZ() {
        return this.zSlider.getValue() - 1;
    }

    public int getT() {
        return this.tSlider.getValue() - 1;
    }

    public int getC() {
        return this.cSlider.getValue() - 1;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        new Thread(this).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("open".equals(cmd)) {
            File file2;
            this.wait(true);
            JFileChooser chooser = GUITools.buildFileChooser(this.myReader);
            this.wait(false);
            int rval = chooser.showOpenDialog(this);
            if (rval == 0 && (file2 = chooser.getSelectedFile()) != null) {
                this.open(file2.getAbsolutePath(), this.fileReader);
            }
        } else if ("save".equals(cmd)) {
            File file3;
            this.wait(true);
            JFileChooser chooser = GUITools.buildFileChooser(this.myWriter);
            this.wait(false);
            int rval = chooser.showSaveDialog(this);
            if (rval == 0 && (file3 = chooser.getSelectedFile()) != null) {
                this.save(file3.getAbsolutePath(), this.fileWriter);
            }
        } else if ("view".equals(cmd)) {
            if (this.omeMeta != null) {
                XMLWindow metaWindow = new XMLWindow("OME Metadata - " + this.getTitle());
                metaWindow.setDefaultCloseOperation(2);
                Exception exception = null;
                try {
                    MetadataRetrieve retrieve = this.omexmlService.asRetrieve(this.omeMeta);
                    metaWindow.setXML(this.omexmlService.getOMEXML(retrieve));
                    metaWindow.setVisible(true);
                }
                catch (ServiceException exc) {
                    exception = exc;
                }
                catch (ParserConfigurationException exc) {
                    exception = exc;
                }
                catch (SAXException exc) {
                    exception = exc;
                }
                catch (IOException exc) {
                    exception = exc;
                }
                if (exception != null) {
                    LOGGER.info("Cannot display OME metadata", exception);
                }
            }
        } else if ("exit".equals(cmd)) {
            this.dispose();
        } else if ("fps".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            String result = JOptionPane.showInputDialog(this, "Animate using space bar. How many frames per second?", "" + this.fps);
            try {
                this.fps = Integer.parseInt(result);
            }
            catch (NumberFormatException exc) {
                LOGGER.debug("Could not parse fps '{}'", (Object)this.fps, (Object)exc);
            }
        } else if ("about".equals(cmd)) {
            this.setDefaultCloseOperation(3);
            String msg = "<html>OME Bio-Formats package for reading and converting biological file formats.<br>Copyright (C) 2005 - " + FormatTools.YEAR + " Open Microscopy Environment:<ul><li>Board of Regents of the University of Wisconsin-Madison</li><li>Glencoe Software, Inc.</li><li>University of Dundee</li></ul><i>" + "https://www.openmicroscopy.org/bio-formats" + "</i><br>Version " + FormatTools.VERSION + " (VCS revision " + FormatTools.VCS_REVISION + "), built on " + FormatTools.DATE + "<br><br>See <a href=\"https://docs.openmicroscopy.org/bio-formats/" + FormatTools.VERSION + "/users/index.html\">https://docs.openmicroscopy.org/bio-formats/" + FormatTools.VERSION + "/users/index.html</a><br>for help with using Bio-Formats.";
            ImageIcon bioFormatsLogo = new ImageIcon(IFormatHandler.class.getResource("bio-formats-logo.png"));
            JOptionPane.showMessageDialog(null, msg, "Bio-Formats", 1, bioFormatsLogo);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        BufferedImage image;
        int ndx;
        Object src = e.getSource();
        boolean outOfBounds = false;
        if (src == this.nSlider) {
            int[] zct;
            int[] nArray;
            ndx = this.getImageIndex();
            if (this.in == null) {
                int[] nArray2 = new int[3];
                nArray2[0] = -1;
                nArray2[1] = -1;
                nArray = nArray2;
                nArray2[2] = -1;
            } else {
                nArray = zct = this.in.getZCTCoords(ndx);
            }
            if (zct[0] >= 0) {
                this.zSlider.removeChangeListener(this);
                this.zSlider.setValue(zct[0] + 1);
                this.zSlider.addChangeListener(this);
            }
            if (zct[1] >= 0) {
                this.cSlider.removeChangeListener(this);
                this.cSlider.setValue(zct[1] + 1);
                this.cSlider.addChangeListener(this);
            }
            if (zct[2] >= 0) {
                this.tSlider.removeChangeListener(this);
                this.tSlider.setValue(zct[2] + 1);
                this.tSlider.addChangeListener(this);
            }
        } else {
            int n = ndx = this.in == null ? -1 : this.in.getIndex(this.getZ(), this.getC(), this.getT());
            if (ndx >= 0) {
                this.nSlider.removeChangeListener(this);
                outOfBounds = ndx >= this.nSlider.getMaximum();
                this.nSlider.setValue(ndx + 1);
                this.nSlider.addChangeListener(this);
            }
        }
        this.updateLabel(-1, -1);
        BufferedImage bufferedImage = image = outOfBounds ? null : this.getImage();
        if (image == null) {
            this.iconLabel.setIcon(null);
            this.iconLabel.setText("No image plane");
        } else {
            this.icon.setImage(image);
            this.iconLabel.setIcon(this.icon);
            this.iconLabel.setText(null);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            this.anim = !this.anim;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateLabel(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.updateLabel(e.getX(), e.getY());
    }

    @Override
    public void run() {
        while (this.isVisible()) {
            if (this.anim) {
                int t2 = this.tSlider.getValue();
                t2 = t2 % this.tSlider.getMaximum() + 1;
                this.tSlider.setValue(t2);
            }
            try {
                Thread.sleep(1000 / this.fps);
            }
            catch (InterruptedException exc) {
                LOGGER.debug("", exc);
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        try {
            this.myReader.close();
            this.myWriter.close();
            if (this.canCloseReader) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void updateLabel(int x, int y) {
        int h2;
        BufferedImage image;
        if (this.images == null) {
            return;
        }
        int ndx = this.getImageIndex();
        this.sb.setLength(0);
        if (this.images.length > 1) {
            this.sb.append("N=");
            this.sb.append(ndx + 1);
            this.sb.append("/");
            this.sb.append(this.images.length);
        }
        if (this.sizeZ > 1) {
            this.sb.append("; Z=");
            this.sb.append(this.getZ() + 1);
            this.sb.append("/");
            this.sb.append(this.sizeZ);
        }
        if (this.sizeT > 1) {
            this.sb.append("; T=");
            this.sb.append(this.getT() + 1);
            this.sb.append("/");
            this.sb.append(this.sizeT);
        }
        if (this.sizeC > 1) {
            this.sb.append("; C=");
            this.sb.append(this.getC() + 1);
            this.sb.append("/");
            this.sb.append(this.sizeC);
        }
        int w = (image = this.images[ndx]) == null ? -1 : image.getWidth();
        int n = h2 = image == null ? -1 : image.getHeight();
        if (x >= w) {
            x = w - 1;
        }
        if (y >= h2) {
            y = h2 - 1;
        }
        if (x >= 0 && y >= 0) {
            if (this.images.length > 1) {
                this.sb.append("; ");
            }
            this.sb.append("X=");
            this.sb.append(x);
            if (w > 0) {
                this.sb.append("/");
                this.sb.append(w);
            }
            this.sb.append("; Y=");
            this.sb.append(y);
            if (h2 > 0) {
                this.sb.append("/");
                this.sb.append(h2);
            }
            if (image != null) {
                WritableRaster r = image.getRaster();
                double[] pix = r.getPixel(x, y, (double[])null);
                this.sb.append("; value");
                this.sb.append(pix.length > 1 ? "s=(" : "=");
                for (int i = 0; i < pix.length; ++i) {
                    if (i > 0) {
                        this.sb.append(", ");
                    }
                    this.sb.append(pix[i]);
                }
                if (pix.length > 1) {
                    this.sb.append(")");
                }
                this.sb.append("; type=");
                int pixelType = AWTImageTools.getPixelType(image);
                this.sb.append(FormatTools.getPixelTypeString(pixelType));
            }
        }
        this.sb.append(" ");
        this.probeLabel.setText(this.sb.toString());
    }

    protected void wait(boolean wait) {
        this.setCursor(wait ? Cursor.getPredefinedCursor(3) : null);
    }

    protected void open(final String id, final IFormatReader r) {
        new Thread("ImageViewer-Opener"){

            @Override
            public void run() {
                try {
                    ImageViewer.this.myReader.close();
                }
                catch (IOException exc) {
                    LOGGER.info("", exc);
                }
                ImageViewer.this.myReader = new BufferedImageReader(r);
                ImageViewer.this.open(id);
            }
        }.start();
    }

    protected void save(final String id, final IFormatWriter w) {
        new Thread("ImageViewer-Saver"){

            @Override
            public void run() {
                try {
                    ImageViewer.this.myWriter.close();
                }
                catch (IOException exc) {
                    LOGGER.info("", exc);
                }
                ImageViewer.this.myWriter = BufferedImageWriter.makeBufferedImageWriter(w);
                ImageViewer.this.save(id);
            }
        }.start();
    }

    public static void main(String[] args) {
        ImageViewer viewer = new ImageViewer();
        viewer.setVisible(true);
        if (args.length > 0) {
            viewer.open(args[0]);
        }
    }
}

