/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LeicaSCNReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeicaSCNReader.class);
    private static final String SCHEMA_2010_03 = "http://www.leica-microsystems.com/scn/2010/03/10";
    private static final String SCHEMA_2010_10 = "http://www.leica-microsystems.com/scn/2010/10/01";
    private static final String[] MODELS_WITHOUT_CORRECTION = new String[]{"versa", "leica scn400"};
    LeicaSCNHandler handler;

    public LeicaSCNReader() {
        super("Leica SCN", new String[]{"scn"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.canSeparateSeries = false;
        this.noSubresolutions = true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isThisType(String name, boolean open) {
        block13: {
            if (super.isThisType(name, open) && open) {
                try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
                    TiffParser tiffParser = new TiffParser(stream);
                    if (!tiffParser.isValidHeader()) {
                        boolean bl = false;
                        return bl;
                    }
                    String imageDescription = tiffParser.getComment();
                    if (imageDescription == null) break block13;
                    try {
                        LeicaSCNHandler handler = new LeicaSCNHandler();
                        XMLTools.parseXML((String)imageDescription, (DefaultHandler)handler);
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception se) {
                        LOGGER.debug("XML parsing failed", (Throwable)se);
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("I/O exception during isThisType() evaluation.", (Throwable)e);
                }
            }
        }
        return false;
    }

    private int imageIFD(int no) {
        int s = this.getCoreIndex();
        Image i = this.handler.imageMap.get(s);
        int[] dims = this.getZCTCoords(no);
        int dz = dims[0];
        int dc = dims[1];
        int dr = s - this.getParent(s);
        return i.pixels.lookupDimension((int)dz, (int)dc, (int)dr).ifd;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        int ifd = this.imageIFD(no);
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, (long)w, (long)h);
        return buf;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        int originalIndex = this.getCoreIndex();
        Image i = this.handler.imageMap.get(this.getCoreIndex());
        this.setCoreIndex(this.getParent(originalIndex) + i.imageThumbnail);
        byte[] thumb = FormatTools.openThumbBytes((IFormatReader)this, (int)no);
        this.setCoreIndex(originalIndex);
        return thumb;
    }

    public int getThumbSizeX() {
        int originalIndex = this.getCoreIndex();
        Image i = this.handler.imageMap.get(this.getCoreIndex());
        this.setCoreIndex(this.getParent(originalIndex) + i.imageThumbnail);
        int size = super.getThumbSizeX();
        this.setCoreIndex(originalIndex);
        return size;
    }

    public int getThumbSizeY() {
        int originalIndex = this.getCoreIndex();
        Image i = this.handler.imageMap.get(this.getCoreIndex());
        this.setCoreIndex(this.getParent(originalIndex) + i.imageThumbnail);
        int size = super.getThumbSizeY();
        this.setCoreIndex(originalIndex);
        return size;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.handler = null;
        if (!fileOnly) {
            // empty if block
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", (Throwable)e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", (Throwable)e);
            return super.getOptimalTileHeight();
        }
    }

    protected void initTiffParser() {
        super.initTiffParser();
        if (this.handler != null) {
            Image i = this.handler.imageMap.get(0);
            String model = i.devModel == null ? i.devModel : i.devModel.toLowerCase();
            this.tiffParser.setYCbCrCorrection(!Arrays.asList(MODELS_WITHOUT_CORRECTION).contains(model));
        }
    }

    protected void initCoreMetadata(int series, int resolution) throws FormatException, IOException {
        Dimension dimension;
        int pos = this.core.flattenedIndex(series, resolution);
        ImageCollection c = this.handler.collection;
        Image i = this.handler.imageMap.get(pos);
        if (c == null || i == null) {
            throw new FormatException("Error setting core metadata for series " + series + " resolution " + resolution);
        }
        CoreMetadata ms = (CoreMetadata)this.core.get(series, resolution);
        if (resolution == 0) {
            ms.resolutionCount = i.pixels.sizeR;
            if (ms.resolutionCount == 0) {
                ms.resolutionCount = 1;
            }
        }
        if ((dimension = i.pixels.lookupDimension(0, 0, resolution)) == null) {
            throw new FormatException("No dimension information for subresolution=" + resolution);
        }
        IFD ifd = (IFD)this.ifds.get(dimension.ifd);
        PhotoInterp pi = ifd.getPhotometricInterpretation();
        int samples = ifd.getSamplesPerPixel();
        ms.rgb = samples > 1 || pi == PhotoInterp.RGB;
        ms.sizeX = (int)dimension.sizeX;
        ms.sizeY = (int)dimension.sizeY;
        ms.sizeZ = i.pixels.sizeZ;
        ms.sizeT = 1;
        int n = ms.sizeC = ms.rgb ? samples : i.pixels.sizeC;
        if (ms.sizeX == 0) {
            ms.sizeX = (int)ifd.getImageWidth();
        }
        if (ms.sizeY == 0) {
            ms.sizeY = (int)ifd.getImageLength();
        }
        if (ms.sizeZ == 0) {
            ms.sizeZ = 1;
        }
        if (ms.sizeC == 0) {
            ms.sizeC = 1;
        }
        if (ifd.getImageWidth() != (long)ms.sizeX || ifd.getImageLength() != (long)ms.sizeY) {
            throw new FormatException("IFD dimensions do not match XML dimensions for image " + pos + ": x=" + ifd.getImageWidth() + ", " + ms.sizeX + ", y=" + ifd.getImageLength() + ", " + ms.sizeY);
        }
        ms.orderCertain = true;
        ms.littleEndian = ifd.isLittleEndian();
        ms.indexed = pi == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        ms.imageCount = ms.sizeZ * (ms.rgb ? 1 : ms.sizeC);
        ms.pixelType = ifd.getPixelType();
        ms.metadataComplete = true;
        ms.interleaved = false;
        ms.falseColor = false;
        ms.dimensionOrder = "XYCZT";
        ms.thumbnail = i.imageThumbnail == resolution;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.tiffParser.setDoCaching(true);
        String imageDescription = this.tiffParser.getComment();
        this.handler = new LeicaSCNHandler();
        if (imageDescription != null) {
            try {
                LOGGER.trace("Image description XML = {}", (Object)imageDescription);
                XMLTools.parseXML((String)imageDescription, (DefaultHandler)this.handler);
            }
            catch (Exception se) {
                throw new FormatException("Failed to parse XML", (Throwable)se);
            }
        }
        this.initTiffParser();
        this.tiffParser.setDoCaching(true);
        int count = this.handler.count();
        this.ifds = this.tiffParser.getMainIFDs();
        if (this.ifds.size() < count) {
            count = this.ifds.size();
        }
        this.core.clear();
        int currentSeries = 0;
        int currentResolution = 0;
        for (int i = 0; i < count; ++i) {
            if (currentResolution == 0) {
                this.core.add();
            }
            CoreMetadata ms = new CoreMetadata();
            this.core.add(currentSeries, ms);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(this.handler.IFDMap.get(i).intValue()));
            this.initCoreMetadata(currentSeries, currentResolution);
            if (++currentResolution != ((CoreMetadata)this.core.get((int)currentSeries, (int)0)).resolutionCount) continue;
            ++currentSeries;
            currentResolution = 0;
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        HashMap<String, Integer> instrumentIDs = new HashMap<String, Integer>();
        int instrumentidno = 0;
        HashMap<String, String> objectives = new HashMap<String, String>();
        int objectiveidno = 0;
        int pos = 0;
        for (int s = 0; s < this.core.size(); ++s) {
            for (int r = 0; r < this.core.size(s); ++r) {
                int coreIndex = this.core.flattenedIndex(s, r);
                this.setCoreIndex(coreIndex);
                ImageCollection c = this.handler.collection;
                Image i = this.handler.imageMap.get(coreIndex);
                int subresolution = r;
                if (!this.hasFlattenedResolutions()) {
                    subresolution = 0;
                }
                if (!this.hasFlattenedResolutions() && r > 0) continue;
                Dimension dimension = i.pixels.lookupDimension(0, 0, r);
                if (dimension == null) {
                    throw new FormatException("No dimension information for subresolution=" + subresolution);
                }
                double sizeX = (double)i.vSizeX / 1000.0;
                double sizeY = (double)i.vSizeY / 1000.0;
                Length offsetX = new Length((Number)i.vOffsetX, UNITS.NANOMETER);
                Length offsetY = new Length((Number)i.vOffsetY, UNITS.NANOMETER);
                double sizeZ = (double)i.vSpacingZ / 1000.0;
                store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX((Double)(sizeX / (double)dimension.sizeX)), pos);
                store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY((Double)(sizeY / (double)dimension.sizeY)), pos);
                store.setPixelsPhysicalSizeZ(FormatTools.getPhysicalSizeZ((Double)sizeZ), pos);
                if (instrumentIDs.get(i.devModel) == null) {
                    String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{instrumentidno});
                    instrumentIDs.put(i.devModel, instrumentidno);
                    store.setInstrumentID(instrumentID, instrumentidno);
                    ++instrumentidno;
                }
                int inst = (Integer)instrumentIDs.get(i.devModel);
                String objectiveName = i.devModel + ":" + i.objMag;
                if (objectives.get(objectiveName) == null && i.objMag != null) {
                    String objectiveID = MetadataTools.createLSID((String)"Objective", (int[])new int[]{inst, objectiveidno});
                    objectives.put(objectiveName, objectiveID);
                    store.setObjectiveID(objectiveID, inst, objectiveidno);
                    Double mag = Double.parseDouble(i.objMag);
                    store.setObjectiveNominalMagnification(mag, inst, objectiveidno);
                    store.setObjectiveCalibratedMagnification(mag, inst, objectiveidno);
                    store.setObjectiveLensNA(DataTools.parseDouble((String)i.illumNA), inst, objectiveidno);
                    ++objectiveidno;
                }
                store.setImageInstrumentRef(MetadataTools.createLSID((String)"Instrument", (int[])new int[]{inst}), pos);
                if (objectives.containsKey(objectiveName)) {
                    store.setObjectiveSettingsID((String)objectives.get(objectiveName), pos);
                }
                if (i.illumSource != null && i.illumSource.equals("brightfield")) {
                    store.setChannelIlluminationType(IlluminationType.TRANSMITTED, pos, 0);
                } else {
                    store.setChannelIlluminationType(IlluminationType.OTHER, pos, 0);
                    LOGGER.debug("Unknown illumination source {}", (Object)i.illumSource);
                }
                CoreMetadata ms = (CoreMetadata)this.core.get(s, r);
                for (int q = 0; q < ms.imageCount; ++q) {
                    store.setPlanePositionX(offsetX, pos, q);
                    store.setPlanePositionY(offsetY, pos, q);
                }
                if (this.hasFlattenedResolutions()) {
                    store.setImageName(i.name + " (R" + subresolution + ")", pos);
                } else if (pos == 0) {
                    store.setImageName("macro", pos);
                } else if (ms.resolutionCount > 1) {
                    store.setImageName("", pos);
                } else {
                    store.setImageName(i.name, pos);
                }
                store.setImageDescription("Collection " + c.name, pos);
                if (i.creationDate != null) {
                    store.setImageAcquisitionDate(new Timestamp(i.creationDate), pos);
                }
                this.addSeriesMeta("collection.name", c.name);
                this.addSeriesMeta("collection.uuid", c.uuid);
                this.addSeriesMeta("collection.barcode", c.barcode);
                this.addSeriesMeta("collection.ocr", c.ocr);
                this.addSeriesMeta("creationDate", i.creationDate);
                this.addSeriesMeta("device.model for image", i.devModel);
                this.addSeriesMeta("device.version for image", i.devVersion);
                this.addSeriesMeta("view.sizeX for image", i.vSizeX);
                this.addSeriesMeta("view.sizeY for image", i.vSizeY);
                this.addSeriesMeta("view.offsetX for image", i.vOffsetX);
                this.addSeriesMeta("view.offsetY for image", i.vOffsetY);
                this.addSeriesMeta("view.spacingZ for image", i.vSpacingZ);
                this.addSeriesMeta("scanSettings.objectiveSettings.objective for image", i.objMag);
                this.addSeriesMeta("scanSettings.illuminationSettings.numericalAperture for image", i.illumNA);
                this.addSeriesMeta("scanSettings.illuminationSettings.illuminationSource for image", i.illumSource);
                ++pos;
            }
        }
        this.setCoreIndex(0);
    }

    private int getParent(int coreIndex) {
        int[] pos = this.core.flattenedIndexes(coreIndex);
        return this.core.flattenedIndex(pos[0], 0);
    }

    class LeicaSCNHandler
    extends DefaultHandler {
        boolean valid = false;
        public ImageCollection collection;
        public Image currentImage;
        public int seriesIndex;
        public ArrayList<Integer> IFDMap = new ArrayList();
        public ArrayList<Image> imageMap = new ArrayList();
        public Deque<String> nameStack = new ArrayDeque<String>();
        public String cdata;
        public int resolutionCount = 0;

        LeicaSCNHandler() {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!this.nameStack.isEmpty() && this.nameStack.peek().equals(qName)) {
                this.nameStack.pop();
            }
            if (qName.equals("image")) {
                this.currentImage.imageNumStart = this.seriesIndex;
                this.seriesIndex += this.currentImage.pixels.sizeR * this.currentImage.pixels.sizeC * this.currentImage.pixels.sizeZ;
                this.currentImage.imageNumEnd = this.seriesIndex - 1;
                this.resolutionCount += this.currentImage.pixels.sizeR;
                this.currentImage = null;
            } else if (qName.equals("creationDate")) {
                this.currentImage.creationDate = this.cdata;
            } else if (qName.equals("pixels")) {
                Pixels p = this.currentImage.pixels;
                int sizeC = 0;
                int sizeR = 0;
                int sizeZ = 0;
                for (Dimension d : p.dims) {
                    if (d.c > sizeC) {
                        sizeC = d.c;
                    }
                    if (d.r > sizeR) {
                        sizeR = d.r;
                    }
                    if (d.z <= sizeZ) continue;
                    sizeZ = d.z;
                }
                p.sizeC = ++sizeC;
                p.sizeR = ++sizeR;
                p.sizeZ = ++sizeZ;
                for (Dimension d : p.dims) {
                    if (d.r != 0 && this.currentImage.thumbSizeX <= d.sizeX) continue;
                    this.currentImage.thumbSizeX = d.sizeX;
                    this.currentImage.imageThumbnail = d.r;
                }
                for (int cr = 0; cr < sizeR; ++cr) {
                    this.imageMap.add(this.currentImage);
                    for (int cc = 0; cc < sizeC; ++cc) {
                        for (int cz = 0; cz < sizeZ; ++cz) {
                            this.IFDMap.add(p.lookupDimension((int)cz, (int)cc, (int)cr).ifd);
                        }
                    }
                }
            } else if (qName.equals("objective")) {
                this.currentImage.objMag = this.cdata;
            } else if (qName.equals("numericalAperture")) {
                this.currentImage.illumNA = this.cdata;
            } else if (qName.equals("illuminationSource")) {
                this.currentImage.illumSource = this.cdata;
            }
            this.cdata = null;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String s = new String(ch, start, length);
            this.cdata = this.cdata == null ? s : this.cdata + s;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.cdata = null;
            if (qName.equals("scn")) {
                String ns = attributes.getValue("xmlns");
                if (ns == null) {
                    throw new SAXException("Invalid Leica SCN XML");
                }
                if (!ns.equals(LeicaSCNReader.SCHEMA_2010_03) && !ns.equals(LeicaSCNReader.SCHEMA_2010_10)) {
                    LOGGER.warn("Unknown Leica SCN XML schema: " + ns + "; this file may not be read correctly");
                }
                this.valid = true;
                this.seriesIndex = 0;
            }
            if (!this.valid) {
                throw new SAXException("Invalid Leica SCN XML");
            }
            if (qName.equals("collection")) {
                this.collection = new ImageCollection(attributes);
            } else if (qName.equals("image")) {
                this.currentImage = new Image(attributes);
                this.collection.images.add(this.currentImage);
            } else if (qName.equals("device")) {
                this.currentImage.devModel = attributes.getValue("model");
                this.currentImage.devVersion = attributes.getValue("version");
            } else if (qName.equals("pixels")) {
                if (this.currentImage.pixels != null) throw new SAXException("Invalid Leica SCN XML: Multiple pixels elements for single image");
                this.currentImage.pixels = new Pixels(attributes);
            } else if (qName.equals("dimension")) {
                this.currentImage.pixels.dims.add(new Dimension(attributes));
            } else if (qName.equals("view")) {
                this.currentImage.setView(attributes);
            } else if (qName.equals("supplementalImage")) {
                String type = attributes.getValue("type");
                String ifd = attributes.getValue("ifd");
                if (ifd != null) {
                    this.currentImage = new Image(attributes);
                    this.currentImage.pixels = new Pixels(attributes);
                    Dimension dim = new Dimension(attributes);
                    this.currentImage.pixels.dims.add(dim);
                    this.currentImage.name = type;
                    this.collection.images.add(this.currentImage);
                    this.imageMap.add(this.currentImage);
                    this.IFDMap.add(Integer.parseInt(ifd));
                    ++this.resolutionCount;
                }
            }
            this.nameStack.push(qName);
        }

        int count() {
            return this.resolutionCount;
        }
    }

    class Image {
        int imageNumStart;
        int imageNumEnd;
        int imageThumbnail;
        long thumbSizeX;
        String name;
        String uuid;
        String creationDate;
        String devModel;
        String devVersion;
        Pixels pixels;
        long vSizeX;
        long vSizeY;
        long vOffsetX;
        long vOffsetY;
        long vSpacingZ;
        String objMag;
        String illumNA;
        String illumSource;

        Image(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
        }

        void setView(Attributes attrs) {
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.vSizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.vSizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetX")) != null) {
                this.vOffsetX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("offsetY")) != null) {
                this.vOffsetY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("spacingZ")) != null) {
                this.vSpacingZ = Long.parseLong(s);
            }
        }
    }

    class Pixels {
        ArrayList<Dimension> dims = new ArrayList();
        long sizeX;
        long sizeY;
        int sizeZ;
        int sizeC;
        int sizeR;
        int lastIFD;

        Pixels(Attributes attrs) {
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
        }

        public Dimension lookupDimension(int z, int c, int resolution) {
            for (Dimension d : this.dims) {
                if (d.z != z || d.c != c || d.r != resolution) continue;
                return d;
            }
            return null;
        }
    }

    class Dimension {
        long sizeX = 0L;
        long sizeY = 0L;
        int z = 0;
        int c = 0;
        int r = 0;
        int ifd = 0;

        Dimension(Attributes attrs) {
            String s = attrs.getValue("r");
            if (s != null) {
                this.r = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("z")) != null) {
                this.z = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("c")) != null) {
                this.c = Integer.parseInt(s);
            }
            if ((s = attrs.getValue("sizeX")) != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            if ((s = attrs.getValue("ifd")) != null) {
                this.ifd = Integer.parseInt(s);
            }
        }
    }

    class ImageCollection {
        String name;
        String uuid;
        long sizeX;
        long sizeY;
        String barcode;
        String ocr;
        ArrayList<Image> images;

        ImageCollection(Attributes attrs) {
            this.name = attrs.getValue("name");
            this.uuid = attrs.getValue("uuid");
            String s = attrs.getValue("sizeX");
            if (s != null) {
                this.sizeX = Long.parseLong(s);
            }
            if ((s = attrs.getValue("sizeY")) != null) {
                this.sizeY = Long.parseLong(s);
            }
            this.barcode = attrs.getValue("barcode");
            this.ocr = attrs.getValue("ocr");
            this.images = new ArrayList();
        }
    }
}

