/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.transform.vertical.VerticalCTBuilder;

@Immutable
public class CoordinatesHelper {
    private static Logger log = LoggerFactory.getLogger(CoordinatesHelper.class);
    private final List<CoordinateAxis> coordAxes = new ArrayList<CoordinateAxis>();
    private final List<CoordinateSystem> coordSystems;
    private final List<CoordinateTransform> coordTransforms;

    public List<CoordinateAxis> getCoordAxes() {
        return this.coordAxes;
    }

    public List<CoordinateSystem> getCoordSystems() {
        return this.coordSystems;
    }

    public Optional<CoordinateSystem> findCoordSystem(String name) {
        return this.coordSystems.stream().filter(cs -> cs.getName().equals(name)).findFirst();
    }

    public List<CoordinateTransform> getCoordTransforms() {
        return this.coordTransforms;
    }

    private CoordinatesHelper(Builder builder, NetcdfDataset ncd) {
        for (Variable v : ncd.getVariables()) {
            if (!(v instanceof CoordinateAxis)) continue;
            this.coordAxes.add((CoordinateAxis)v);
        }
        this.coordTransforms = builder.coordTransforms.stream().map(ct -> ct.build(ncd)).filter(Objects::nonNull).collect(Collectors.toList());
        this.coordTransforms.addAll(builder.verticalCTBuilder.stream().map(ct -> ct.makeVerticalCT(ncd)).filter(Objects::nonNull).collect(Collectors.toList()));
        this.coordSystems = builder.coordSys.stream().map(s2 -> s2.build(ncd, this.coordAxes, this.coordTransforms)).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class AxisComparator
    implements Comparator<CoordinateAxis.Builder> {
        private AxisComparator() {
        }

        @Override
        public int compare(CoordinateAxis.Builder c1, CoordinateAxis.Builder c2) {
            AxisType t1 = c1.axisType;
            AxisType t2 = c2.axisType;
            if (t1 == null && t2 == null) {
                return c1.getFullName().compareTo(c2.getFullName());
            }
            if (t1 == null) {
                return -1;
            }
            if (t2 == null) {
                return 1;
            }
            return t1.axisOrder() - t2.axisOrder();
        }
    }

    public static class Builder {
        public List<CoordinateAxis.Builder> coordAxes = new ArrayList<CoordinateAxis.Builder>();
        public List<CoordinateSystem.Builder> coordSys = new ArrayList<CoordinateSystem.Builder>();
        public List<CoordinateTransform.Builder> coordTransforms = new ArrayList<CoordinateTransform.Builder>();
        public List<VerticalCTBuilder> verticalCTBuilder = new ArrayList<VerticalCTBuilder>();
        private boolean built;

        public Builder addCoordinateAxis(CoordinateAxis.Builder axis) {
            if (axis == null) {
                return this;
            }
            this.coordAxes.add(axis);
            return this;
        }

        public Builder addCoordinateAxes(Collection<CoordinateAxis.Builder> axes) {
            Preconditions.checkNotNull(axes);
            axes.forEach(a -> this.addCoordinateAxis((CoordinateAxis.Builder)a));
            return this;
        }

        public Optional<CoordinateAxis.Builder> findCoordinateAxis(String fullName) {
            return this.coordAxes.stream().filter(axis -> axis.getFullName().equals(fullName)).findFirst();
        }

        public Optional<CoordinateAxis.Builder> findAxisByType(CoordinateSystem.Builder csys, AxisType type) {
            for (CoordinateAxis.Builder<?> axis : this.getAxesForSystem(csys)) {
                if (axis.axisType != type) continue;
                return Optional.of(axis);
            }
            return Optional.empty();
        }

        public boolean replaceCoordinateAxis(CoordinateAxis.Builder<?> axis) {
            Optional<CoordinateAxis.Builder> want = this.findCoordinateAxis(axis.getFullName());
            want.ifPresent(v -> this.coordAxes.remove(v));
            this.addCoordinateAxis(axis);
            return want.isPresent();
        }

        public Builder addCoordinateSystem(CoordinateSystem.Builder cs) {
            Preconditions.checkNotNull(cs);
            this.coordSys.add(cs);
            return this;
        }

        public Builder addVerticalCTBuilder(VerticalCTBuilder vctb) {
            this.verticalCTBuilder.add(vctb);
            return this;
        }

        public Optional<CoordinateSystem.Builder> findCoordinateSystem(String coordAxesNames) {
            Preconditions.checkNotNull(coordAxesNames);
            return this.coordSys.stream().filter(cs -> cs.coordAxesNames.equals(coordAxesNames)).findFirst();
        }

        public Builder addCoordinateSystems(Collection<CoordinateSystem.Builder> systems) {
            Preconditions.checkNotNull(systems);
            this.coordSys.addAll(systems);
            return this;
        }

        public Builder addCoordinateTransform(CoordinateTransform.Builder ct) {
            Preconditions.checkNotNull(ct);
            if (!this.findCoordinateTransform(ct.name).isPresent()) {
                this.coordTransforms.add(ct);
            }
            return this;
        }

        public Builder addCoordinateTransforms(Collection<CoordinateTransform.Builder> transforms) {
            Preconditions.checkNotNull(transforms);
            transforms.forEach(ct -> this.addCoordinateTransform((CoordinateTransform.Builder)ct));
            return this;
        }

        private Optional<CoordinateTransform.Builder> findCoordinateTransform(String ctName) {
            Preconditions.checkNotNull(ctName);
            return this.coordTransforms.stream().filter(ct -> ct.name.equals(ctName)).findFirst();
        }

        public List<CoordinateAxis.Builder<?>> getAxesForSystem(CoordinateSystem.Builder cs) {
            Preconditions.checkNotNull(cs);
            ArrayList axes = new ArrayList();
            StringTokenizer stoker = new StringTokenizer(cs.coordAxesNames);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                Optional<CoordinateAxis.Builder> vbOpt = this.findCoordinateAxis(vname);
                if (vbOpt.isPresent()) {
                    axes.add(vbOpt.get());
                    continue;
                }
                this.findCoordinateAxis(vname);
                throw new IllegalArgumentException("Cant find axis " + vname);
            }
            return axes;
        }

        public String makeCanonicalName(String axesNames) {
            Preconditions.checkNotNull(axesNames);
            ArrayList<CoordinateAxis.Builder> axes = new ArrayList<CoordinateAxis.Builder>();
            StringTokenizer stoker = new StringTokenizer(axesNames);
            while (stoker.hasMoreTokens()) {
                String vname = stoker.nextToken();
                Optional<CoordinateAxis.Builder> vbOpt = this.findCoordinateAxis(vname);
                if (vbOpt.isPresent()) {
                    axes.add(vbOpt.get());
                    continue;
                }
                log.warn("No axis named {}", (Object)vname);
            }
            return this.makeCanonicalName(axes);
        }

        public String makeCanonicalName(List<CoordinateAxis.Builder> axes) {
            Preconditions.checkNotNull(axes);
            return axes.stream().sorted(new AxisComparator()).map(a -> a.getFullName()).collect(Collectors.joining(" "));
        }

        public CoordinatesHelper build(NetcdfDataset ncd) {
            Preconditions.checkNotNull(ncd);
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new CoordinatesHelper(this, ncd);
        }

        public boolean isComplete(CoordinateSystem.Builder<?> cs, VariableDS.Builder<?> vb) {
            Preconditions.checkNotNull(cs);
            Preconditions.checkNotNull(vb);
            ImmutableSet<String> varDomain = ImmutableSet.copyOf(vb.getDimensionNames().iterator());
            HashSet<String> csDomain = new HashSet<String>();
            this.getAxesForSystem(cs).forEach(axis -> axis.getDimensionNames().forEach(csDomain::add));
            return CoordinateSystem.isSubset(varDomain, csDomain);
        }

        public boolean containsAxes(CoordinateSystem.Builder cs, List<CoordinateAxis.Builder> dataAxes) {
            Preconditions.checkNotNull(cs);
            Preconditions.checkNotNull(dataAxes);
            List<CoordinateAxis.Builder<CoordinateAxis.Builder>> csAxes = this.getAxesForSystem(cs);
            return csAxes.containsAll(dataAxes);
        }

        public boolean containsAxisTypes(CoordinateSystem.Builder cs, List<AxisType> axisTypes) {
            Preconditions.checkNotNull(cs);
            Preconditions.checkNotNull(axisTypes);
            List<CoordinateAxis.Builder<?>> csAxes = this.getAxesForSystem(cs);
            for (AxisType axisType : axisTypes) {
                if (this.containsAxisTypes(csAxes, axisType)) continue;
                return false;
            }
            return true;
        }

        private boolean containsAxisTypes(List<CoordinateAxis.Builder<?>> axes, AxisType want) {
            for (CoordinateAxis.Builder<?> axis : axes) {
                if (axis.axisType != want) continue;
                return true;
            }
            return false;
        }
    }
}

