/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.gui.GenericDialog;
import java.awt.Container;
import loci.plugins.in.ImportProcess;
import loci.plugins.in.ImporterDialog;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.WindowTools;

public class RangeDialog
extends ImporterDialog {
    public RangeDialog(ImportProcess process) {
        super(process);
    }

    @Override
    protected boolean needPrompt() {
        if (this.process.isWindowless() || !this.options.isSpecifyRanges()) {
            return false;
        }
        ImageProcessorReader r = this.process.getReader();
        int seriesCount = this.process.getSeriesCount();
        int currentSeries = r.getSeries();
        for (int s2 = 0; s2 < seriesCount; ++s2) {
            r.setSeries(s2);
            if (!this.options.isSeriesOn(s2) || r.getImageCount() <= 1) continue;
            r.setSeries(currentSeries);
            return true;
        }
        r.setSeries(currentSeries);
        return false;
    }

    @Override
    protected GenericDialog constructDialog() {
        ImageProcessorReader r = this.process.getReader();
        int seriesCount = this.process.getSeriesCount();
        GenericDialog gd = new GenericDialog("Bio-Formats Range Options");
        for (int s2 = 0; s2 < seriesCount; ++s2) {
            String suffix;
            if (!this.options.isSeriesOn(s2)) continue;
            r.setSeries(s2);
            gd.addMessage(this.process.getSeriesLabel(s2).replaceAll("_", " "));
            String string = suffix = seriesCount > 1 ? "_" + (s2 + 1) : "";
            if (r.getEffectiveSizeC() > 1) {
                gd.addNumericField("C_Begin" + suffix, (double)(this.process.getCBegin(s2) + 1), 0);
                gd.addNumericField("C_End" + suffix, (double)(this.process.getCEnd(s2) + 1), 0);
                gd.addNumericField("C_Step" + suffix, (double)this.process.getCStep(s2), 0);
            }
            if (r.getSizeZ() > 1) {
                gd.addNumericField("Z_Begin" + suffix, (double)(this.process.getZBegin(s2) + 1), 0);
                gd.addNumericField("Z_End" + suffix, (double)(this.process.getZEnd(s2) + 1), 0);
                gd.addNumericField("Z_Step" + suffix, (double)this.process.getZStep(s2), 0);
            }
            if (r.getSizeT() <= 1) continue;
            gd.addNumericField("T_Begin" + suffix, (double)(this.process.getTBegin(s2) + 1), 0);
            gd.addNumericField("T_End" + suffix, (double)(this.process.getTEnd(s2) + 1), 0);
            gd.addNumericField("T_Step" + suffix, (double)this.process.getTStep(s2), 0);
        }
        WindowTools.addScrollBars((Container)gd);
        return gd;
    }

    @Override
    protected boolean harvestResults(GenericDialog gd) {
        ImageProcessorReader r = this.process.getReader();
        int seriesCount = this.process.getSeriesCount();
        for (int s2 = 0; s2 < seriesCount; ++s2) {
            int maxC;
            if (!this.options.isSeriesOn(s2)) continue;
            r.setSeries(s2);
            int sizeC = r.getEffectiveSizeC();
            int sizeZ = r.getSizeZ();
            int sizeT = r.getSizeT();
            boolean certain = r.isOrderCertain();
            int cBegin = this.process.getCBegin(s2);
            int cEnd = this.process.getCEnd(s2);
            int cStep = this.process.getCStep(s2);
            int zBegin = this.process.getZBegin(s2);
            int zEnd = this.process.getZEnd(s2);
            int zStep = this.process.getZStep(s2);
            int tBegin = this.process.getTBegin(s2);
            int tEnd = this.process.getTEnd(s2);
            int tStep = this.process.getTStep(s2);
            if (r.getEffectiveSizeC() > 1) {
                cBegin = (int)gd.getNextNumber() - 1;
                cEnd = (int)gd.getNextNumber() - 1;
                cStep = (int)gd.getNextNumber();
            }
            if (r.getSizeZ() > 1) {
                zBegin = (int)gd.getNextNumber() - 1;
                zEnd = (int)gd.getNextNumber() - 1;
                zStep = (int)gd.getNextNumber();
            }
            if (r.getSizeT() > 1) {
                tBegin = (int)gd.getNextNumber() - 1;
                tEnd = (int)gd.getNextNumber() - 1;
                tStep = (int)gd.getNextNumber();
            }
            int n = maxC = certain ? sizeC : r.getImageCount();
            if (cBegin < 0) {
                cBegin = 0;
            }
            if (cBegin >= maxC) {
                cBegin = maxC - 1;
            }
            if (cEnd < cBegin) {
                cEnd = cBegin;
            }
            if (cEnd >= maxC) {
                cEnd = maxC - 1;
            }
            if (cStep < 1) {
                cStep = 1;
            }
            if (zBegin < 0) {
                zBegin = 0;
            }
            if (zBegin >= sizeZ) {
                zBegin = sizeZ - 1;
            }
            if (zEnd < zBegin) {
                zEnd = zBegin;
            }
            if (zEnd >= sizeZ) {
                zEnd = sizeZ - 1;
            }
            if (zStep < 1) {
                zStep = 1;
            }
            if (tBegin < 0) {
                tBegin = 0;
            }
            if (tBegin >= sizeT) {
                tBegin = sizeT - 1;
            }
            if (tEnd < tBegin) {
                tEnd = tBegin;
            }
            if (tEnd >= sizeT) {
                tEnd = sizeT - 1;
            }
            if (tStep < 1) {
                tStep = 1;
            }
            this.options.setCBegin(s2, cBegin);
            this.options.setCEnd(s2, cEnd);
            this.options.setCStep(s2, cStep);
            this.options.setZBegin(s2, zBegin);
            this.options.setZEnd(s2, zEnd);
            this.options.setZStep(s2, zStep);
            this.options.setTBegin(s2, tBegin);
            this.options.setTEnd(s2, tEnd);
            this.options.setTStep(s2, tStep);
        }
        return true;
    }
}

