/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;

public class ImarisReader
extends FormatReader {
    private static final int IMARIS_MAGIC_BYTES = 5021964;
    private static final boolean IS_LITTLE = false;
    private int[] offsets;

    public ImarisReader() {
        super("Bitplane Imaris", "ims");
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)4, (boolean)false)) {
            return false;
        }
        return stream.readInt() == 5021964;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek((long)(this.offsets[no] + this.getSizeX() * (this.getSizeY() - y - h)));
        for (int row = h - 1; row >= 0; --row) {
            this.in.skipBytes(x);
            this.in.read(buf, row * w, w);
            this.in.skipBytes(this.getSizeX() - w - x);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.offsets = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Verifying Imaris RAW format");
        this.in.order(false);
        long magic = this.in.readInt();
        if (magic != 5021964L) {
            throw new FormatException("Imaris magic number not found.");
        }
        LOGGER.info("Reading header");
        int version = this.in.readInt();
        this.in.skipBytes(4);
        String imageName = this.in.readString(128);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.sizeX = this.in.readShort();
        m.sizeY = this.in.readShort();
        m.sizeZ = this.in.readShort();
        this.in.skipBytes(2);
        m.sizeC = this.in.readInt();
        this.in.skipBytes(2);
        String date = this.in.readString(32);
        float dx = this.in.readFloat();
        float dy = this.in.readFloat();
        float dz = this.in.readFloat();
        short mag = this.in.readShort();
        String description = this.in.readString(128);
        int isSurvey = this.in.readInt();
        LOGGER.info("Calculating image offsets");
        m.imageCount = this.getSizeZ() * this.getSizeC();
        this.offsets = new int[this.getImageCount()];
        float[] gains = new float[this.getSizeC()];
        float[] detectorOffsets = new float[this.getSizeC()];
        float[] pinholes = new float[this.getSizeC()];
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            for (int i = 0; i < this.getSizeC(); ++i) {
                this.addGlobalMeta("Channel #" + i + " Comment", this.in.readString(128));
                gains[i] = this.in.readFloat();
                detectorOffsets[i] = this.in.readFloat();
                pinholes[i] = this.in.readFloat();
                this.in.skipBytes(24);
            }
        }
        int offset = 336 + 164 * this.getSizeC();
        for (int i = 0; i < this.getSizeC(); ++i) {
            for (int j = 0; j < this.getSizeZ(); ++j) {
                this.offsets[i * this.getSizeZ() + j] = offset + j * this.getSizeX() * this.getSizeY();
            }
            offset += this.getSizeX() * this.getSizeY() * this.getSizeZ();
        }
        this.addGlobalMeta("Version", version);
        this.addGlobalMeta("Image name", imageName);
        this.addGlobalMeta("Image comment", description);
        this.addGlobalMeta("Survey performed", isSurvey == 0);
        this.addGlobalMeta("Original date", date);
        LOGGER.info("Populating metadata");
        m.sizeT = this.getImageCount() / (this.getSizeC() * this.getSizeZ());
        m.dimensionOrder = "XYZCT";
        m.rgb = false;
        m.interleaved = false;
        m.littleEndian = false;
        m.indexed = false;
        m.falseColor = false;
        m.metadataComplete = true;
        m.pixelType = 1;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        store.setImageName(imageName, 0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            store.setImageDescription(description, 0);
            String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            Length sizeX = FormatTools.getPhysicalSizeX((Double)Double.valueOf(dx));
            Length sizeY = FormatTools.getPhysicalSizeY((Double)Double.valueOf(dy));
            Length sizeZ = FormatTools.getPhysicalSizeZ((Double)Double.valueOf(dz));
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
            store.setPixelsTimeIncrement(new Time((Number)1.0, UNITS.SECOND), 0);
            for (i = 0; i < this.getSizeC(); ++i) {
                if (!(pinholes[i] > 0.0f)) continue;
                store.setChannelPinholeSize(new Length((Number)Float.valueOf(pinholes[i]), UNITS.MICROMETER), 0, i);
            }
            for (i = 0; i < this.getSizeC(); ++i) {
                if (gains[i] > 0.0f) {
                    store.setDetectorSettingsGain(Double.valueOf(gains[i]), 0, i);
                }
                store.setDetectorSettingsOffset(Double.valueOf(this.offsets[i]), i, 0);
                String detectorID = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, i});
                store.setDetectorID(detectorID, 0, i);
                store.setDetectorType(MetadataTools.getDetectorType((String)"Other"), 0, i);
                store.setDetectorSettingsID(detectorID, 0, i);
            }
        }
    }
}

