/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import java.nio.ByteBuffer;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteByteBufferTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testWriteSequential() throws IOException {
        int i;
        for (i = 0; i < 16; ++i) {
            ByteBuffer b = ByteBuffer.allocate(1).put((byte)(i + 1));
            this.fileHandle.write(b);
            if (!this.checkGrowth) continue;
            AssertJUnit.assertEquals((long)(i + 1), (long)this.fileHandle.length());
        }
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        this.fileHandle.seek(0L);
        for (i = 0; i < 16; ++i) {
            AssertJUnit.assertEquals((int)(i + 1), (int)this.fileHandle.readByte());
        }
    }

    @Test
    public void testWrite() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(1).put((byte)1);
        this.fileHandle.write(b);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.length());
        }
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.getFilePointer());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteSequentialSubBuffer() throws IOException {
        int i;
        for (i = 0; i < 16; ++i) {
            ByteBuffer b = ByteBuffer.allocate(2);
            b.put((byte)0);
            b.put((byte)(i + 1));
            this.fileHandle.write(b, 1, 1);
            if (!this.checkGrowth) continue;
            AssertJUnit.assertEquals((long)(i + 1), (long)this.fileHandle.length());
        }
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        this.fileHandle.seek(0L);
        for (i = 0; i < 16; ++i) {
            AssertJUnit.assertEquals((int)(i + 1), (int)this.fileHandle.readByte());
        }
    }

    @Test
    public void testWriteSubBuffer() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(2);
        b.put((byte)0);
        b.put((byte)1);
        this.fileHandle.write(b, 1, 1);
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.getFilePointer());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteTwoByteSubBuffer() throws IOException {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.put((byte)1);
        b.put((byte)2);
        b.put((byte)3);
        b.put((byte)4);
        this.fileHandle.write(b, 1, 2);
        AssertJUnit.assertEquals((long)2L, (long)this.fileHandle.getFilePointer());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)2, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readByte());
        if (this.fileHandle.length() > 2L && this.fileHandle.readByte() == 4) {
            AssertJUnit.fail((String)"Incorrect length or trailing bytes.");
        }
    }
}

