/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadLongTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 15, -1, -1, -1, -1, -1, -1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 15, -1, -1, -1, -1, -1, -1, 4, 0, 0, 0, 0, 0, 0, 0, 5, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 7, -1, -1, -1, -1, -1, -1, -1, -2};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)64L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequentialReadLong() throws IOException {
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)3L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF04L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)5L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)-1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)7L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)-2L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testSeekForwardReadLong() throws IOException {
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)3L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testResetReadLong() throws IOException {
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testSeekBackReadLong() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((long)0xFFFFFFFFFFFFF02L, (long)this.fileHandle.readLong());
        AssertJUnit.assertEquals((long)3L, (long)this.fileHandle.readLong());
    }

    @Test
    public void testRandomAccessReadLong() throws IOException {
        this.testSeekForwardReadLong();
        this.testSeekBackReadLong();
        this.fileHandle.seek(0L);
        this.testResetReadLong();
    }
}

