/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.JPEG2000Writer;
import loci.formats.services.OMEXMLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class SixteenBitLosslessJPEG2000Test {
    private static final Logger LOGGER = LoggerFactory.getLogger(SixteenBitLosslessJPEG2000Test.class);
    private final int increment;

    public SixteenBitLosslessJPEG2000Test() {
        this(1024);
    }

    public SixteenBitLosslessJPEG2000Test(int increment) {
        this.increment = increment;
    }

    @Test
    public void testLosslessPixels() throws Exception {
        int failureCount = 0;
        for (int v = Short.MIN_VALUE; v < Short.MAX_VALUE; v += this.increment) {
            OMEXMLMetadata metadata16;
            int index = v + Short.MAX_VALUE + 1;
            byte[] pixels = DataTools.shortToBytes((short)((short)v), (boolean)false);
            String file = index + ".jp2";
            ByteArrayHandle tmpFile = new ByteArrayHandle(1);
            Location.mapFile((String)file, (IRandomAccess)tmpFile);
            try {
                ServiceFactory factory = new ServiceFactory();
                OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
                metadata16 = service.createOMEXMLMetadata();
            }
            catch (DependencyException exc) {
                throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
            }
            catch (ServiceException exc) {
                throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
            }
            MetadataTools.populateMetadata((MetadataStore)metadata16, (int)0, (String)"foo", (boolean)false, (String)"XYCZT", (String)"uint16", (int)1, (int)1, (int)1, (int)1, (int)1, (int)1);
            JPEG2000Writer writer16 = new JPEG2000Writer();
            writer16.setMetadataRetrieve((MetadataRetrieve)metadata16);
            writer16.setId(file);
            writer16.saveBytes(0, pixels);
            writer16.close();
            byte[] buf = tmpFile.getBytes();
            byte[] realData = new byte[(int)tmpFile.length()];
            System.arraycopy(buf, 0, realData, 0, realData.length);
            tmpFile.close();
            tmpFile = new ByteArrayHandle(realData);
            Location.mapFile((String)file, (IRandomAccess)tmpFile);
            ImageReader reader = new ImageReader();
            reader.setId(file);
            byte[] plane = reader.openBytes(0);
            for (int q = 0; q < plane.length; ++q) {
                if (plane[q] == pixels[q]) continue;
                LOGGER.debug("FAILED on {}", (Object)DataTools.bytesToShort((byte[])pixels, (boolean)false));
                ++failureCount;
                break;
            }
            reader.close();
            tmpFile.close();
            Location.mapFile((String)file, null);
        }
        AssertJUnit.assertEquals((int)failureCount, (int)0);
    }
}

