/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class FujiReader
extends FormatReader {
    private static final String DATE_FORMAT = "ddd MMM dd HH:mm:ss yyyy";
    private String infFile;
    private String pixelsFile;

    public FujiReader() {
        super("Fuji LAS 3000", new String[]{"img", "inf"});
        this.domains = new String[]{"Gel/Blot Imaging"};
        this.hasCompanionFiles = true;
    }

    public boolean isThisType(String name, boolean open) {
        if (!super.isThisType(name, open)) {
            return false;
        }
        if (!open) {
            return false;
        }
        String baseName = name.substring(0, name.lastIndexOf("."));
        if (FujiReader.checkSuffix((String)name, (String)"inf")) {
            return new Location(baseName + ".img").exists();
        }
        if (FujiReader.checkSuffix((String)name, (String)"img")) {
            return new Location(baseName + ".inf").exists();
        }
        return false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return false;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        try (RandomAccessInputStream s = new RandomAccessInputStream(this.pixelsFile);){
            this.readPlane(s, x, y, w, h, buf);
        }
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (noPixels) {
            return new String[]{this.infFile};
        }
        return new String[]{this.infFile, this.pixelsFile};
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.infFile = null;
            this.pixelsFile = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!FujiReader.checkSuffix((String)id, (String)"inf")) {
            this.initFile(id.substring(0, id.lastIndexOf(".")) + ".inf");
            return;
        }
        super.initFile(id);
        this.infFile = new Location(id).getAbsolutePath();
        this.pixelsFile = this.infFile.substring(0, this.infFile.lastIndexOf(".")) + ".img";
        String[] lines = DataTools.readFile((String)this.infFile).split("\r{0,1}\n");
        int bits = Integer.parseInt(lines[5]);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.pixelType = FormatTools.pixelTypeFromBytes((int)(bits / 8), (boolean)false, (boolean)false);
        m.sizeX = Integer.parseInt(lines[6]);
        m.sizeY = Integer.parseInt(lines[7]);
        m.sizeC = 1;
        m.sizeT = 1;
        m.sizeZ = 1;
        m.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        m.dimensionOrder = "XYCZT";
        for (String line : lines) {
            this.addGlobalMetaList("Line", line);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        String imageName = lines[1];
        String timestamp = lines[10];
        timestamp = DateTools.formatDate((String)timestamp, (String)DATE_FORMAT);
        store.setImageName(imageName, 0);
        if (timestamp != null) {
            store.setImageAcquisitionDate(new Timestamp(timestamp), 0);
        }
        double physicalWidth = Double.parseDouble(lines[3]);
        double physicalHeight = Double.parseDouble(lines[4]);
        Length sizeX = FormatTools.getPhysicalSizeX((Double)physicalWidth);
        Length sizeY = FormatTools.getPhysicalSizeY((Double)physicalHeight);
        if (sizeX != null) {
            store.setPixelsPhysicalSizeX(sizeX, 0);
        }
        if (sizeY != null) {
            store.setPixelsPhysicalSizeY(sizeY, 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String instrument = lines[13];
            String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
            store.setInstrumentID(instrumentID, 0);
            store.setMicroscopeModel(instrument, 0);
        }
    }
}

