/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.in.SVSReader;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MikroscanTiffReader
extends SVSReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MikroscanTiffReader.class);
    private static final String MIKROSCAN_IMAGE_DESCRIPTION_PREFIX = "Mikroscan Image";

    public MikroscanTiffReader() {
        super("Mikroscan TIFF", new String[]{"tif", "tiff"});
        this.domains = new String[]{"Histology", "Light Microscopy"};
        this.suffixNecessary = false;
        this.suffixSufficient = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType) return isThisType;
        if (!open) return isThisType;
        try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
            TiffParser tiffParser = new TiffParser(stream);
            tiffParser.setDoCaching(false);
            if (!tiffParser.isValidHeader()) {
                boolean bl = false;
                return bl;
            }
            IFD ifd = tiffParser.getFirstIFD();
            if (ifd == null) {
                boolean bl = false;
                return bl;
            }
            Object description = ifd.get((Object)270);
            if (description != null) {
                String imageDescription = null;
                if (description instanceof TiffIFDEntry) {
                    Object value = tiffParser.getIFDValue((TiffIFDEntry)description);
                    if (value != null) {
                        imageDescription = value.toString();
                    }
                } else if (description instanceof String) {
                    imageDescription = (String)description;
                }
                if (imageDescription != null && imageDescription.startsWith(MIKROSCAN_IMAGE_DESCRIPTION_PREFIX)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", (Throwable)e);
            return false;
        }
    }
}

