/*
 * Decompiled with CFR 0.152.
 */
package loci.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.ImageReader;

public class ZipTester {
    private static ImageReader reader = new ImageReader();

    public static void main(String[] args) throws IOException, FormatException, InterruptedException {
        int r;
        File tmp;
        File out;
        File in;
        if (args.length < 2) {
            System.out.println("Usage: java loci.tests.ZipTester /path/to/input-file /path/to/output-folder");
            System.exit(1);
        }
        if (!(in = new File(args[0])).exists()) {
            System.out.println("Input file '" + in + "' does not exist.");
            System.exit(2);
        }
        if (!(out = new File(args[1])).isDirectory()) {
            System.out.println("Output folder '" + out + "' is not a directory.");
            System.exit(3);
        }
        if (!(tmp = new File(out, "ZipTester.tmp")).exists()) {
            tmp.mkdir();
        }
        String name = in.getName();
        String id = new File(tmp, name).getPath();
        System.out.println("cp '" + in.getPath() + "' '" + id + "'");
        FileInputStream fin = new FileInputStream(in);
        FileOutputStream fout = new FileOutputStream(id);
        byte[] buf = new byte[8192];
        while ((r = fin.read(buf)) > 0) {
            fout.write(buf, 0, r);
        }
        fout.close();
        fin.close();
        ZipTester.time(id);
        Runtime r2 = Runtime.getRuntime();
        String zip = id + ".zip";
        String[] cmd = new String[]{"zip", zip, id};
        System.out.println("zip '" + zip + "' '" + id + "'");
        r2.exec(cmd).waitFor();
        ZipTester.time(zip);
        String bz2 = id + ".bz2";
        cmd = new String[]{"bzip2", "-k", id};
        System.out.println("bzip2 -k '" + id + "'");
        r2.exec(cmd).waitFor();
        ZipTester.time(bz2);
        String gz = id + ".gz";
        cmd = new String[]{"gzip", id};
        System.out.println("gzip '" + id + "'");
        r2.exec(cmd).waitFor();
        ZipTester.time(gz);
        new File(zip).delete();
        new File(bz2).delete();
        new File(gz).delete();
        tmp.delete();
    }

    public static void time(String id) throws IOException, FormatException {
        System.out.print("Timing " + new File(id).getName() + ": ");
        long t1 = System.currentTimeMillis();
        boolean result = reader.isThisType(id);
        long t2 = System.currentTimeMillis();
        System.out.print(t2 - t1 + " ms to check type (" + result + "); ");
        long t3 = System.currentTimeMillis();
        reader.setId(id);
        long t4 = System.currentTimeMillis();
        System.out.println(t4 - t3 + " ms to initialize");
        reader.close();
    }
}

