/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.cleanup;

import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import java.util.ArrayList;
import java.util.List;

public class CleanUpRegistry
implements ICleanUpRegistry {
    private final List<Runnable> cleanUpList = new ArrayList<Runnable>();

    public static CleanUpRegistry createSynchonized() {
        return new CleanUpRegistry(){

            @Override
            public synchronized void registerCleanUp(Runnable cleanUp) {
                super.registerCleanUp(cleanUp);
            }

            @Override
            public synchronized void cleanUp(boolean suppressExceptions) {
                super.cleanUp(suppressExceptions);
            }
        };
    }

    @Override
    public void registerCleanUp(Runnable cleanUp) {
        this.cleanUpList.add(cleanUp);
    }

    public void cleanUp(boolean suppressExceptions) {
        RuntimeException exceptionDuringCleanUp = null;
        int i = this.cleanUpList.size() - 1;
        while (i >= 0) {
            block4: {
                Runnable runnable = this.cleanUpList.get(i);
                try {
                    runnable.run();
                }
                catch (RuntimeException ex) {
                    if (suppressExceptions || exceptionDuringCleanUp != null) break block4;
                    exceptionDuringCleanUp = ex;
                }
            }
            --i;
        }
        this.cleanUpList.clear();
        if (exceptionDuringCleanUp != null) {
            throw exceptionDuringCleanUp;
        }
    }
}

