/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.units.quantity.Length;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.Screen;
import ome.xml.model.Well;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.UnitsLength;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Plate
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Plate.class);
    private String id;
    private String name;
    private String status;
    private String externalIdentifier;
    private NamingConvention columnNamingConvention;
    private NamingConvention rowNamingConvention;
    private Length wellOriginX;
    private Length wellOriginY;
    private PositiveInteger rows;
    private PositiveInteger columns;
    private NonNegativeInteger fieldIndex;
    private String description;
    private List<Well> wells = new ArrayList<Well>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private List<PlateAcquisition> plateAcquisitions = new ArrayList<PlateAcquisition>();
    private List<Screen> screenLinks = new ReferenceList<Screen>();

    public Plate() {
    }

    public Plate(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Plate(Plate orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.status = orig.status;
        this.externalIdentifier = orig.externalIdentifier;
        this.columnNamingConvention = orig.columnNamingConvention;
        this.rowNamingConvention = orig.rowNamingConvention;
        this.wellOriginX = orig.wellOriginX;
        this.wellOriginY = orig.wellOriginY;
        this.rows = orig.rows;
        this.columns = orig.columns;
        this.fieldIndex = orig.fieldIndex;
        this.description = orig.description;
        this.wells = orig.wells;
        this.annotationLinks = orig.annotationLinks;
        this.plateAcquisitions = orig.plateAcquisitions;
        this.screenLinks = orig.screenLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Description_nodeList;
        Object baseValue;
        UnitsLength modelUnit;
        String unitSymbol;
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("Plate missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if (element.hasAttribute("Status")) {
            this.setStatus(String.valueOf(element.getAttribute("Status")));
        }
        if (element.hasAttribute("ExternalIdentifier")) {
            this.setExternalIdentifier(String.valueOf(element.getAttribute("ExternalIdentifier")));
        }
        if (element.hasAttribute("ColumnNamingConvention")) {
            this.setColumnNamingConvention(NamingConvention.fromString(element.getAttribute("ColumnNamingConvention")));
        }
        if (element.hasAttribute("RowNamingConvention")) {
            this.setRowNamingConvention(NamingConvention.fromString(element.getAttribute("RowNamingConvention")));
        }
        if (element.hasAttribute("WellOriginX")) {
            unitSymbol = element.getAttribute("WellOriginXUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Plate.getWellOriginXUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("WellOriginX"));
            this.setWellOriginX(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
        }
        if (element.hasAttribute("WellOriginY")) {
            unitSymbol = element.getAttribute("WellOriginYUnit");
            if (unitSymbol == null || unitSymbol.isEmpty()) {
                unitSymbol = Plate.getWellOriginYUnitXsdDefault();
            }
            modelUnit = UnitsLength.fromString(unitSymbol);
            baseValue = Double.valueOf(element.getAttribute("WellOriginY"));
            this.setWellOriginY(UnitsLengthEnumHandler.getQuantity(baseValue, modelUnit));
        }
        if (element.hasAttribute("Rows")) {
            this.setRows(PositiveInteger.valueOf(element.getAttribute("Rows")));
        }
        if (element.hasAttribute("Columns")) {
            this.setColumns(PositiveInteger.valueOf(element.getAttribute("Columns")));
        }
        if (element.hasAttribute("FieldIndex")) {
            this.setFieldIndex(NonNegativeInteger.valueOf(element.getAttribute("FieldIndex")));
        }
        if ((Description_nodeList = Plate.getChildrenByTagName(element, "Description")).size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> Well_nodeList = Plate.getChildrenByTagName(element, "Well");
        for (Element element2 : Well_nodeList) {
            this.addWell(new Well(element2, model));
        }
        List<Element> AnnotationRef_nodeList = Plate.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
        List<Element> list = Plate.getChildrenByTagName(element, "PlateAcquisition");
        for (Element PlateAcquisition_element : list) {
            this.addPlateAcquisition(new PlateAcquisition(PlateAcquisition_element, model));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkPlate(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public NamingConvention getColumnNamingConvention() {
        return this.columnNamingConvention;
    }

    public void setColumnNamingConvention(NamingConvention columnNamingConvention) {
        this.columnNamingConvention = columnNamingConvention;
    }

    public NamingConvention getRowNamingConvention() {
        return this.rowNamingConvention;
    }

    public void setRowNamingConvention(NamingConvention rowNamingConvention) {
        this.rowNamingConvention = rowNamingConvention;
    }

    public Length getWellOriginX() {
        return this.wellOriginX;
    }

    public void setWellOriginX(Length wellOriginX) {
        this.wellOriginX = wellOriginX;
    }

    public static String getWellOriginXUnitXsdDefault() {
        return "reference frame";
    }

    public Length getWellOriginY() {
        return this.wellOriginY;
    }

    public void setWellOriginY(Length wellOriginY) {
        this.wellOriginY = wellOriginY;
    }

    public static String getWellOriginYUnitXsdDefault() {
        return "reference frame";
    }

    public PositiveInteger getRows() {
        return this.rows;
    }

    public void setRows(PositiveInteger rows) {
        this.rows = rows;
    }

    public PositiveInteger getColumns() {
        return this.columns;
    }

    public void setColumns(PositiveInteger columns) {
        this.columns = columns;
    }

    public NonNegativeInteger getFieldIndex() {
        return this.fieldIndex;
    }

    public void setFieldIndex(NonNegativeInteger fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int sizeOfWellList() {
        return this.wells.size();
    }

    public List<Well> copyWellList() {
        return new ArrayList<Well>(this.wells);
    }

    public void clearWellList() {
        this.wells.clear();
    }

    public Well getWell(int index) {
        return this.wells.get(index);
    }

    public Well setWell(int index, Well well) {
        well.setPlate(this);
        return this.wells.set(index, well);
    }

    public void addWell(Well well) {
        well.setPlate(this);
        this.wells.add(well);
    }

    public void removeWell(Well well) {
        this.wells.remove(well);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkPlate(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkPlate(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfPlateAcquisitionList() {
        return this.plateAcquisitions.size();
    }

    public List<PlateAcquisition> copyPlateAcquisitionList() {
        return new ArrayList<PlateAcquisition>(this.plateAcquisitions);
    }

    public void clearPlateAcquisitionList() {
        this.plateAcquisitions.clear();
    }

    public PlateAcquisition getPlateAcquisition(int index) {
        return this.plateAcquisitions.get(index);
    }

    public PlateAcquisition setPlateAcquisition(int index, PlateAcquisition plateAcquisition) {
        plateAcquisition.setPlate(this);
        return this.plateAcquisitions.set(index, plateAcquisition);
    }

    public void addPlateAcquisition(PlateAcquisition plateAcquisition) {
        plateAcquisition.setPlate(this);
        this.plateAcquisitions.add(plateAcquisition);
    }

    public void removePlateAcquisition(PlateAcquisition plateAcquisition) {
        this.plateAcquisitions.remove(plateAcquisition);
    }

    public int sizeOfLinkedScreenList() {
        return this.screenLinks.size();
    }

    public List<Screen> copyLinkedScreenList() {
        return new ArrayList<Screen>(this.screenLinks);
    }

    public Screen getLinkedScreen(int index) {
        return this.screenLinks.get(index);
    }

    public Screen setLinkedScreen(int index, Screen o) {
        return this.screenLinks.set(index, o);
    }

    public boolean linkScreen(Screen o) {
        return this.screenLinks.add(o);
    }

    public boolean unlinkScreen(Screen o) {
        return this.screenLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Plate_element) {
        Element child;
        UnitsLength enumUnits;
        if (Plate_element == null) {
            Plate_element = document.createElementNS(NAMESPACE, "Plate");
        }
        super.asXMLElement(document, Plate_element);
        if (this.id != null) {
            Plate_element.setAttribute("ID", this.id);
        }
        if (this.name != null) {
            Plate_element.setAttribute("Name", this.name);
        }
        if (this.status != null) {
            Plate_element.setAttribute("Status", this.status);
        }
        if (this.externalIdentifier != null) {
            Plate_element.setAttribute("ExternalIdentifier", this.externalIdentifier);
        }
        if (this.columnNamingConvention != null) {
            Plate_element.setAttribute("ColumnNamingConvention", this.columnNamingConvention.toString());
        }
        if (this.rowNamingConvention != null) {
            Plate_element.setAttribute("RowNamingConvention", this.rowNamingConvention.toString());
        }
        if (this.wellOriginX != null) {
            if (this.wellOriginX.value() != null) {
                Plate_element.setAttribute("WellOriginX", this.wellOriginX.value().toString());
            }
            if (this.wellOriginX.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.wellOriginX.unit().getSymbol());
                    Plate_element.setAttribute("WellOriginXUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Plate:WellOriginXUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.wellOriginY != null) {
            if (this.wellOriginY.value() != null) {
                Plate_element.setAttribute("WellOriginY", this.wellOriginY.value().toString());
            }
            if (this.wellOriginY.unit() != null) {
                try {
                    enumUnits = UnitsLength.fromString(this.wellOriginY.unit().getSymbol());
                    Plate_element.setAttribute("WellOriginYUnit", enumUnits.toString());
                }
                catch (EnumerationException e) {
                    LOGGER.debug("Unable to create xml for Plate:WellOriginYUnit: {}", (Object)e.toString());
                }
            }
        }
        if (this.rows != null) {
            Plate_element.setAttribute("Rows", this.rows.toString());
        }
        if (this.columns != null) {
            Plate_element.setAttribute("Columns", this.columns.toString());
        }
        if (this.fieldIndex != null) {
            Plate_element.setAttribute("FieldIndex", this.fieldIndex.toString());
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description);
            Plate_element.appendChild(description_element);
        }
        if (this.wells != null) {
            for (Well wells_value : this.wells) {
                child = document.createElementNS(NAMESPACE, "Well");
                wells_value.asXMLElement(document, child);
                Plate_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child2 = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child2);
                Plate_element.appendChild(child2);
            }
        }
        if (this.plateAcquisitions != null) {
            for (PlateAcquisition plateAcquisitions_value : this.plateAcquisitions) {
                child = document.createElementNS(NAMESPACE, "PlateAcquisition");
                plateAcquisitions_value.asXMLElement(document, child);
                Plate_element.appendChild(child);
            }
        }
        return Plate_element;
    }
}

