/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import java.io.Flushable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.chart.GoogleChartGenerator;
import org.perf4j.chart.StatisticsChartGenerator;
import org.perf4j.helpers.MiscUtils;
import org.perf4j.helpers.StatsValueRetriever;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphingStatisticsAppender
extends AppenderBase<LoggingEvent>
implements AppenderAttachable<LoggingEvent>,
Flushable {
    protected static final Map<String, GraphingStatisticsAppender> APPENDERS_BY_NAME = Collections.synchronizedMap(new LinkedHashMap());
    private String graphType = StatsValueRetriever.MEAN_VALUE_RETRIEVER.getValueName();
    private String tagNamesToGraph = null;
    private int dataPointsPerGraph = 20;
    private StatisticsChartGenerator chartGenerator;
    private AtomicLong numLoggedStatistics = new AtomicLong();
    private volatile boolean hasUnflushedData = false;
    private Level lastAppendedEventLevel = Level.INFO;
    private final AppenderAttachableImpl<LoggingEvent> downstreamAppenders = new AppenderAttachableImpl();

    public String getGraphType() {
        return this.graphType;
    }

    public void setGraphType(String graphType) {
        this.graphType = graphType;
    }

    public String getTagNamesToGraph() {
        return this.tagNamesToGraph;
    }

    public void setTagNamesToGraph(String tagNamesToGraph) {
        this.tagNamesToGraph = tagNamesToGraph;
    }

    public int getDataPointsPerGraph() {
        return this.dataPointsPerGraph;
    }

    public void setDataPointsPerGraph(int dataPointsPerGraph) {
        if (dataPointsPerGraph <= 0) {
            throw new IllegalArgumentException("The DataPointsPerGraph option must be positive");
        }
        this.dataPointsPerGraph = dataPointsPerGraph;
    }

    @Override
    public void start() {
        super.start();
        this.chartGenerator = this.createChartGenerator();
        if (this.getName() != null) {
            APPENDERS_BY_NAME.put(this.getName(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.flush();
            this.downstreamAppenders.detachAndStopAllAppenders();
        }
        super.stop();
    }

    protected StatisticsChartGenerator createChartGenerator() {
        StatsValueRetriever statsValueRetriever = StatsValueRetriever.DEFAULT_RETRIEVERS.get(this.getGraphType());
        if (statsValueRetriever == null) {
            throw new RuntimeException("Unknown GraphType: " + this.getGraphType() + ". See the StatsValueRetriever class for the list of acceptable types.");
        }
        GoogleChartGenerator retVal = new GoogleChartGenerator(statsValueRetriever);
        if (this.getTagNamesToGraph() != null) {
            HashSet<String> enabledTags = new HashSet<String>(Arrays.asList(MiscUtils.splitAndTrim(this.getTagNamesToGraph(), ",")));
            retVal.setEnabledTags(enabledTags);
        }
        return retVal;
    }

    public StatisticsChartGenerator getChartGenerator() {
        return this.chartGenerator;
    }

    public static GraphingStatisticsAppender getAppenderByName(String appenderName) {
        return APPENDERS_BY_NAME.get(appenderName);
    }

    public static Collection<GraphingStatisticsAppender> getAllGraphingStatisticsAppenders() {
        return Collections.unmodifiableCollection(APPENDERS_BY_NAME.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppender(Appender<LoggingEvent> appender) {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.addAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Appender<LoggingEvent>> iteratorForAppenders() {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.iteratorForAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Appender<LoggingEvent> getAppender(String name) {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.getAppender(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAttached(Appender<LoggingEvent> appender) {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.isAttached(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachAndStopAllAppenders() {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            this.downstreamAppenders.detachAndStopAllAppenders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detachAppender(Appender<LoggingEvent> appender) {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.detachAppender(appender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean detachAppender(String name) {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            return this.downstreamAppenders.detachAppender(name);
        }
    }

    @Override
    protected void append(LoggingEvent event) {
        Object logMessage;
        if (event.getArgumentArray() != null && event.getArgumentArray().length > 0 && (logMessage = event.getArgumentArray()[0]) instanceof GroupedTimingStatistics && this.chartGenerator != null) {
            this.chartGenerator.appendData((GroupedTimingStatistics)logMessage);
            this.hasUnflushedData = true;
            this.lastAppendedEventLevel = event.getLevel();
            if (this.numLoggedStatistics.incrementAndGet() % (long)this.getDataPointsPerGraph() == 0L) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        AppenderAttachableImpl<LoggingEvent> appenderAttachableImpl = this.downstreamAppenders;
        synchronized (appenderAttachableImpl) {
            if (this.hasUnflushedData) {
                this.downstreamAppenders.appendLoopOnAppenders(new LoggingEvent(Logger.class.getName(), (Logger)LoggerFactory.getLogger("org.perf4j.TimingLogger"), this.lastAppendedEventLevel, this.chartGenerator.getChartUrl(), null, null));
                this.hasUnflushedData = false;
            }
        }
    }
}

