/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Dataset;
import ome.xml.model.Experiment;
import ome.xml.model.ExperimentRef;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.ExperimenterGroupRef;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Folder;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.Instrument;
import ome.xml.model.InstrumentRef;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.MicrobeamManipulationRef;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Pixels;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.StageLabel;
import ome.xml.model.WellSample;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Image
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Image.class);
    private String id;
    private String name;
    private Timestamp acquisitionDate;
    private Experimenter experimenter;
    private String description;
    private Experiment experiment;
    private ExperimenterGroup experimenterGroup;
    private Instrument instrument;
    private ObjectiveSettings objectiveSettings;
    private ImagingEnvironment imagingEnvironment;
    private StageLabel stageLabel;
    private Pixels pixels;
    private List<ROI> roiLinks = new ReferenceList<ROI>();
    private List<MicrobeamManipulation> microbeamManipulationLinks = new ReferenceList<MicrobeamManipulation>();
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private List<Dataset> datasetLinks = new ReferenceList<Dataset>();
    private List<Folder> folderLinks = new ReferenceList<Folder>();
    private List<WellSample> wellSamples = new ReferenceList<WellSample>();

    public Image() {
    }

    public Image(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Image(Image orig) {
        this.id = orig.id;
        this.name = orig.name;
        this.acquisitionDate = orig.acquisitionDate;
        this.experimenter = orig.experimenter;
        this.description = orig.description;
        this.experiment = orig.experiment;
        this.experimenterGroup = orig.experimenterGroup;
        this.instrument = orig.instrument;
        this.objectiveSettings = orig.objectiveSettings;
        this.imagingEnvironment = orig.imagingEnvironment;
        this.stageLabel = orig.stageLabel;
        this.pixels = orig.pixels;
        this.roiLinks = orig.roiLinks;
        this.microbeamManipulationLinks = orig.microbeamManipulationLinks;
        this.annotationLinks = orig.annotationLinks;
        this.datasetLinks = orig.datasetLinks;
        this.folderLinks = orig.folderLinks;
        this.wellSamples = orig.wellSamples;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> Pixels_nodeList;
        List<Element> StageLabel_nodeList;
        List<Element> ImagingEnvironment_nodeList;
        List<Element> AcquisitionDate_nodeList;
        super.update(element, model);
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("Image missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if (element.hasAttribute("Name")) {
            this.setName(String.valueOf(element.getAttribute("Name")));
        }
        if ((AcquisitionDate_nodeList = Image.getChildrenByTagName(element, "AcquisitionDate")).size() > 1) {
            throw new RuntimeException(String.format("AcquisitionDate node list size %d != 1", AcquisitionDate_nodeList.size()));
        }
        if (AcquisitionDate_nodeList.size() != 0) {
            this.setAcquisitionDate(Timestamp.valueOf(AcquisitionDate_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimenterRef_nodeList = Image.getChildrenByTagName(element, "ExperimenterRef");
        for (Element ExperimenterRef_element : ExperimenterRef_nodeList) {
            ExperimenterRef experimenter_reference = new ExperimenterRef();
            experimenter_reference.setID(ExperimenterRef_element.getAttribute("ID"));
            model.addReference(this, experimenter_reference);
        }
        List<Element> Description_nodeList = Image.getChildrenByTagName(element, "Description");
        if (Description_nodeList.size() > 1) {
            throw new RuntimeException(String.format("Description node list size %d != 1", Description_nodeList.size()));
        }
        if (Description_nodeList.size() != 0) {
            this.setDescription(String.valueOf(Description_nodeList.get(0).getTextContent()));
        }
        List<Element> ExperimentRef_nodeList = Image.getChildrenByTagName(element, "ExperimentRef");
        for (Element element2 : ExperimentRef_nodeList) {
            ExperimentRef experimentRef = new ExperimentRef();
            experimentRef.setID(element2.getAttribute("ID"));
            model.addReference(this, experimentRef);
        }
        List<Element> ExperimenterGroupRef_nodeList = Image.getChildrenByTagName(element, "ExperimenterGroupRef");
        for (Element element3 : ExperimenterGroupRef_nodeList) {
            ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
            experimenterGroup_reference.setID(element3.getAttribute("ID"));
            model.addReference(this, experimenterGroup_reference);
        }
        List<Element> list = Image.getChildrenByTagName(element, "InstrumentRef");
        for (Element InstrumentRef_element : list) {
            InstrumentRef instrument_reference = new InstrumentRef();
            instrument_reference.setID(InstrumentRef_element.getAttribute("ID"));
            model.addReference(this, instrument_reference);
        }
        List<Element> list2 = Image.getChildrenByTagName(element, "ObjectiveSettings");
        if (list2.size() > 1) {
            throw new RuntimeException(String.format("ObjectiveSettings node list size %d != 1", list2.size()));
        }
        if (list2.size() != 0) {
            this.setObjectiveSettings(new ObjectiveSettings(list2.get(0), model));
        }
        if ((ImagingEnvironment_nodeList = Image.getChildrenByTagName(element, "ImagingEnvironment")).size() > 1) {
            throw new RuntimeException(String.format("ImagingEnvironment node list size %d != 1", ImagingEnvironment_nodeList.size()));
        }
        if (ImagingEnvironment_nodeList.size() != 0) {
            this.setImagingEnvironment(new ImagingEnvironment(ImagingEnvironment_nodeList.get(0), model));
        }
        if ((StageLabel_nodeList = Image.getChildrenByTagName(element, "StageLabel")).size() > 1) {
            throw new RuntimeException(String.format("StageLabel node list size %d != 1", StageLabel_nodeList.size()));
        }
        if (StageLabel_nodeList.size() != 0) {
            this.setStageLabel(new StageLabel(StageLabel_nodeList.get(0), model));
        }
        if ((Pixels_nodeList = Image.getChildrenByTagName(element, "Pixels")).size() > 1) {
            throw new RuntimeException(String.format("Pixels node list size %d != 1", Pixels_nodeList.size()));
        }
        if (Pixels_nodeList.size() != 0) {
            this.setPixels(new Pixels(Pixels_nodeList.get(0), model));
        }
        List<Element> ROIRef_nodeList = Image.getChildrenByTagName(element, "ROIRef");
        for (Element element4 : ROIRef_nodeList) {
            ROIRef roiLinks_reference = new ROIRef();
            roiLinks_reference.setID(element4.getAttribute("ID"));
            model.addReference(this, roiLinks_reference);
        }
        List<Element> MicrobeamManipulationRef_nodeList = Image.getChildrenByTagName(element, "MicrobeamManipulationRef");
        for (Element MicrobeamManipulationRef_element : MicrobeamManipulationRef_nodeList) {
            MicrobeamManipulationRef microbeamManipulationLinks_reference = new MicrobeamManipulationRef();
            microbeamManipulationLinks_reference.setID(MicrobeamManipulationRef_element.getAttribute("ID"));
            model.addReference(this, microbeamManipulationLinks_reference);
        }
        List<Element> list3 = Image.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : list3) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof ExperimenterRef) {
            Experimenter o_casted = (Experimenter)o;
            o_casted.linkImage(this);
            this.experimenter = o_casted;
            return true;
        }
        if (reference instanceof ExperimentRef) {
            Experiment o_casted = (Experiment)o;
            o_casted.linkImage(this);
            this.experiment = o_casted;
            return true;
        }
        if (reference instanceof ExperimenterGroupRef) {
            ExperimenterGroup o_casted = (ExperimenterGroup)o;
            o_casted.linkImage(this);
            this.experimenterGroup = o_casted;
            return true;
        }
        if (reference instanceof InstrumentRef) {
            Instrument o_casted = (Instrument)o;
            o_casted.linkImage(this);
            this.instrument = o_casted;
            return true;
        }
        if (reference instanceof ROIRef) {
            ROI o_casted = (ROI)o;
            o_casted.linkImage(this);
            this.roiLinks.add(o_casted);
            return true;
        }
        if (reference instanceof MicrobeamManipulationRef) {
            MicrobeamManipulation o_casted = (MicrobeamManipulation)o;
            o_casted.linkImage(this);
            this.microbeamManipulationLinks.add(o_casted);
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkImage(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Timestamp getAcquisitionDate() {
        return this.acquisitionDate;
    }

    public void setAcquisitionDate(Timestamp acquisitionDate) {
        this.acquisitionDate = acquisitionDate;
    }

    public Experimenter getLinkedExperimenter() {
        return this.experimenter;
    }

    public void linkExperimenter(Experimenter o) {
        this.experimenter = o;
    }

    public void unlinkExperimenter(Experimenter o) {
        if (this.experimenter == o) {
            this.experimenter = null;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Experiment getLinkedExperiment() {
        return this.experiment;
    }

    public void linkExperiment(Experiment o) {
        this.experiment = o;
    }

    public void unlinkExperiment(Experiment o) {
        if (this.experiment == o) {
            this.experiment = null;
        }
    }

    public ExperimenterGroup getLinkedExperimenterGroup() {
        return this.experimenterGroup;
    }

    public void linkExperimenterGroup(ExperimenterGroup o) {
        this.experimenterGroup = o;
    }

    public void unlinkExperimenterGroup(ExperimenterGroup o) {
        if (this.experimenterGroup == o) {
            this.experimenterGroup = null;
        }
    }

    public Instrument getLinkedInstrument() {
        return this.instrument;
    }

    public void linkInstrument(Instrument o) {
        this.instrument = o;
    }

    public void unlinkInstrument(Instrument o) {
        if (this.instrument == o) {
            this.instrument = null;
        }
    }

    public ObjectiveSettings getObjectiveSettings() {
        return this.objectiveSettings;
    }

    public void setObjectiveSettings(ObjectiveSettings objectiveSettings) {
        this.objectiveSettings = objectiveSettings;
    }

    public ImagingEnvironment getImagingEnvironment() {
        return this.imagingEnvironment;
    }

    public void setImagingEnvironment(ImagingEnvironment imagingEnvironment) {
        this.imagingEnvironment = imagingEnvironment;
    }

    public StageLabel getStageLabel() {
        return this.stageLabel;
    }

    public void setStageLabel(StageLabel stageLabel) {
        this.stageLabel = stageLabel;
    }

    public Pixels getPixels() {
        return this.pixels;
    }

    public void setPixels(Pixels pixels) {
        this.pixels = pixels;
    }

    public int sizeOfLinkedROIList() {
        return this.roiLinks.size();
    }

    public List<ROI> copyLinkedROIList() {
        return new ArrayList<ROI>(this.roiLinks);
    }

    public ROI getLinkedROI(int index) {
        return this.roiLinks.get(index);
    }

    public ROI setLinkedROI(int index, ROI o) {
        return this.roiLinks.set(index, o);
    }

    public boolean linkROI(ROI o) {
        o.linkImage(this);
        return this.roiLinks.add(o);
    }

    public boolean unlinkROI(ROI o) {
        o.unlinkImage(this);
        return this.roiLinks.remove(o);
    }

    public int sizeOfLinkedMicrobeamManipulationList() {
        return this.microbeamManipulationLinks.size();
    }

    public List<MicrobeamManipulation> copyLinkedMicrobeamManipulationList() {
        return new ArrayList<MicrobeamManipulation>(this.microbeamManipulationLinks);
    }

    public MicrobeamManipulation getLinkedMicrobeamManipulation(int index) {
        return this.microbeamManipulationLinks.get(index);
    }

    public MicrobeamManipulation setLinkedMicrobeamManipulation(int index, MicrobeamManipulation o) {
        return this.microbeamManipulationLinks.set(index, o);
    }

    public boolean linkMicrobeamManipulation(MicrobeamManipulation o) {
        o.linkImage(this);
        return this.microbeamManipulationLinks.add(o);
    }

    public boolean unlinkMicrobeamManipulation(MicrobeamManipulation o) {
        o.unlinkImage(this);
        return this.microbeamManipulationLinks.remove(o);
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkImage(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkImage(this);
        return this.annotationLinks.remove(o);
    }

    public int sizeOfLinkedDatasetList() {
        return this.datasetLinks.size();
    }

    public List<Dataset> copyLinkedDatasetList() {
        return new ArrayList<Dataset>(this.datasetLinks);
    }

    public Dataset getLinkedDataset(int index) {
        return this.datasetLinks.get(index);
    }

    public Dataset setLinkedDataset(int index, Dataset o) {
        return this.datasetLinks.set(index, o);
    }

    public boolean linkDataset(Dataset o) {
        return this.datasetLinks.add(o);
    }

    public boolean unlinkDataset(Dataset o) {
        return this.datasetLinks.remove(o);
    }

    public int sizeOfLinkedFolderList() {
        return this.folderLinks.size();
    }

    public List<Folder> copyLinkedFolderList() {
        return new ArrayList<Folder>(this.folderLinks);
    }

    public Folder getLinkedFolder(int index) {
        return this.folderLinks.get(index);
    }

    public Folder setLinkedFolder(int index, Folder o) {
        return this.folderLinks.set(index, o);
    }

    public boolean linkFolder(Folder o) {
        return this.folderLinks.add(o);
    }

    public boolean unlinkFolder(Folder o) {
        return this.folderLinks.remove(o);
    }

    public int sizeOfLinkedWellSampleList() {
        return this.wellSamples.size();
    }

    public List<WellSample> copyLinkedWellSampleList() {
        return new ArrayList<WellSample>(this.wellSamples);
    }

    public WellSample getLinkedWellSample(int index) {
        return this.wellSamples.get(index);
    }

    public WellSample setLinkedWellSample(int index, WellSample o) {
        return this.wellSamples.set(index, o);
    }

    public boolean linkWellSample(WellSample o) {
        return this.wellSamples.add(o);
    }

    public boolean unlinkWellSample(WellSample o) {
        return this.wellSamples.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Image_element) {
        Element child;
        Reference o;
        Element child2;
        Element child3;
        Reference o2;
        if (Image_element == null) {
            Image_element = document.createElementNS(NAMESPACE, "Image");
        }
        super.asXMLElement(document, Image_element);
        if (this.id != null) {
            Image_element.setAttribute("ID", this.id);
        }
        if (this.name != null) {
            Image_element.setAttribute("Name", this.name);
        }
        if (this.acquisitionDate != null) {
            Element acquisitionDate_element = document.createElementNS(NAMESPACE, "AcquisitionDate");
            acquisitionDate_element.setTextContent(this.acquisitionDate.toString());
            Image_element.appendChild(acquisitionDate_element);
        }
        if (this.experimenter != null) {
            o2 = new ExperimenterRef();
            ((ExperimenterRef)o2).setID(this.experimenter.getID());
            child3 = document.createElementNS(NAMESPACE, "ExperimenterRef");
            ((ExperimenterRef)o2).asXMLElement(document, child3);
            Image_element.appendChild(child3);
        }
        if (this.description != null) {
            Element description_element = document.createElementNS(NAMESPACE, "Description");
            description_element.setTextContent(this.description);
            Image_element.appendChild(description_element);
        }
        if (this.experiment != null) {
            o2 = new ExperimentRef();
            ((ExperimentRef)o2).setID(this.experiment.getID());
            child3 = document.createElementNS(NAMESPACE, "ExperimentRef");
            ((ExperimentRef)o2).asXMLElement(document, child3);
            Image_element.appendChild(child3);
        }
        if (this.experimenterGroup != null) {
            o2 = new ExperimenterGroupRef();
            ((ExperimenterGroupRef)o2).setID(this.experimenterGroup.getID());
            child3 = document.createElementNS(NAMESPACE, "ExperimenterGroupRef");
            ((ExperimenterGroupRef)o2).asXMLElement(document, child3);
            Image_element.appendChild(child3);
        }
        if (this.instrument != null) {
            o2 = new InstrumentRef();
            ((InstrumentRef)o2).setID(this.instrument.getID());
            child3 = document.createElementNS(NAMESPACE, "InstrumentRef");
            ((InstrumentRef)o2).asXMLElement(document, child3);
            Image_element.appendChild(child3);
        }
        if (this.objectiveSettings != null) {
            child2 = document.createElementNS(NAMESPACE, "ObjectiveSettings");
            this.objectiveSettings.asXMLElement(document, child2);
            Image_element.appendChild(child2);
        }
        if (this.imagingEnvironment != null) {
            child2 = document.createElementNS(NAMESPACE, "ImagingEnvironment");
            this.imagingEnvironment.asXMLElement(document, child2);
            Image_element.appendChild(child2);
        }
        if (this.stageLabel != null) {
            child2 = document.createElementNS(NAMESPACE, "StageLabel");
            this.stageLabel.asXMLElement(document, child2);
            Image_element.appendChild(child2);
        }
        if (this.pixels != null) {
            child2 = document.createElementNS(NAMESPACE, "Pixels");
            this.pixels.asXMLElement(document, child2);
            Image_element.appendChild(child2);
        }
        if (this.roiLinks != null) {
            for (ROI roiLinks_value : this.roiLinks) {
                o = new ROIRef();
                ((ROIRef)o).setID(roiLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "ROIRef");
                ((ROIRef)o).asXMLElement(document, child);
                Image_element.appendChild(child);
            }
        }
        if (this.microbeamManipulationLinks != null) {
            for (MicrobeamManipulation microbeamManipulationLinks_value : this.microbeamManipulationLinks) {
                o = new MicrobeamManipulationRef();
                ((MicrobeamManipulationRef)o).setID(microbeamManipulationLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "MicrobeamManipulationRef");
                ((MicrobeamManipulationRef)o).asXMLElement(document, child);
                Image_element.appendChild(child);
            }
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                o = new AnnotationRef();
                ((AnnotationRef)o).setID(annotationLinks_value.getID());
                child = document.createElementNS(NAMESPACE, "AnnotationRef");
                ((AnnotationRef)o).asXMLElement(document, child);
                Image_element.appendChild(child);
            }
        }
        return Image_element;
    }
}

