/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.transform.FastFourierTransformer;

public class FastCosineTransformer
implements Serializable {
    static final long serialVersionUID = -7673941545134707766L;

    public double[] transform(double[] f) throws MathException, IllegalArgumentException {
        return this.fct(f);
    }

    public double[] transform(UnivariateRealFunction f, double min2, double max, int n) throws MathException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min2, max, n);
        return this.fct(data);
    }

    public double[] transform2(double[] f) throws MathException, IllegalArgumentException {
        double scaling_coefficient = Math.sqrt(2.0 / (double)(f.length - 1));
        return FastFourierTransformer.scaleArray(this.fct(f), scaling_coefficient);
    }

    public double[] transform2(UnivariateRealFunction f, double min2, double max, int n) throws MathException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min2, max, n);
        double scaling_coefficient = Math.sqrt(2.0 / (double)(n - 1));
        return FastFourierTransformer.scaleArray(this.fct(data), scaling_coefficient);
    }

    public double[] inversetransform(double[] f) throws MathException, IllegalArgumentException {
        double scaling_coefficient = 2.0 / (double)(f.length - 1);
        return FastFourierTransformer.scaleArray(this.fct(f), scaling_coefficient);
    }

    public double[] inversetransform(UnivariateRealFunction f, double min2, double max, int n) throws MathException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min2, max, n);
        double scaling_coefficient = 2.0 / (double)(n - 1);
        return FastFourierTransformer.scaleArray(this.fct(data), scaling_coefficient);
    }

    public double[] inversetransform2(double[] f) throws MathException, IllegalArgumentException {
        return this.transform2(f);
    }

    public double[] inversetransform2(UnivariateRealFunction f, double min2, double max, int n) throws MathException, IllegalArgumentException {
        return this.transform2(f, min2, max, n);
    }

    protected double[] fct(double[] f) throws MathException, IllegalArgumentException {
        double[] F = new double[f.length];
        int N2 = f.length - 1;
        if (!FastFourierTransformer.isPowerOf2(N2)) {
            throw new IllegalArgumentException("Number of samples not power of 2 plus one: " + f.length);
        }
        if (N2 == 1) {
            F[0] = 0.5 * (f[0] + f[1]);
            F[1] = 0.5 * (f[0] - f[1]);
            return F;
        }
        double[] x = new double[N2];
        x[0] = 0.5 * (f[0] + f[N2]);
        x[N2 >> 1] = f[N2 >> 1];
        double F1 = 0.5 * (f[0] - f[N2]);
        for (int i = 1; i < N2 >> 1; ++i) {
            double A2 = 0.5 * (f[i] + f[N2 - i]);
            double B = Math.sin((double)i * Math.PI / (double)N2) * (f[i] - f[N2 - i]);
            double C2 = Math.cos((double)i * Math.PI / (double)N2) * (f[i] - f[N2 - i]);
            x[i] = A2 - B;
            x[N2 - i] = A2 + B;
            F1 += C2;
        }
        FastFourierTransformer transformer = new FastFourierTransformer();
        Complex[] y = transformer.transform(x);
        F[0] = y[0].getReal();
        F[1] = F1;
        for (int i = 1; i < N2 >> 1; ++i) {
            F[2 * i] = y[i].getReal();
            F[2 * i + 1] = F[2 * i - 1] - y[i].getImaginary();
        }
        F[N2] = y[N2 >> 1].getReal();
        return F;
    }
}

