/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.meta.MetadataStore;

public class LIMReader
extends FormatReader {
    private static final int PIXELS_OFFSET = 2379;
    private boolean isCompressed;

    public LIMReader() {
        super("Laboratory Imaging", "lim");
        this.domains = new String[]{"Light Microscopy"};
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(2379L);
        this.readPlane(this.in, x, y, w, h2, buf);
        if (this.isRGB()) {
            for (int i = 0; i < buf.length / 3; ++i) {
                byte tmp = buf[i * 3];
                buf[i * 3] = buf[i * 3 + 2];
                buf[i * 3 + 2] = tmp;
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.isCompressed = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        m4.littleEndian = true;
        this.in.order(this.isLittleEndian());
        m4.sizeX = this.in.readShort() & Short.MAX_VALUE;
        m4.sizeY = this.in.readShort();
        int bits = this.in.readShort();
        while (bits % 8 != 0) {
            ++bits;
        }
        if (bits % 3 == 0) {
            m4.sizeC = 3;
            bits /= 3;
        }
        m4.pixelType = FormatTools.pixelTypeFromBytes(bits / 8, false, false);
        this.isCompressed = this.in.readShort() != 0;
        this.addGlobalMeta("Is compressed", this.isCompressed);
        if (this.isCompressed) {
            throw new UnsupportedCompressionException("Compressed LIM files not supported.");
        }
        m4.imageCount = 1;
        m4.sizeZ = 1;
        m4.sizeT = 1;
        if (this.getSizeC() == 0) {
            m4.sizeC = 1;
        }
        m4.rgb = this.getSizeC() > 1;
        m4.dimensionOrder = "XYZCT";
        m4.indexed = false;
        m4.falseColor = false;
        m4.interleaved = true;
        m4.metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

