/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ShortBuffer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJCustomFilter;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;

public class TJExample
implements TJCustomFilter {
    public static final String classname = new TJExample().getClass().getName();
    private static final String[] sampName = new String[]{"4:4:4", "4:2:2", "4:2:0", "Grayscale", "4:4:0"};
    static TJScalingFactor[] sf = null;

    private static void usage() throws Exception {
        System.out.println("\nUSAGE: java " + classname + " <Input file> <Output file> [options]\n");
        System.out.println("Input and output files can be any image format that the Java Image I/O");
        System.out.println("extensions understand.  If either filename ends in a .jpg extension, then");
        System.out.println("TurboJPEG will be used to compress or decompress the file.\n");
        System.out.println("Options:\n");
        System.out.println("-scale M/N = if the input image is a JPEG file, scale the width/height of the");
        System.out.print("             output image by a factor of M/N (M/N = ");
        for (int i = 0; i < sf.length; ++i) {
            System.out.print(sf[i].getNum() + "/" + sf[i].getDenom());
            if (sf.length == 2 && i != sf.length - 1) {
                System.out.print(" or ");
                continue;
            }
            if (sf.length <= 2) continue;
            if (i != sf.length - 1) {
                System.out.print(", ");
            }
            if (i != sf.length - 2) continue;
            System.out.print("or ");
        }
        System.out.println(")\n");
        System.out.println("-samp <444|422|420|gray> = If the output image is a JPEG file, this specifies");
        System.out.println("                           the level of chrominance subsampling to use when");
        System.out.println("                           recompressing it.  Default is to use the same level");
        System.out.println("                           of subsampling as the input, if the input is a JPEG");
        System.out.println("                           file, or 4:4:4 otherwise.\n");
        System.out.println("-q <1-100> = If the output image is a JPEG file, this specifies the JPEG");
        System.out.println("             quality to use when recompressing it (default = 95).\n");
        System.out.println("-hflip, -vflip, -transpose, -transverse, -rot90, -rot180, -rot270 =");
        System.out.println("     If the input image is a JPEG file, perform the corresponding lossless");
        System.out.println("     transform prior to decompression (these options are mutually exclusive)\n");
        System.out.println("-grayscale = If the input image is a JPEG file, perform lossless grayscale");
        System.out.println("     conversion prior to decompression (can be combined with the other");
        System.out.println("     transforms above)\n");
        System.out.println("-crop X,Y,WxH = If the input image is a JPEG file, perform lossless cropping");
        System.out.println("     prior to decompression.  X,Y specifies the upper left corner of the");
        System.out.println("     cropping region, and WxH specifies its width and height.  X,Y must be");
        System.out.println("     evenly divible by the MCU block size (8x8 if the source image was");
        System.out.println("     compressed using no subsampling or grayscale, or 16x8 for 4:2:2 or 16x16");
        System.out.println("     for 4:2:0.)\n");
        System.out.println("-display = Display output image (Output file need not be specified in this");
        System.out.println("     case.)\n");
        System.out.println("-fastupsample = Use the fastest chrominance upsampling algorithm available in");
        System.out.println("     the underlying codec\n");
        System.out.println("-fastdct = Use the fastest DCT/IDCT algorithms available in the underlying");
        System.out.println("     codec\n");
        System.out.println("-accuratedct = Use the most accurate DCT/IDCT algorithms available in the");
        System.out.println("     underlying codec\n");
        System.exit(1);
    }

    public static void main(String[] argv) {
        BufferedImage img = null;
        byte[] bmpBuf = null;
        TJTransform xform = new TJTransform();
        int flags = 0;
        try {
            int height;
            int width;
            String[] inFileTokens;
            sf = TJ.getScalingFactors();
            if (argv.length < 2) {
                TJExample.usage();
            }
            TJScalingFactor scaleFactor = new TJScalingFactor(1, 1);
            String inFormat = "jpg";
            String outFormat = "jpg";
            int outSubsamp = -1;
            int outQual = 95;
            boolean display = false;
            if (argv.length > 1) {
                for (int i = 1; i < argv.length; ++i) {
                    if (argv[i].length() < 2) continue;
                    if (argv[i].length() > 2 && argv[i].substring(0, 3).equalsIgnoreCase("-sc")) {
                        String[] scaleArg;
                        boolean match = false;
                        if (i < argv.length - 1 && (scaleArg = argv[++i].split("/")).length == 2) {
                            TJScalingFactor tempsf = new TJScalingFactor(Integer.parseInt(scaleArg[0]), Integer.parseInt(scaleArg[1]));
                            for (int j = 0; j < sf.length; ++j) {
                                if (!tempsf.equals(sf[j])) continue;
                                scaleFactor = sf[j];
                                match = true;
                                break;
                            }
                        }
                        if (!match) {
                            TJExample.usage();
                        }
                    }
                    if (argv[i].equalsIgnoreCase("-h") || argv[i].equalsIgnoreCase("-?")) {
                        TJExample.usage();
                    }
                    if (argv[i].length() > 2 && argv[i].substring(0, 3).equalsIgnoreCase("-sa")) {
                        if (i < argv.length - 1) {
                            if (argv[++i].substring(0, 1).equalsIgnoreCase("g")) {
                                outSubsamp = 3;
                            } else if (argv[i].equals("444")) {
                                outSubsamp = 0;
                            } else if (argv[i].equals("422")) {
                                outSubsamp = 1;
                            } else if (argv[i].equals("420")) {
                                outSubsamp = 2;
                            } else {
                                TJExample.usage();
                            }
                        } else {
                            TJExample.usage();
                        }
                    }
                    if (argv[i].substring(0, 2).equalsIgnoreCase("-q")) {
                        if (i < argv.length - 1) {
                            int qual;
                            if ((qual = Integer.parseInt(argv[++i])) >= 1 && qual <= 100) {
                                outQual = qual;
                            } else {
                                TJExample.usage();
                            }
                        } else {
                            TJExample.usage();
                        }
                    }
                    if (argv[i].substring(0, 2).equalsIgnoreCase("-g")) {
                        xform.options |= 8;
                    }
                    if (argv[i].equalsIgnoreCase("-hflip")) {
                        xform.op = 1;
                    }
                    if (argv[i].equalsIgnoreCase("-vflip")) {
                        xform.op = 2;
                    }
                    if (argv[i].equalsIgnoreCase("-transpose")) {
                        xform.op = 3;
                    }
                    if (argv[i].equalsIgnoreCase("-transverse")) {
                        xform.op = 4;
                    }
                    if (argv[i].equalsIgnoreCase("-rot90")) {
                        xform.op = 5;
                    }
                    if (argv[i].equalsIgnoreCase("-rot180")) {
                        xform.op = 6;
                    }
                    if (argv[i].equalsIgnoreCase("-rot270")) {
                        xform.op = 7;
                    }
                    if (argv[i].equalsIgnoreCase("-custom")) {
                        xform.cf = new TJExample();
                    } else if (argv[i].length() > 2 && argv[i].substring(0, 2).equalsIgnoreCase("-c")) {
                        String[] dimArg;
                        String[] cropArg;
                        if (i >= argv.length - 1) {
                            TJExample.usage();
                        }
                        if ((cropArg = argv[++i].split(",")).length != 3) {
                            TJExample.usage();
                        }
                        if ((dimArg = cropArg[2].split("[xX]")).length != 2) {
                            TJExample.usage();
                        }
                        int tempx = Integer.parseInt(cropArg[0]);
                        int tempy = Integer.parseInt(cropArg[1]);
                        int tempw = Integer.parseInt(dimArg[0]);
                        int temph = Integer.parseInt(dimArg[1]);
                        if (tempx < 0 || tempy < 0 || tempw < 0 || temph < 0) {
                            TJExample.usage();
                        }
                        xform.x = tempx;
                        xform.y = tempy;
                        xform.width = tempw;
                        xform.height = temph;
                        xform.options |= 4;
                    }
                    if (argv[i].substring(0, 2).equalsIgnoreCase("-d")) {
                        display = true;
                    }
                    if (argv[i].equalsIgnoreCase("-fastupsample")) {
                        System.out.println("Using fast upsampling code");
                        flags |= 0x100;
                    }
                    if (argv[i].equalsIgnoreCase("-fastdct")) {
                        System.out.println("Using fastest DCT/IDCT algorithm");
                        flags |= 0x800;
                    }
                    if (!argv[i].equalsIgnoreCase("-accuratedct")) continue;
                    System.out.println("Using most accurate DCT/IDCT algorithm");
                    flags |= 0x1000;
                }
            }
            if ((inFileTokens = argv[0].split("\\.")).length > 1) {
                inFormat = inFileTokens[inFileTokens.length - 1];
            }
            if (display) {
                outFormat = "bmp";
            } else {
                String[] outFileTokens = argv[1].split("\\.");
                if (outFileTokens.length > 1) {
                    outFormat = outFileTokens[outFileTokens.length - 1];
                }
            }
            File file2 = new File(argv[0]);
            if (inFormat.equalsIgnoreCase("jpg")) {
                TJDecompressor tjd;
                FileInputStream fis = new FileInputStream(file2);
                int inputSize = fis.available();
                if (inputSize < 1) {
                    System.out.println("Input file contains no data");
                    System.exit(1);
                }
                byte[] inputBuf = new byte[inputSize];
                fis.read(inputBuf);
                fis.close();
                if (xform.op != 0 || xform.options != 0 || xform.cf != null) {
                    TJTransformer tjt = new TJTransformer(inputBuf);
                    TJTransform[] t2 = new TJTransform[]{xform};
                    t2[0].options |= 2;
                    TJDecompressor[] tjdx = tjt.transform(t2, 0);
                    tjd = tjdx[0];
                } else {
                    tjd = new TJDecompressor(inputBuf);
                }
                width = tjd.getWidth();
                height = tjd.getHeight();
                int inSubsamp = tjd.getSubsamp();
                System.out.println("Source Image: " + width + " x " + height + " pixels, " + sampName[inSubsamp] + " subsampling");
                if (outSubsamp < 0) {
                    outSubsamp = inSubsamp;
                }
                if (outFormat.equalsIgnoreCase("jpg") && (xform.op != 0 || xform.options != 0) && scaleFactor.isOne()) {
                    file2 = new File(argv[1]);
                    FileOutputStream fos = new FileOutputStream(file2);
                    fos.write(tjd.getJPEGBuf(), 0, tjd.getJPEGSize());
                    fos.close();
                    System.exit(0);
                }
                width = scaleFactor.getScaled(width);
                height = scaleFactor.getScaled(height);
                if (!outFormat.equalsIgnoreCase("jpg")) {
                    img = tjd.decompress(width, height, 1, flags);
                } else {
                    bmpBuf = tjd.decompress(width, 0, height, 3, flags);
                }
                tjd.close();
            } else {
                img = ImageIO.read(file2);
                width = img.getWidth();
                height = img.getHeight();
                if (outSubsamp < 0) {
                    outSubsamp = img.getType() == 10 ? 3 : 0;
                }
            }
            System.gc();
            if (!display) {
                System.out.print("Dest. Image (" + outFormat + "):  " + width + " x " + height + " pixels");
            }
            if (display) {
                ImageIcon icon = new ImageIcon(img);
                JLabel label = new JLabel(icon, 0);
                JOptionPane.showMessageDialog(null, label, "Output Image", -1);
            } else if (outFormat.equalsIgnoreCase("jpg")) {
                byte[] jpegBuf;
                System.out.println(", " + sampName[outSubsamp] + " subsampling, quality = " + outQual);
                TJCompressor tjc = new TJCompressor();
                tjc.setSubsamp(outSubsamp);
                tjc.setJPEGQuality(outQual);
                if (img != null) {
                    jpegBuf = tjc.compress(img, flags);
                } else {
                    tjc.setSourceImage(bmpBuf, width, 0, height, 3);
                    jpegBuf = tjc.compress(flags);
                }
                int jpegSize = tjc.getCompressedSize();
                tjc.close();
                file2 = new File(argv[1]);
                FileOutputStream fos = new FileOutputStream(file2);
                fos.write(jpegBuf, 0, jpegSize);
                fos.close();
            } else {
                System.out.print("\n");
                file2 = new File(argv[1]);
                ImageIO.write((RenderedImage)img, outFormat, file2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void customFilter(ShortBuffer coeffBuffer, Rectangle bufferRegion, Rectangle planeRegion, int componentIndex, int transformIndex, TJTransform transform) throws Exception {
        for (int i = 0; i < bufferRegion.width * bufferRegion.height; ++i) {
            coeffBuffer.put(i, -coeffBuffer.get(i));
        }
    }
}

