/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import hdf.hdf5lib.exceptions.HDF5JavaException;

abstract class HDF5AbstractStorageFeatures {
    public static final byte NO_DEFLATION_LEVEL = 0;
    public static final byte DEFAULT_DEFLATION_LEVEL = 6;
    public static final byte MAX_DEFLATION_LEVEL = 9;
    static final byte NO_SCALING_FACTOR = -1;
    private final byte deflateLevel;
    private final byte scalingFactor;
    private final DataSetReplacementPolicy datasetReplacementPolicy;
    private final HDF5StorageLayout proposedLayoutOrNull;
    private final boolean shuffleBeforeDeflate;

    static byte toByte(int i) {
        byte b = (byte)i;
        if (b != i) {
            throw new HDF5JavaException("Value " + i + " cannot be casted to type byte");
        }
        return b;
    }

    HDF5AbstractStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, DataSetReplacementPolicy datasetReplacementPolicy, byte deflateLevel, byte scalingFactor) {
        this(proposedLayoutOrNull, datasetReplacementPolicy, false, deflateLevel, scalingFactor);
    }

    HDF5AbstractStorageFeatures(HDF5StorageLayout proposedLayoutOrNull, DataSetReplacementPolicy datasetReplacementPolicy, boolean shuffleBeforeDeflate, byte deflateLevel, byte scalingFactor) {
        if (deflateLevel < 0) {
            throw new IllegalArgumentException("Invalid deflateLevel " + deflateLevel);
        }
        this.proposedLayoutOrNull = proposedLayoutOrNull;
        this.datasetReplacementPolicy = datasetReplacementPolicy;
        this.shuffleBeforeDeflate = shuffleBeforeDeflate;
        this.deflateLevel = deflateLevel;
        this.scalingFactor = scalingFactor;
    }

    abstract boolean isCompatibleWithDataClass(int var1);

    public HDF5StorageLayout tryGetProposedLayout() {
        return this.proposedLayoutOrNull;
    }

    public DataSetReplacementPolicy getDatasetReplacementPolicy() {
        return this.datasetReplacementPolicy;
    }

    boolean requiresChunking() {
        return this.isDeflating() || this.isScaling() || this.proposedLayoutOrNull == HDF5StorageLayout.CHUNKED;
    }

    boolean allowsCompact() {
        return this.proposedLayoutOrNull == null || this.proposedLayoutOrNull == HDF5StorageLayout.COMPACT;
    }

    public boolean isDeflating() {
        return this.deflateLevel != 0;
    }

    public boolean isScaling() {
        return this.scalingFactor >= 0;
    }

    public boolean isShuffleBeforeDeflate() {
        return this.shuffleBeforeDeflate;
    }

    public byte getDeflateLevel() {
        return this.deflateLevel;
    }

    public byte getScalingFactor() {
        return this.scalingFactor;
    }

    static DataSetReplacementPolicy getDataSetReplacementPolicy(boolean keepDataSetIfExists, boolean deleteDataSetIfExists) {
        return keepDataSetIfExists ? DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING : (deleteDataSetIfExists ? DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW : DataSetReplacementPolicy.USE_WRITER_DEFAULT);
    }

    public static enum DataSetReplacementPolicy {
        USE_WRITER_DEFAULT,
        ENFORCE_KEEP_EXISTING,
        ENFORCE_REPLACE_WITH_NEW;

    }

    public static abstract class HDF5AbstractStorageFeatureBuilder {
        private byte deflateLevel;
        private byte scalingFactor;
        private HDF5StorageLayout storageLayout;
        private DataSetReplacementPolicy datasetReplacementPolicy = DataSetReplacementPolicy.USE_WRITER_DEFAULT;
        private boolean shuffleBeforeDeflate;

        HDF5AbstractStorageFeatureBuilder() {
        }

        public HDF5AbstractStorageFeatureBuilder(HDF5AbstractStorageFeatures template) {
            this.deflateLevel(template.getDeflateLevel());
            this.scalingFactor(template.getScalingFactor());
            this.storageLayout(template.tryGetProposedLayout());
            this.datasetReplacementPolicy(template.getDatasetReplacementPolicy());
            this.shuffleBeforeDeflate(template.isShuffleBeforeDeflate());
        }

        byte getDeflateLevel() {
            return this.deflateLevel;
        }

        byte getScalingFactor() {
            return this.scalingFactor;
        }

        HDF5StorageLayout getStorageLayout() {
            return this.storageLayout;
        }

        DataSetReplacementPolicy getDatasetReplacementPolicy() {
            return this.datasetReplacementPolicy;
        }

        boolean isShuffleBeforeDeflate() {
            return this.shuffleBeforeDeflate;
        }

        public HDF5AbstractStorageFeatureBuilder compress(boolean compress) {
            this.deflateLevel = (byte)(compress ? 6 : 0);
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder compress() {
            this.deflateLevel = (byte)6;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder deflateLevel(byte deflateLevel) {
            this.deflateLevel = deflateLevel;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder scalingFactor(byte scalingFactor) {
            this.scalingFactor = scalingFactor;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder noScaling() {
            this.scalingFactor = (byte)-1;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder shuffleBeforeDeflate(boolean shuffleBeforeDeflate) {
            this.shuffleBeforeDeflate = shuffleBeforeDeflate;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder shuffleBeforeDeflate() {
            this.shuffleBeforeDeflate = true;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder noShuffleBeforeDeflate() {
            this.shuffleBeforeDeflate = true;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder storageLayout(HDF5StorageLayout storageLayout) {
            this.storageLayout = storageLayout;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder compactStorageLayout() {
            this.storageLayout = HDF5StorageLayout.COMPACT;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder contiguousStorageLayout() {
            this.storageLayout = HDF5StorageLayout.CONTIGUOUS;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder chunkedStorageLayout() {
            this.storageLayout = HDF5StorageLayout.CHUNKED;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder defaultStorageLayout() {
            this.storageLayout = null;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder datasetReplacementPolicy(DataSetReplacementPolicy datasetReplacementPolicy) {
            this.datasetReplacementPolicy = datasetReplacementPolicy;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder datasetReplacementUseWriterDefault() {
            this.datasetReplacementPolicy = DataSetReplacementPolicy.USE_WRITER_DEFAULT;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder datasetReplacementEnforceKeepExisting() {
            this.datasetReplacementPolicy = DataSetReplacementPolicy.ENFORCE_KEEP_EXISTING;
            return this;
        }

        public HDF5AbstractStorageFeatureBuilder datasetReplacementEnforceReplaceWithNew() {
            this.datasetReplacementPolicy = DataSetReplacementPolicy.ENFORCE_REPLACE_WITH_NEW;
            return this;
        }

        public abstract HDF5AbstractStorageFeatures features();
    }
}

