/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import java.util.Arrays;

public class HDF5TimeDurationArray {
    final long[] timeDurations;
    final HDF5TimeUnit timeUnit;

    public HDF5TimeDurationArray(long[] timeDurations, HDF5TimeUnit timeUnit) {
        this.timeDurations = timeDurations;
        this.timeUnit = timeUnit;
    }

    public static HDF5TimeDurationArray create(HDF5TimeUnit timeUnit, long ... durationValues) {
        if (durationValues.length == 0) {
            return new HDF5TimeDurationArray(new long[0], timeUnit);
        }
        return new HDF5TimeDurationArray(durationValues, timeUnit);
    }

    public static HDF5TimeDurationArray create(HDF5TimeDuration ... timeDurations) {
        if (timeDurations.length == 0) {
            return new HDF5TimeDurationArray(new long[0], HDF5TimeUnit.SECONDS);
        }
        HDF5TimeUnit unit = timeDurations[0].getUnit();
        boolean needsConversion = false;
        int i = 1;
        while (i < timeDurations.length) {
            HDF5TimeUnit u = timeDurations[i].getUnit();
            if (u != unit) {
                if (u.ordinal() < unit.ordinal()) {
                    unit = u;
                }
                needsConversion = true;
            }
            ++i;
        }
        long[] durations = new long[timeDurations.length];
        if (needsConversion) {
            int i2 = 0;
            while (i2 < timeDurations.length) {
                durations[i2] = unit.convert(timeDurations[i2]);
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < timeDurations.length) {
                durations[i3] = timeDurations[i3].getValue();
                ++i3;
            }
        }
        return new HDF5TimeDurationArray(durations, unit);
    }

    public HDF5TimeUnit getUnit() {
        return this.timeUnit;
    }

    public long[] getValues() {
        return this.timeDurations;
    }

    public int getLength() {
        return this.timeDurations.length;
    }

    public long[] getValues(HDF5TimeUnit targetUnit) {
        if (targetUnit == this.timeUnit) {
            return this.timeDurations;
        }
        long[] targetDurations = new long[this.timeDurations.length];
        int i = 0;
        while (i < targetDurations.length) {
            targetDurations[i] = targetUnit.convert(this.timeDurations[i], this.timeUnit);
            ++i;
        }
        return targetDurations;
    }

    public HDF5TimeDuration get(int index) {
        return new HDF5TimeDuration(this.timeDurations[index], this.timeUnit);
    }

    public HDF5TimeDuration get(int index, HDF5TimeUnit targetUnit) {
        if (targetUnit == this.timeUnit) {
            return new HDF5TimeDuration(this.timeDurations[index], this.timeUnit);
        }
        return new HDF5TimeDuration(targetUnit.convert(this.timeDurations[index], this.timeUnit), targetUnit);
    }

    public long getValue(int index) {
        return this.timeDurations[index];
    }

    public long getValue(int index, HDF5TimeUnit targetUnit) {
        return targetUnit == this.timeUnit ? this.timeDurations[index] : targetUnit.convert(this.timeDurations[index], this.timeUnit);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.timeDurations);
        result = 31 * result + (this.timeUnit == null ? 0 : this.timeUnit.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5TimeDurationArray other = (HDF5TimeDurationArray)obj;
        if (!Arrays.equals(this.timeDurations, other.timeDurations)) {
            return false;
        }
        return this.timeUnit == other.timeUnit;
    }

    public String toString() {
        return "HDF5TimeDurationArray [timeDurations=" + Arrays.toString(this.timeDurations) + ", timeUnit=" + (Object)((Object)this.timeUnit) + "]";
    }
}

