/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import loci.formats.FormatException;
import loci.formats.MetadataTools;
import loci.formats.in.DeltavisionReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class RCPNLReader
extends DeltavisionReader {
    public RCPNLReader() {
        this.format = "RCPNL";
        this.suffixes = new String[]{"rcpnl"};
        this.suffixNecessary = true;
        this.hasCompanionFiles = false;
        this.positionInT = true;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        return RCPNLReader.checkSuffix(name, "rcpnl") && super.isThisType(name, open);
    }

    @Override
    protected void populateObjective(MetadataStore store, int lensID) throws FormatException {
        super.populateObjective(store, lensID);
        switch (lensID) {
            case 18107: {
                store.setObjectiveNominalMagnification(10.0, 0, 0);
                store.setObjectiveLensNA(0.3, 0, 0);
                store.setObjectiveWorkingDistance(new Length(15.0, UNITS.MILLIMETER), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion("Air"), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanFluor"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18108: {
                store.setObjectiveNominalMagnification(20.0, 0, 0);
                store.setObjectiveLensNA(0.75, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18109: {
                store.setObjectiveNominalMagnification(40.0, 0, 0);
                store.setObjectiveLensNA(0.95, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18110: {
                store.setObjectiveNominalMagnification(40.0, 0, 0);
                store.setObjectiveLensNA(0.6, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanFluor"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18111: {
                store.setObjectiveNominalMagnification(4.0, 0, 0);
                store.setObjectiveLensNA(0.2, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18112: {
                store.setObjectiveNominalMagnification(20.0, 0, 0);
                store.setObjectiveLensNA(0.8, 0, 0);
                store.setObjectiveWorkingDistance(new Length(0.8, UNITS.MILLIMETER), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion("Air"), 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanApo"), 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18113: {
                store.setObjectiveNominalMagnification(10.0, 0, 0);
                store.setObjectiveLensNA(0.45, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanApo"), 0, 0);
                store.setObjectiveWorkingDistance(new Length(4.0, UNITS.MILLIMETER), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion("Air"), 0, 0);
                store.setObjectiveModel("MRD70170", 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
                break;
            }
            case 18114: {
                store.setObjectiveNominalMagnification(4.0, 0, 0);
                store.setObjectiveLensNA(0.13, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection("PlanFluor"), 0, 0);
                store.setObjectiveWorkingDistance(new Length(17.2, UNITS.MILLIMETER), 0, 0);
                store.setObjectiveImmersion(MetadataTools.getImmersion("Air"), 0, 0);
                store.setObjectiveModel("MRH00045", 0, 0);
                store.setObjectiveManufacturer("Nikon", 0, 0);
            }
        }
    }
}

