/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import loci.formats.UpgradeChecker;

public class UpgradeCheck {
    public static void main(String[] args) {
        boolean doInstall;
        if (args.length > 0 && args[0].equals("-help")) {
            System.out.println("Usage:");
            System.out.println("  java UpgradeCheck [-install X]");
            System.out.println();
            System.out.println("    If no options are specified, an upgrade check");
            System.out.println("    will be performed but no new version will be");
            System.out.println("    downloaded.");
            System.out.println("    With the '-install' option, a version must be");
            System.out.println("    specified; valid values are 'STABLE', 'TRUNK',");
            System.out.println("    and 'DAILY'.  The corresponding build will be");
            System.out.println("    downloaded to the working directory.");
            System.exit(0);
        }
        UpgradeChecker checker = new UpgradeChecker();
        boolean bl = doInstall = args.length > 0 && args[0].equals("-install");
        if (checker.newVersionAvailable("Bio-Formats utilities")) {
            System.out.println("A newer stable version is available.");
        } else {
            System.out.println("A newer stable version is not available.");
        }
        if (doInstall && args.length > 1) {
            String url = "";
            if (args[1].equals("TRUNK")) {
                url = "http://ci.openmicroscopy.org/job/BIOFORMATS-5.1-latest/lastSuccessfulBuild/artifact/artifacts/";
            } else if (args[1].equals("DAILY")) {
                url = "http://ci.openmicroscopy.org/job/BIOFORMATS-5.1-daily/lastSuccessfulBuild/artifact/artifacts/";
            } else if (args[1].equals("STABLE")) {
                url = "http://downloads.openmicroscopy.org/bio-formats/latest/artifacts/";
            }
            url = url + "bioformats_package.jar";
            checker.install(url, "bioformats_package.jar");
        }
    }
}

